/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder;

import java.awt.Component;
import java.text.Format;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.IMEMode;
import jp.sf.beanbinder.Ref;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.validator.Validator;

public final class BindFactory {
    private BindFactory() {
    }

    public static final Bind createBind(String objectKey, Component component, String property) {
        return BindFactory.createBind(objectKey, component, property, null);
    }

    public static final Bind createBind(String objectKey, Component component, String property, Validator validator) {
        Bind bind = new Bind(objectKey, component);
        BindProperty prop = new BindProperty(property, new Ref(property));
        prop.setValidator(validator);
        bind.addProperty(prop);
        return bind;
    }

    public static final Bind createBindForText(String objectKey, Component component, String property, IMEMode imeMode, Format format) {
        return BindFactory.createBindForText(objectKey, component, property, imeMode, format, null);
    }

    public static final Bind createBindForText(String objectKey, Component component, String property, IMEMode imeMode, Format format, Validator validator) {
        Bind bind = new Bind(objectKey, component);
        BindProperty prop = new BindProperty(property, new Ref(property));
        prop.setImeMode(imeMode == null ? IMEMode.DEFAULT : imeMode);
        prop.setFormat(format);
        prop.setValidator(validator);
        bind.addProperty(prop);
        return bind;
    }

    public static final Bind createBindForCombo(String objectKey, Component component, String targetProp, String targetIdentity, String dataSourceKey, String displayProp, String dataSrcProp, String dataSrcIdentity) {
        Bind bind = new Bind(objectKey, component);
        bind.setDataSource(dataSourceKey);
        BindProperty prop = new BindProperty(displayProp, new Ref(targetProp, targetIdentity), new Ref(dataSrcProp, dataSrcIdentity));
        bind.addProperty(prop);
        return bind;
    }

    public static final Bind createBindForComboCellEditor(Component component, String dataSourceKey, String displayProp, String dataSrcProp) {
        Bind bind = new Bind(null, component);
        bind.setDataSource(dataSourceKey);
        BindProperty prop = new BindProperty(displayProp, new Ref(null, null), new Ref(dataSrcProp, null));
        bind.addProperty(prop);
        return bind;
    }

    public static final Bind createBindForList(String objectKey, Component component, String targetProp, String targetIdentity, String dataSourceKey, String displayProp, String dataSrcProp, String dataSrcIdentity) {
        return BindFactory.createBindForCombo(objectKey, component, targetProp, targetIdentity, dataSourceKey, displayProp, dataSrcProp, dataSrcIdentity);
    }

    public static final Bind createBindForTable(String objectKey, Component component, BindProperty[] columns) {
        Bind bind = new Bind(objectKey, component);
        int i = 0;
        while (i < columns.length) {
            BindProperty prop = columns[i];
            bind.addProperty(prop);
            ++i;
        }
        return bind;
    }

    public static final BindProperty createColumn(String text, String property, IMEMode imeMode, Format format, boolean readOnly) {
        return BindFactory.createColumn(text, property, imeMode, format, null, readOnly);
    }

    public static final BindProperty createColumn(String text, String property, IMEMode imeMode, Format format, Validator validator, boolean readOnly) {
        BindProperty prop = new BindProperty(property, new Ref(property));
        prop.getColumnProperty().setText(text);
        prop.setEditable(!readOnly);
        prop.setValidator(validator);
        return prop;
    }

    public static final BindProperty createColumn(String text, String property, boolean readOnly) {
        return BindFactory.createColumn(text, property, IMEMode.DEFAULT, null, readOnly);
    }

    public static final BindProperty createColumn(String text, String displayProp, String targetProp, CellEditor cellEditor) {
        BindProperty prop = new BindProperty(displayProp, new Ref(targetProp));
        prop.getColumnProperty().setText(text);
        prop.setEditable(true);
        prop.getColumnProperty().setCellEditor(cellEditor);
        return prop;
    }

    public static final BindProperty createColumn(String text, String displayProp, String targetProp, Format format, CellEditor cellEditor) {
        BindProperty prop = new BindProperty(displayProp, new Ref(targetProp));
        prop.getColumnProperty().setText(text);
        prop.setEditable(true);
        prop.setFormat(format);
        prop.getColumnProperty().setCellEditor(cellEditor);
        return prop;
    }

    public static final BindProperty createColumn(String text, String displayProp, String targetProp, CellEditor cellEditor, CellRenderer cellRenderer) {
        BindProperty prop = BindFactory.createColumn(text, displayProp, targetProp, cellEditor);
        prop.getColumnProperty().setCellRenderer(cellRenderer);
        return prop;
    }

    public static final BindProperty createColumn(String text, String displayProp, String targetProp, Format format, CellEditor cellEditor, CellRenderer cellRenderer) {
        BindProperty prop = BindFactory.createColumn(text, displayProp, targetProp, format, cellEditor);
        prop.getColumnProperty().setCellRenderer(cellRenderer);
        return prop;
    }
}

