/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindStrategyDispatcher;
import jp.sf.beanbinder.ProxyInterceptor;
import jp.sf.beanbinder.exception.ValidateException;
import jp.sf.beanbinder.strategy.ComponentStrategy;
import jp.sf.beanbinder.strategy.swing.Selectable;
import jp.sf.beanbinder.strategy.swing.SingleSelectable;
import jp.sf.beanbinder.util.BeanProcessBridge;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public final class BeanBinder {
    protected Map bindMap = new HashMap();
    private Map objectMap = new HashMap();
    private BindStrategyDispatcher bindStrategyDisplatcher;

    BeanBinder(BindStrategyDispatcher bindStrategy) {
        this.bindStrategyDisplatcher = bindStrategy;
    }

    public Bind bind(String bindKey, Bind bind) {
        this.bindMap.put(bindKey, bind);
        bind.setName(bindKey);
        return bind;
    }

    public Bind bind(String bindKey, String objectKey, Component component) {
        Bind bind = new Bind(objectKey, component);
        return this.bind(bindKey, bind);
    }

    public Object createProxyObject(String objectKey, Class type) {
        try {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(type);
            enhancer.setCallback((Callback)new ProxyInterceptor(this, objectKey));
            Object newInstance = enhancer.create();
            this.setObject(objectKey, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setObject(String objectKey, Object object) {
        this.objectMap.put(objectKey, object);
    }

    public Object getObject(String objectKey) {
        String[] props = objectKey.split("[.]");
        Object bean = this.objectMap.get(props[0]);
        if (props.length <= 1) {
            return bean;
        }
        String propertyPath = "";
        int i = 1;
        while (i < props.length) {
            propertyPath = String.valueOf(propertyPath) + props[i];
            if (i != props.length - 1) {
                propertyPath = String.valueOf(propertyPath) + ".";
            }
            ++i;
        }
        try {
            return BeanProcessBridge.getPropertyValue(bean, propertyPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject(String objectKey, String property) {
        try {
            return BeanProcessBridge.getPropertyValue(this.getObject(objectKey), property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSelectedValue(String bindKey, Object[] objects) {
        Bind bind = (Bind)this.bindMap.get(bindKey);
        ComponentStrategy strategy = this.bindStrategyDisplatcher.getStrategy(bind.getComponent());
        if (!(strategy instanceof Selectable)) {
            throw new RuntimeException("this component is unsupport");
        }
        ((Selectable)((Object)strategy)).selectBean(bind, bind.getComponent(), objects);
    }

    public void setSelectedValue(String bindKey, Object object) {
        this.setSelectedValue(bindKey, new Object[]{object});
    }

    public Object[] getSelectedValues(String bindKey) {
        Bind bind = (Bind)this.bindMap.get(bindKey);
        if (bind == null) {
            throw new RuntimeException("\u6307\u5b9a\u3057\u305f\u30ad\u30fc\u540d\u306f\u672a\u767b\u9332\u3067\u3059\u3002:" + bindKey);
        }
        ComponentStrategy strategy = this.bindStrategyDisplatcher.getStrategy(bind.getComponent());
        if (strategy instanceof Selectable) {
            return ((Selectable)((Object)strategy)).getSelectedBean(bind, bind.getComponent());
        }
        throw new RuntimeException("\u3053\u306e\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306b\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002:" + bind.getComponent());
    }

    public Object getSelectedValue(String bindKey) {
        if (this.getSelectedValues(bindKey) == null) {
            return null;
        }
        return this.getSelectedValues(bindKey)[0];
    }

    public Object getComponentValue(String bindKey) {
        Bind bind = (Bind)this.bindMap.get(bindKey);
        ComponentStrategy strategy = this.bindStrategyDisplatcher.getStrategy(bind.getComponent());
        return strategy.getValue(bind, bind.getComponent());
    }

    protected Object getComponent(String bindKey) {
        return ((Bind)this.bindMap.get(bindKey)).getComponent();
    }

    public Bind getBind(String bindKey) {
        return (Bind)this.bindMap.get(bindKey);
    }

    public Bind getBindByComponent(Object component) {
        Iterator itr = this.bindMap.values().iterator();
        while (itr.hasNext()) {
            Bind bind = (Bind)itr.next();
            if (!component.equals(bind.getComponent())) continue;
            return bind;
        }
        return null;
    }

    public void updateComponent(String bindKey) {
        Pattern pattern = Pattern.compile(bindKey);
        Iterator itr = this.bindMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!pattern.matcher(key).matches()) continue;
            this._updateComponent(key);
        }
    }

    public void updateComponentByGroup(String group) {
        Pattern pattern = Pattern.compile(group);
        Iterator itr = this.bindMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Bind bind = (Bind)this.bindMap.get(key);
            if (!pattern.matcher(bind.getGroup()).matches()) continue;
            this._updateComponent(key);
        }
    }

    private void _updateComponent(String name) {
        Bind bind = (Bind)this.bindMap.get(name);
        if (bind == null || !bind.isEnable()) {
            return;
        }
        Object bean = this.getObject(bind.getDataSource());
        if (bean == null) {
            ComponentStrategy strategy = this.bindStrategyDisplatcher.getStrategy(bind.getComponent());
            strategy.updateComponent(bind, bind.getComponent());
            return;
        }
        if (!(bean instanceof Collection)) {
            try {
                bean = BeanProcessBridge.getPropertyValue(bean, bind.getProperty(0).getDisplayProperty());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ComponentStrategy strategy = this.bindStrategyDisplatcher.getStrategy(bind.getComponent());
        try {
            strategy.updateDisplay(bind, bind.getComponent(), bean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (strategy instanceof SingleSelectable) {
            try {
                bean = this.getObject(bind.getTarget());
                ((SingleSelectable)((Object)strategy)).selectBean(bind, bind.getComponent(), new Object[]{bean});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateAllObjects() throws ValidateException {
        this.updateObject(".*");
    }

    public void updateObject(String objectKey) throws ValidateException {
        Pattern pattern = Pattern.compile(objectKey);
        Iterator itr = this.bindMap.values().iterator();
        while (itr.hasNext()) {
            Bind bind = (Bind)itr.next();
            if (!bind.isEnable() || bind.getTarget() == null || !pattern.matcher(bind.getTarget()).matches()) continue;
            Object bean = this.getObject(bind.getTarget());
            ComponentStrategy strategy = this.bindStrategyDisplatcher.getStrategy(bind.getComponent());
            strategy.validate(bind, bind.getComponent());
            strategy.updateBean(bean, bind, bind.getComponent());
        }
    }

    public BindStrategyDispatcher getBindStrategyDisplatcher() {
        return this.bindStrategyDisplatcher;
    }

    public void setBindStrategyDisplatcher(BindStrategyDispatcher bindStrategy) {
        this.bindStrategyDisplatcher = bindStrategy;
    }
}

