package jp.sourceforge.armadillo.lzh;

import java.io.*;

import jp.sourceforge.armadillo.io.*;

/**
 * LZH`A[JCȕo̓Xg[B
 */
public final class LzhOutputStream extends ArchiveOutputStream {

    private LzhHeader header;

    /**
     * LzhOutputStream̐B
     * @param os OutputStream
     */
    public LzhOutputStream(OutputStream os) {
        this(os, null);
    }

    /**
     * LzhOutputStream̐B
     * @param os OutputStream
     * @param charsetName Zbg
     *                    ftHgZbggpꍇ <code>null</code> w肷
     */
    public LzhOutputStream(OutputStream os, String charsetName) {
        super(os);
        this.header = new LzhHeader(charsetName);
        this.frontStream = os;
    }

    /**
     * GgǉB
     * wb_͑ɏ܂B
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ 
     */
    public void putNextEntry(LzhEntry entry) throws IOException {
        String compressingType = entry.getMethod();
        LzhMethod method = new LzhMethod(compressingType);
        if (method.isCompressing()) {
            frontStream = new LzssOutputStream(new LzhHuffmanEncoder(out, method.getThreshold()),
                                               method.getDictionarySize(),
                                               method.getMatchSize(),
                                               method.getThreshold());
        } else {
            frontStream = out;
        }
        header.write(out, entry);
    }

    /**
     * GgB
     * @throws IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        frontStream.flush();
        if (frontStream != out) {
            frontStream.close();
        }
        frontStream = out;
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.io.ArchiveOutputStream#close()
     */
    public void close() throws IOException {
        try {
            flush();
            out.write(0); // end of archive
            out.flush();
        } finally {
            try {
                super.close();
            } finally {
                header = null;
            }
        }
    }

}
