package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * rbgPʂ̓ǂݍ݂\InputStreamB
 */
public final class BitInputStream extends FilterInputStream {

    /**
     * <code>int</code>̃rbgB
     */
    private static final int INT_BITSIZE = 32;

    /**
     * ͂̓ǂݍ݃rbgB
     */
    private static final int INPUT_BITSIZE = 8;

    private boolean closed;
    private int buffer;
    private int remaining;

    /**
     * BitInputStream̐B
     * @param is InputStream
     */
    public BitInputStream(InputStream is) {
        super(is);
        this.closed = false;
        this.buffer = 0;
        this.remaining = 0;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    private void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream already closed");
        }
    }

    /**
     * w肵rbg̒lǂݍށB
     * @param bitLength rbg
     * @return w肵rbg̒l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    public int readBits(int bitLength) throws IOException {
        ensureOpen();
        if (bitLength < 1 || 32 < bitLength) {
            throw new IllegalArgumentException("bit length: " + bitLength);
        }
        if (remaining < bitLength) {
            fillBuffer(bitLength - remaining);
            if (remaining < bitLength) {
                return -1;
            }
        }
        int value = buffer >>> (INT_BITSIZE - bitLength);
        remaining -= bitLength;
        buffer <<= bitLength;
        return value;
    }

    /**
     * 1rbgǂݍށB
     * @return 1rbg̒l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    public int readBit() throws IOException {
        return readBits(1);
    }

    /**
     * rbgǂ݂B
     * @param bitLength rbg
     * @return w肵rbg̒l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ 
     */
    public int prefetchBits(int bitLength) throws IOException {
        ensureOpen();
        if (remaining < bitLength) {
            fillBuffer(bitLength);
            if (remaining < bitLength) {
                return -1;
            }
        }
        return buffer >>> (INT_BITSIZE - bitLength);
    }

    /**
     * obt@𖄂߂B
     * @param bitLength ߂rbg
     * @throws IOException o̓G[ꍇ 
     */
    private void fillBuffer(int bitLength) throws IOException {
        assert bitLength >= 1;
        if (remaining + bitLength > INT_BITSIZE) {
            throw new IllegalArgumentException("overflow: " + remaining + ", " + bitLength);
        }
        int buffered = 0;
        while (buffered < bitLength) {
            int b = super.read();
            if (b == -1) {
                if (buffered == 0) {
                    return;
                } else {
                    break;
                }
            }

            b <<= (INT_BITSIZE - INPUT_BITSIZE - remaining);
            assert (buffer | b) == buffer + b;
            buffer |= b;
            remaining += INPUT_BITSIZE;
            buffered += INPUT_BITSIZE;
        }
        if (buffered < bitLength) {
            throw new IOException("requred=" + bitLength + ", buffered=" + buffered);
        }
    }

    /**
     * obt@NAB
     */
    public void clearBuffer() {
        this.buffer = 0;
        this.remaining = 0;
    }

    /**
     * obt@l̎擾B
     * @return obt@l
     */
    public int getBuffer() {
        return buffer;
    }

    /**
     * crbg̎擾B
     * @return crbg
     */
    public int getRemaining() {
        return remaining;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#read()
     */
    public int read() throws IOException {
        return readBits(8);
    }

    /* (overridden)
     * @see java.io.FilterInputStream#close()
     */
    public void close() throws IOException {
        ensureOpen();
        closed = true;
        super.close();
    }

}
