/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jp.sourceforge.armadillo.io.ArchiveInputStream;
import jp.sourceforge.armadillo.zip.RewindableInputStream;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipHeader;

public final class ZipInputStream
extends ArchiveInputStream {
    private ZipHeader header;
    private Inflater inflater;
    private ZipEntry nextEntry;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public ZipInputStream(InputStream inputStream, String string) {
        super(new RewindableInputStream(inputStream, 4096));
        this.header = new ZipHeader(string);
        this.inflater = new Inflater(true);
    }

    public ZipEntry getNextEntry() throws IOException {
        ZipEntry zipEntry;
        this.ensureOpen();
        if (this.nextEntry != null) {
            this.closeEntry();
        }
        if ((zipEntry = this.header.read(this.in)) == null) {
            return null;
        }
        switch (zipEntry.getMethod()) {
            case 8: {
                this.frontStream = new InflaterInputStream(this.in, this.inflater, 512);
                break;
            }
            case 0: {
                this.frontStream = this.in;
                break;
            }
            default: {
                throw new IOException("invalid method: " + zipEntry.getMethod());
            }
        }
        this.remaining = zipEntry.getSize();
        this.nextEntry = zipEntry;
        return this.nextEntry;
    }

    public void closeEntry() throws IOException {
        long l;
        this.ensureOpen();
        if (!this.nextEntry.isDirectory()) {
            int n;
            if (this.remaining > 0L && this.nextEntry.getCompressedSize() < this.nextEntry.getSize()) {
                while (this.remaining > 0L) {
                    this.skip(this.remaining);
                }
            }
            if ((n = this.inflater.getRemaining()) > 0) {
                ((RewindableInputStream)this.in).rewind(n);
            }
        }
        if (this.nextEntry.hasEXT()) {
            ZipEntry zipEntry = this.header.readEXT(this.in);
            if (zipEntry != null) {
                this.nextEntry.crc = zipEntry.crc;
                this.nextEntry.compressedSize = zipEntry.compressedSize;
                this.nextEntry.size = zipEntry.size;
            }
            this.remaining = 0L;
        } else if (!this.nextEntry.isDirectory() && (l = this.nextEntry.getCompressedSize() - (long)this.inflater.getTotalIn()) != 0L) {
            if (l > 0L) {
                this.in.skip(l);
            } else {
                throw new IOException("unexpected state");
            }
        }
        if (!$assertionsDisabled && this.remaining != 0L) {
            throw new AssertionError((Object)("remaining: " + this.remaining));
        }
        this.nextEntry = null;
        this.inflater.reset();
        this.frontStream = this.in;
    }

    public void close() throws IOException {
        this.header = null;
        this.inflater = null;
        this.nextEntry = null;
        super.close();
    }

    static {
        $assertionsDisabled = !ZipInputStream.class.desiredAssertionStatus();
    }
}

