/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.util.Collections;
import java.util.LinkedList;

public final class LzhHuffmanTable {
    private static final int MAX_CODE_LENGTH = 16;
    final int[] codeTable;
    final int[] codeLengthTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LzhHuffmanTable(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        this.build(nArray, nArray2, nArray3);
        this.codeTable = nArray2;
        this.codeLengthTable = nArray3;
    }

    public static LzhHuffmanTable build(int[] nArray) {
        return new LzhHuffmanTable(nArray);
    }

    private void build(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = nArray2.length;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (n = 0; n < n2; ++n) {
            int n3 = nArray[n];
            if (n3 <= 0) continue;
            linkedList.add(new Node(n, n3));
        }
        if (linkedList.size() <= 1) {
            if (linkedList.size() == 1) {
                nArray2[n2 - 1] = 1;
            }
            return;
        }
        n = n2;
        while (linkedList.size() > 1) {
            Collections.sort(linkedList);
            Node node = (Node)linkedList.remove(0);
            Node node2 = (Node)linkedList.remove(0);
            linkedList.add(new Node(n++, node, node2));
        }
        Node node = (Node)linkedList.get(0);
        LzhHuffmanTable.createCodeLengthTable(node, n2, 0, nArray3);
        LzhHuffmanTable.createCodeTable(nArray2, nArray3);
    }

    private static void createCodeLengthTable(Node node, int n, int n2, int[] nArray) {
        int n3 = node.number;
        if (n3 < n) {
            nArray[n3] = n2;
        } else {
            LzhHuffmanTable.createCodeLengthTable(node.left, n, n2 + 1, nArray);
            LzhHuffmanTable.createCodeLengthTable(node.right, n, n2 + 1, nArray);
        }
    }

    static int[] createCodeTable(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        LzhHuffmanTable.createCodeTable(nArray2, nArray);
        return nArray2;
    }

    static void createCodeTable(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[17];
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray2[i];
            nArray3[n2] = nArray3[n2] + 1;
        }
        int[] nArray4 = new int[17];
        for (n = 0; n < 16; ++n) {
            nArray4[n + 1] = nArray4[n] + nArray3[n + 1] << 1;
        }
        if (!$assertionsDisabled && nArray4[16] != 131072) {
            throw new AssertionError(nArray4[16]);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray2[n];
            if (n3 <= 0) continue;
            int n4 = n3 - 1;
            nArray4[n4] = nArray4[n4] + 1;
        }
    }

    static {
        $assertionsDisabled = !LzhHuffmanTable.class.desiredAssertionStatus();
    }

    private static final class Node
    implements Comparable {
        final int number;
        final int weight;
        Node left;
        Node right;

        public Node(int n, int n2) {
            this.number = n;
            this.weight = n2;
            this.left = null;
            this.right = null;
        }

        public Node(int n, Node node, Node node2) {
            this.number = n;
            this.weight = node.weight + node2.weight;
            this.left = node;
            this.right = node2;
        }

        public int compareTo(Object object) {
            return this.compareTo((Node)object);
        }

        private int compareTo(Node node) {
            int n;
            int n2;
            if (node.weight == this.weight) {
                n2 = node.number;
                n = this.number;
            } else {
                n2 = this.weight;
                n = node.weight;
            }
            return n2 < n ? -1 : (n2 == n ? 0 : 1);
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "Node:" + this.number + " (" + this.weight + ")";
        }
    }
}

