#include <jnihelper.h>

int jniRegisterNativeMethods(JNIEnv* env, const char* className,
                             const JNINativeMethod* gMethods, int numMethods) {
  jclass clazz;

  LOGD("Registering %s natives\n", className);
  clazz = (*env)->FindClass(env, className);
  if (clazz == NULL) {
    LOGD("Native registration unable to find class '%s'\n", className);
    return -1;
  }
  if ((*env)->RegisterNatives(env, clazz, gMethods, numMethods) < 0) {
    LOGD("RegisterNatives failed for '%s'\n", className);
    return -1;
  }
  return 0;
}

