unit uTabSheet;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cTabSheet: Tvalue;

function ap_cTabSheet: Tvalue;
function ap_iTabSheet(real: TTabSheet; owner: Tvalue): Tvalue;
procedure Init_TabSheet;

implementation

uses
  SysUtils, Classes,
  uConv,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

type
  TMyTabSheet = class(TTabSheet)
  protected
    procedure DoHide; override;
  public
    procedure inherited_DoHide;
  end;

var
  id_do_hide: Tid;

procedure TMyTabSheet.DoHide;
begin
  rb_funcall2(Self.tag, id_do_hide, 0, nil);
end;

procedure TMyTabSheet.inherited_DoHide;
begin
  inherited DoHide;
end;

function ap_cTabSheet: Tvalue;
begin
  result := cTabSheet;
end;

procedure TabSheet_setup(obj: Tvalue; real: TTabSheet);
begin
//    AssignPropMethod(real, [Handle]);
end;

function TabSheet_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function TabSheet_alloc(This: Tvalue; real: TTabSheet): Tvalue;
begin
  result := ChildAlloc(This, real);
  TabSheet_setup(result, real);
end;

function ap_iTabSheet(real: TTabSheet; owner: Tvalue): Tvalue;
begin
  result := TabSheet_alloc(cTabSheet, real);
  ap_owner(result, owner);
end;

function ap_iTabSheet_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iTabSheet(TTabSheet(AControl), owner);
end;

function TabSheet_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
begin
  real := TMyTabSheet.Create(nil);
  result := CompoAlloc(This, real);
  TabSheet_setup(result, real);
end;

function TabSheet_initialize(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  if argc > 0 then
  begin
    ap_data_get_object(Pvalue(argv)^, TPageControl, PageControl);
    real.PageControl := PageControl;
  end;
  rb_call_super(argc, argv);
  result := This;
end;

function TabSheet_get_page_control(This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  PageControl := real.PageControl;
  if PageControl = nil then
    result := Qnil
  else
    result := PageControl.tag
  ;
end;

function TabSheet_set_page_control(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPageControl, PageControl);
  real.PageControl := PageControl;
  result := v;
end;

function TabSheet_do_hide(This : Tvalue): Tvalue; cdecl;
var
  real: TMyTabSheet;
begin
  real := ap_data_get_struct(This);
  real.inherited_DoHide;
  result := This;
end;

function TabSheet_get_tab_index(This: Tvalue): Tvalue; cdecl;
var
  real: TMyTabSheet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.TabIndex);
end;

procedure Init_TabSheet;
var
  default_event: Tvalue;
begin
  id_do_hide := rb_intern('do_hide');
  
  cTabSheet := OutputPersistentClass(mPhi, TTabSheet, cWinControl, ap_iTabSheet_v);
  rb_define_method(cTabSheet, 'event_handle', @TabSheet_event_handle, 1);
  rb_define_alloc_func(cTabSheet, @TabSheet_allocate);
  rb_define_private_method(cTabSheet, 'initialize', @TabSheet_initialize, -1);
  DefineAttrGet(cTabSheet, 'page_control', TabSheet_get_page_control);
  DefineAttrSet(cTabSheet, 'page_control', TabSheet_set_page_control);
  rb_define_method(cTabSheet, 'do_hide', @TabSheet_do_hide, 0);
  DefineAttrGet(cTabSheet, 'tab_index', TabSheet_get_tab_index);

  default_event := rb_intern('on_show=');
  rb_define_const(cTabSheet, 'DEFAULT_EVENT', ID2SYM(default_event));
end;

end.
