unit uEdit;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cEdit: Tvalue;

function ap_cEdit: Tvalue;
function ap_iEdit(real: TEdit; owner: Tvalue): Tvalue;
procedure Init_edit;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv,
  uSizeConstraints, uFont,
  uPersistent, uComponent, uControl;

function ap_cEdit: Tvalue;
begin
  result := cEdit;
end;

procedure Edit_setup(obj: Tvalue; real: TEdit);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function Edit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Edit_alloc(klass: Tvalue; real: TEdit): Tvalue;
begin
  result := ChildAlloc(klass, real);
  Edit_setup(result, real);
end;

function ap_iEdit(real: TEdit; owner: Tvalue): Tvalue;
begin
  result := Edit_alloc(cEdit, real);
  ap_owner(result, owner);
end;

function ap_iEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEdit(TEdit(AControl), owner);
end;

function Edit_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := TEdit.Create(nil);
  result := CompoAlloc(This, real);
  Edit_setup(result, real);
end;

function Edit_set_sel_start(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  real.SelStart := dl_Integer(v);
  result := v;
end;

function Edit_get_sel_start(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.SelStart);
end;

function Edit_set_sel_length(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  real.SelLength := dl_Integer(v);
  result := v;
end;

function Edit_get_sel_length(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.SelLength);
end;

function Edit_set_sel_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  real.SelText := dl_String(v);
  result := v;
end;

function Edit_get_sel_text(This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.SelText);
end;

function Edit_copy_to_clipboard(This: Tvalue): Tvalue; cdecl;
var
  real: TCustomEdit;
begin
  real := ap_data_get_struct(This);
  real.CopyToClipboard;
  result := This;
end;

function Edit_cut_to_clipboard(This: Tvalue): Tvalue; cdecl;
var
  real: TCustomEdit;
begin
  real := ap_data_get_struct(This);
  real.CutToClipboard;
  result := This;
end;

function Edit_paste_from_clipboard(This: Tvalue): Tvalue; cdecl;
var
  real: TCustomEdit;
begin
  real := ap_data_get_struct(This);
  real.PasteFromClipboard;
  result := This;
end;

function Edit_select_all(This: Tvalue): Tvalue; cdecl; // [ap-dev:1314] Edit#select_all
var
  real: TEdit;
begin
  result := This;
  real := ap_data_get_struct(This);
  real.SelectAll;
end;

procedure Init_edit;
begin
  OutputConstSetType(mPhi, TypeInfo(TEditCharCase));
  cEdit := OutputPersistentClass(mPhi, TEdit, cWinControl, ap_iEdit_v);
  rb_define_method(cEdit, 'event_handle', @Edit_event_handle, 1);
  rb_define_alloc_func(cEdit, @Edit_allocate);
  DefineAttrGet(cEdit, 'sel_start', Edit_get_sel_start);
  DefineAttrSet(cEdit, 'sel_start', Edit_set_sel_start);
  DefineAttrGet(cEdit, 'sel_length', Edit_get_sel_length);
  DefineAttrSet(cEdit, 'sel_length', Edit_set_sel_length);
  DefineAttrGet(cEdit, 'sel_text', Edit_get_sel_text);
  DefineAttrSet(cEdit, 'sel_text', Edit_set_sel_text);

  rb_define_method(cEdit, 'copy_to_clipboard', @Edit_copy_to_clipboard, 0);
  rb_define_method(cEdit, 'cut_to_clipboard', @Edit_cut_to_clipboard, 0);
  rb_define_method(cEdit, 'paste_from_clipboard', @Edit_paste_from_clipboard, 0);
  // [ap-dev:1314] Edit#select_all
  rb_define_method(cEdit, 'select_all', @Edit_select_all, 0);
end;

end.
