unit uBevel;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ELSE}
  QExtCtrls,
{$ENDIF}
  Rubies;

var
  cBevel: Tvalue;

function ap_cBevel: Tvalue;
function ap_iBevel(real: TBevel; owner: Tvalue): Tvalue;
procedure Init_Bevel;

implementation

uses
  Classes,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  uDefUtils, uIntern, uAlloc, uProp, uSizeConstraints,
  uPersistent, uComponent, uControl, uPhi;

function ap_cBevel: Tvalue;
begin
  result := cBevel;
end;

procedure Bevel_setup(obj: Tvalue; real: TBevel);
begin
//
end;

function Bevel_alloc(This: Tvalue; real: TBevel): Tvalue;
begin
  result := TmpAlloc(This, real);
  Bevel_setup(result, real);
end;

function ap_iBevel(real: TBevel; owner: Tvalue): Tvalue;
begin
  result := Bevel_alloc(cBevel, real);
  ap_owner(result, owner);
end;

function ap_iBevel_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iBevel(TBevel(AControl), owner);
end;

function Bevel_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TBevel;
begin
  real := TBevel.Create(nil);
  result := CompoAlloc(This, real);
  Bevel_setup(result, real);
end;

procedure Init_Bevel;
begin
  OutputConstSetType(mPhi, TypeInfo(TBevelShape));
  OutputConstSetType(mPhi, TypeInfo(TBevelStyle));
  cBevel := OutputPersistentClass(mPhi, TBevel, cControl, ap_iBevel_v);
  rb_define_alloc_func(cBevel, @Bevel_allocate);
end;

end.
