unit uActionList;

interface

uses
{$IFDEF VCL}
  ActnList,
{$ELSE}
  QActnList,
{$ENDIF}
  Rubies;

var
  cActionList: Tvalue;

function ap_cActionList: Tvalue;
function ap_iActionList(real: TActionList; owner: Tvalue): Tvalue;
procedure Init_ActionList;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uIndexer,
  uPersistent, uComponent, uAction;

function ap_cActionList: Tvalue;
begin
  result := cActionList;
end;

procedure ActionList_setup(obj: Tvalue; real: TActionList);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ActionList_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ActionList_alloc(This: Tvalue; real: TActionList): Tvalue;
begin
  result := ChildAlloc(This, real);
  ActionList_setup(result, real);
end;

function ap_iActionList(real: TActionList; owner: Tvalue): Tvalue;
begin
  result := ActionList_alloc(cActionList, real);
  ap_owner(result, owner);
end;

function ap_iActionList_v(var AComponent; owner: Tvalue): Tvalue;
begin
  result := ap_iActionList(TActionList(AComponent), owner);
end;

function ActionList_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TActionList;
begin
  real := TActionList.Create(nil);
  result := CompoAlloc(This, real);
  ActionList_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function ActionList_get_actions(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TActionList;
  args: array of Tvalue;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  result := real.Actions[FIX2INT(args[0])].tag;
end;

function ActionList_set_actions(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TActionList;
  args: array of Tvalue;
  CAction: TContainedAction;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  ap_data_get_object(args[1], TContainedAction, CAction);
  real.Actions[FIX2INT(args[0])] := CAction;
  result := args[1];
end;

procedure Init_ActionList;
begin
  cActionList := OutputPersistentClass(mPhi, TActionList, cComponent, ap_iActionList_v);
  rb_define_method(cActionList, 'event_handle', @ActionList_event_handle, 1);
  DefineSingletonMethod(cActionList, 'new', ActionList_new);
  DefineIndexer(cActionList, 'actions', @ActionList_get_actions, @ActionList_set_actions);
end;

end.
