unit uResponse;

interface

uses Classes, HTTPApp, Rubies;

function ap_cResponse: Tvalue;
function ap_iResponse(real: TWebResponse; owner: Tvalue): Tvalue;
procedure Init_Response;

implementation

uses
  SysUtils, uDefUtils, Pythia, uWeb, WebHandle, uRequest, uCookieCollection;

function ap_cResponse: Tvalue;
begin
  result := cResponse;
end;

procedure Response_setup(obj: Tvalue; real: TWebResponse);
begin
//
end;

function Response_alloc(This: Tvalue; real: TWebResponse): Tvalue;
begin
  result := TmpAlloc(This, real);
  Response_setup(result, real);
end;

function ap_iResponse(real: TWebResponse; owner: Tvalue): Tvalue;
begin
  result := Response_alloc(cResponse, real);
  ap_owner(result, owner);
end;

function ap_iResponse_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iResponse(TWebResponse(AControl), owner)
end;

function dl_Response(This: Tvalue): TWebResponse;
begin
  result := ap_data_get_struct(This);
end;

function Response_set_cookie_field(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
begin
  SetLength(args, argc);
  args := argv;
  if argc < 5 then ap_raise(ap_eArgError, sToo_few_args);
  dl_Response(This).SetCookieField(
    dl_Strings(args[0]),
    dl_String(args[1]),
    dl_String(args[2]),
    dl_DateTime(args[3]),
    dl_Boolean(args[4])
  );
  result := This;
end;

function Response_send_response(This: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).SendResponse;
  result := This;
end;

function Response_send_redirect(This, uri: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).SendRedirect(dl_String(uri));
  result := This;
end;

function Response_get_cookies(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_iCookieCollection(dl_Response(This).Cookies, This);
end;

function Response_get_httprequest(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_iRequest(dl_Response(This).HTTPRequest, This);
end;

function Response_get_version(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Version);
end;

function Response_set_version(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Version := dl_String(v);
  result := v;
end;

function Response_get_reason_string(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).ReasonString);
end;

function Response_set_reason_string(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).ReasonString := dl_String(v);
  result := v;
end;

function Response_get_server(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Server);
end;

function Response_set_server(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Server := dl_String(v);
  result := v;
end;

function Response_get_wwwauthenticate(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).WWWAuthenticate);
end;

function Response_set_wwwauthenticate(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).WWWAuthenticate := dl_String(v);
  result := v;
end;

function Response_get_realm(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Realm);
end;

function Response_set_realm(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Realm := dl_String(v);
  result := v;
end;

function Response_get_allow(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Allow);
end;

function Response_set_allow(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Allow := dl_String(v);
  result := v;
end;

function Response_get_location(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Location);
end;

function Response_set_location(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Location := dl_String(v);
  result := v;
end;

function Response_get_content_encoding(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).ContentEncoding);
end;

function Response_set_content_encoding(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).ContentEncoding := dl_String(v);
  result := v;
end;

function Response_get_content_type(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).ContentType);
end;

function Response_set_content_type(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).ContentType := dl_String(v);
  result := v;
end;

function Response_get_content_version(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).ContentVersion);
end;

function Response_set_content_version(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).ContentVersion := dl_String(v);
  result := v;
end;

function Response_get_derived_from(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).DerivedFrom);
end;

function Response_set_derived_from(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).DerivedFrom := dl_String(v);
  result := v;
end;

function Response_get_title(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Title);
end;

function Response_set_title(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Title := dl_String(v);
  result := v;
end;

function Response_get_status_code(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Response(This).StatusCode);
end;

function Response_set_status_code(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).StatusCode := dl_Integer(v);
  result := v;
end;

function Response_get_content_length(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Response(This).ContentLength);
end;

function Response_set_content_length(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).ContentLength := dl_Integer(v);
  result := v;
end;

function Response_get_date(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Response(This).Date);
end;

function Response_set_date(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Date := dl_DateTime(v);
  result := v;
end;

function Response_get_expires(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Response(This).Expires);
end;

function Response_set_expires(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Expires := dl_DateTime(v);
  result := v;
end;

function Response_get_last_modified(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Response(This).LastModified);
end;

function Response_set_last_modified(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).LastModified := dl_DateTime(v);
  result := v;
end;

function Response_get_content(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).Content);
end;

function Response_set_content(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).Content := dl_String(v);
  result := v;
end;

function Response_get_content_stream(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_iStream(dl_Response(This).ContentStream, This);
end;

function Response_set_content_stream(This, v: Tvalue): Tvalue; cdecl;
var
  Stream: TStream;
begin
  ap_data_get_object(v, TStream, Stream);
  dl_Response(This).ContentStream := Stream;
  result := v;
end;

function Response_get_log_message(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Response(This).LogMessage);
end;

function Response_set_log_message(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Response(This).LogMessage := dl_String(v);
  result := v;
end;

function Response_get_custom_headers(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_iStrings(dl_Response(This).CustomHeaders, This);
end;

function Response_set_custom_headers(This, strings: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_Response(This).CustomHeaders := dl_Strings(strings);
end;

procedure Init_Response;
begin
  cResponse := rb_define_class_under(mWeb, 'Response', ap_cObject);
//  DefineProp(cResponse, TWebResponse);
  rb_define_method(cResponse, 'set_cookie_field', @Response_set_cookie_field, -1);
  rb_define_method(cResponse, 'send_response', @Response_send_response, 0);
  rb_define_method(cResponse, 'send_redirect', @Response_send_redirect, 1);
  DefineAttrGet(cResponse, 'cookies', Response_get_cookies);
  DefineAttrGet(cResponse, 'httprequest', Response_get_httprequest);
  DefineAttrGet(cResponse, 'version', Response_get_version);
  DefineAttrSet(cResponse, 'version', Response_set_version);
  DefineAttrGet(cResponse, 'reason_string', Response_get_reason_string);
  DefineAttrSet(cResponse, 'reason_string', Response_set_reason_string);
  DefineAttrGet(cResponse, 'server', Response_get_server);
  DefineAttrSet(cResponse, 'server', Response_set_server);
  DefineAttrGet(cResponse, 'wwwauthenticate', Response_get_wwwauthenticate);
  DefineAttrSet(cResponse, 'wwwauthenticate', Response_set_wwwauthenticate);
  DefineAttrGet(cResponse, 'realm', Response_get_realm);
  DefineAttrSet(cResponse, 'realm', Response_set_realm);
  DefineAttrGet(cResponse, 'allow', Response_get_allow);
  DefineAttrSet(cResponse, 'allow', Response_set_allow);
  DefineAttrGet(cResponse, 'location', Response_get_location);
  DefineAttrSet(cResponse, 'location', Response_set_location);
  DefineAttrGet(cResponse, 'content_encoding', Response_get_content_encoding);
  DefineAttrSet(cResponse, 'content_encoding', Response_set_content_encoding);
  DefineAttrGet(cResponse, 'content_type', Response_get_content_type);
  DefineAttrSet(cResponse, 'content_type', Response_set_content_type);
  DefineAttrGet(cResponse, 'content_version', Response_get_content_version);
  DefineAttrSet(cResponse, 'content_version', Response_set_content_version);
  DefineAttrGet(cResponse, 'derived_from', Response_get_derived_from);
  DefineAttrSet(cResponse, 'derived_from', Response_set_derived_from);
  DefineAttrGet(cResponse, 'title', Response_get_title);
  DefineAttrSet(cResponse, 'title', Response_set_title);
  DefineAttrGet(cResponse, 'status_code', Response_get_status_code);
  DefineAttrSet(cResponse, 'status_code', Response_set_status_code);
  DefineAttrGet(cResponse, 'content_length', Response_get_content_length);
  DefineAttrSet(cResponse, 'content_length', Response_set_content_length);
  DefineAttrGet(cResponse, 'date', Response_get_date);
  DefineAttrSet(cResponse, 'date', Response_set_date);
  DefineAttrGet(cResponse, 'expires', Response_get_expires);
  DefineAttrSet(cResponse, 'expires', Response_set_expires);
  DefineAttrGet(cResponse, 'last_modified', Response_get_last_modified);
  DefineAttrSet(cResponse, 'last_modified', Response_set_last_modified);
  DefineAttrGet(cResponse, 'content', Response_get_content);
  DefineAttrSet(cResponse, 'content', Response_set_content);
  DefineAttrGet(cResponse, 'content_stream', Response_get_content_stream);
  DefineAttrSet(cResponse, 'content_stream', Response_set_content_stream);
  DefineAttrGet(cResponse, 'log_message', Response_get_log_message);
  DefineAttrSet(cResponse, 'log_message', Response_set_log_message);
  DefineAttrGet(cResponse, 'custom_headers', Response_get_custom_headers);
  DefineAttrSet(cResponse, 'custom_headers', Response_set_custom_headers);
end;

end.

