unit uDBImage;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBImage = class(TDBImage)
//  published
//    property Text;
  end;

var
  cDBImage: Tvalue;

function ap_iDBImage(real: TPhi_DBImage; owner: Tvalue): Tvalue;
procedure Init_DBImage;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBImage_setup(obj: Tvalue; real: TPhi_DBImage);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBImage_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBImage_alloc(This: Tvalue; real: TPhi_DBImage): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBImage_setup(result, real);
end;

function ap_iDBImage(real: TPhi_DBImage; owner: Tvalue): Tvalue;
begin
  result := DBImage_alloc(cDBImage, real);
  ap_owner(result, owner);
end;

function ap_iDBImage_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBImage(TPhi_DBImage(AControl), owner)
end;

function DBImage_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBImage;
begin
  real := TPhi_DBImage.Create(nil);
  result := CompoAlloc(This, real);
  DBImage_setup(result, real);
end;

function DBImage_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBImage;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBImage_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBImage;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBImage;
begin
  cDBImage := DefinePersistentClass(mRDB, TPhi_DBImage, ap_cWincontrol, ap_iDBImage_v);
  rb_define_method(cDBImage, 'event_handle', @DBImage_event_handle, 1);
  rb_define_alloc_func(cDBImage, @DBImage_allocate);
  DefineAttrSet(cDBImage, 'data_source', DBImage_set_data_source);
  DefineAttrSet(cDBImage, 'data_field', DBImage_set_data_field);
end;

end.

