unit uDBEdit;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBEdit = class(TDBEdit)
  published
    property IsMasked;
    property EditText;
    property Text;
  end;

var
  cDBEdit: Tvalue;

function ap_iDBEdit(real: TPhi_DBEdit; owner: Tvalue): Tvalue;
procedure Init_DBEdit;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBEdit_setup(obj: Tvalue; real: TPhi_DBEdit);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBEdit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBEdit_alloc(This: Tvalue; real: TPhi_DBEdit): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBEdit_setup(result, real);
end;

function ap_iDBEdit(real: TPhi_DBEdit; owner: Tvalue): Tvalue;
begin
  result := DBEdit_alloc(cDBEdit, real);
  ap_owner(result, owner);
end;

function ap_iDBEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBEdit(TPhi_DBEdit(AControl), owner)
end;

function DBEdit_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBEdit;
begin
  real := TPhi_DBEdit.Create(nil);
  result := CompoAlloc(This, real);
  DBEdit_setup(result, real);
end;

function DBEdit_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBEdit;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBEdit_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBEdit;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBEdit;
begin
  cDBEdit := DefinePersistentClass(mRDB, TPhi_DBEdit, ap_cEdit, ap_iDBEdit_v);
  rb_define_method(cDBEdit, 'event_handle', @DBEdit_event_handle, 1);
  rb_define_alloc_func(cDBEdit, @DBEdit_allocate);
  DefineAttrSet(cDBEdit, 'data_source', DBEdit_set_data_source);
  DefineAttrSet(cDBEdit, 'data_field', DBEdit_set_data_field);
end;

end.
