unit uStoredProc;

interface

uses DBTables, Rubies;

var
  cStoredProc: Tvalue;

function ap_cStoredProc: Tvalue;
function ap_iStoredProc(real: TStoredProc; owner: Tvalue): Tvalue;
procedure Init_StoredProc;

implementation

uses uDefUtils, Pythia, uRDBExt{, uDataSet};

function ap_cStoredProc: Tvalue;
begin
  result := cStoredProc;
end;

procedure StoredProc_setup(obj: Tvalue; real: TStoredProc);
begin
  DataSet_setup(obj, real);
end;

function StoredProc_alloc(This: Tvalue; real: TStoredProc): Tvalue;
begin
  result := ChildAlloc(This, real);
  StoredProc_setup(result, real);
end;

function ap_iStoredProc(real: TStoredProc; owner: Tvalue): Tvalue;
begin
  result := StoredProc_alloc(cStoredProc, real);
  ap_owner(result, owner);
end;

function ap_iStoredProc_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iStoredProc(TStoredProc(obj), owner)
end;

function StoredProc_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStoredProc;
begin
  real := TStoredProc.Create(nil);
  result := DataSet_alloc(This, real);
  StoredProc_setup(result, real);

  ap_obj_call_init(result, argc, argv);
end;

procedure Init_StoredProc;
begin
  DefineConstSetType(ap_mRDB, TypeInfo(TParamBindMode));

  cStoredProc := DefinePersistentClass(ap_mRDB, TStoredProc, ap_cPersistent, ap_iStoredProc_v);
  DefineSingletonMethod(cStoredProc, 'new', StoredProc_new);
end;

end.
