unit uFountainParser;

interface

uses
  Rubies, heFountain;

var
  cFountainParser: Tvalue;

function ap_iFountainParser(real: TFountainParser; owner: Tvalue): Tvalue;
procedure Init_FountainParser;

implementation

uses
  Windows, SysUtils, Classes, Controls, Graphics,
  Pythia, uStrUtils, uDefUtils,
  heClasses,
  uFountain;

procedure FountainParser_setup(This: Tvalue; real: TFountainParser);
begin
//
end;

function FountainParser_alloc(This: Tvalue; real: TFountainParser): Tvalue;
begin
  result := TmpAlloc(This, real);
  FountainParser_setup(result, real);
end;

function ap_iFountainParser(real: TFountainParser; owner: Tvalue): Tvalue;
begin
  result := FountainParser_alloc(cFountainParser, real);
  ap_owner(result, owner);
end;

function ap_iFountainParser_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iFountainParser(TFountainParser(AControl), owner)
end;
function FountainParser_next_token(This: Tvalue): Tvalue; cdecl;
var
  real: TFountainParser;
  ch: Char;
begin
  real := ap_data_get_struct(This);
  ch := real.NextToken;
  result := CHR2FIX(ch);
end;

function FountainParser_source_pos(This: Tvalue): Tvalue; cdecl;
var
  real: TFountainParser;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.SourcePos);
end;

function FountainParser_token_string(This: Tvalue): Tvalue; cdecl;
var
  real: TFountainParser;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.TokenString));
end;

function FountainParser_get_token(This: Tvalue): Tvalue; cdecl;
var
  real: TFountainParser;
  ch: Char;
begin
  real := ap_data_get_struct(This);
  ch := real.Token;
  result := CHR2FIX(ch);
end;

procedure Init_FountainParser;
begin
  cFountainParser := rb_define_class_under(cFountain, 'Parser', ap_cObject);
  rb_define_method(cFountainParser, 'next_token', @FountainParser_next_token, 0);
  rb_define_method(cFountainParser, 'source_pos', @FountainParser_source_pos, 0);
  rb_define_method(cFountainParser, 'token_string', @FountainParser_token_string, 0);
  DefineAttrGet(cFountainParser, 'token', FountainParser_get_token);
end;

end.
