#!ruby
# TextEffect - path library sample
#
# author: Kazuhiro Yoshida
# mailto: moriq@moriq.com
# license: Ruby
#
# based on DHGL 1.2 - Chapter6\6-2\TextEffect
# http://www.asahi-net.or.jp/~HA3T-NKMR/DGS/ 

require 'phi'; include Phi
require 'path'

form = Component._load open('TextEffect.afm', 'rb').read
form.text_effect_panel.double_buffered = true

# Ԃɔ
def mizutama_bitmap
  bmp = Bitmap.new
  bmp.width = 8
  bmp.height = 8
  bmp.canvas.brush.color = CL_RED
  bmp.canvas.fill_rect(Rect.new(0, 0, 8, 8))
  bmp.canvas.pen.color = CL_WHITE
  bmp.canvas.brush.color = CL_WHITE
  bmp.canvas.ellipse(1, 1, 7, 7)
  bmp
end
mizutama = mizutama_bitmap

def text_path(canvas)
  # pX̐
  Path.open(canvas) do |cv|
    # 70pt Bold ̃̕pX쐬
    cv.font.size = 70
    cv.font.style = [FS_BOLD]
    cv.brush.style = BS_CLEAR
    cv.text_out(30, 30, 'Text Effect')
  end
  Path.flatten(canvas)  # pX𒼐̏W܂ɒ
  path = Path.new
  path.load(canvas)  # pXzグ
  path
end
path = text_path(form.canvas)

  text_height = form.canvas.text_height('Text Effect')
  twisted_path = Path.new

form.text_effect_panel.paint_box.on_paint = proc do
  GC.disable
  
  cy = 30 + text_height/2
  ratio = 2*Math::PI*form.twist_tb.position/100/path.count
  
  # pXRs[
  twisted_path.assign(path)
  
  # pXɂЂ˂
  path.count.times do |i|
    p = twisted_path.get_point(i)
    p.point.y = ((p.point.y - cy) * 
      Math.cos((p.point.x - 30)*ratio) + 
      cy).to_i
    twisted_path.set_point(i, p)
  end
  
  cv = form.text_effect_panel.paint_box.canvas
# cv = twisted_path.canvas
  cv.pen.color = CL_YELLOW  # yF=F y=2
  cv.pen.width = 2
  cv.brush.bitmap = mizutama
  
  # Ђ˂`
  twisted_path.draw_stroke_and_fill(cv)
  
  GC.start
end

form.twist_tb.on_change = proc do
  form.text_effect_panel.paint_box.invalidate
end

form.show
mainloop
