# $B$A$g$C$H$*$+$7$$!#(B
# $BK\Mh$b$C$HEyJ,$KJ,3d$5$l$k(B?

class LS

  SEP_SPACE_NUM = 2

  def initialize(list, screen_width)
    @org_list = list
    @result_row_num = get_row_num(@org_list, screen_width)
    @sorted_list = get_sorted_list(@result_row_num, @org_list.size, @org_list)
  end

  # $B0l$D$N=DNs$KF~$k%j%9%H$N?t(B  result_num
  def col_num
    @result_row_num
  end

  def sorted_list
    @sorted_list
  end


  def get_row_num(str_list, screen_width)
    str_size_list = str_list.collect{|s| s.size}
    
    str_max = str_size_list.max 
    list_size = str_list.size
    col_max = (screen_width / (str_max+3)).to_i
    row_max = (list_size / col_max).to_i + 1

    result_num = row_max
    
    # $BM>$j$r9M$($k$H>/$7LdBj$,(B
    (0..row_max).each do |i|
      row_num = row_max - i + 1
      col_width = []
      last_col = list_size / row_num
      last = 0
  
      (0..last_col).each do |col_num|
	range_last =  (col_num+1)*row_num-1
	if range_last <= list_size - 1
	  col_width.push( str_size_list[(col_num*row_num)..range_last].max )
	  last = range_last
	end
      end
      
      rest = last + 1
      if rest <= list_size - 1
	col_width.push( str_size_list[rest..-1].max )
      end

      total_width = 0
      col_width.each do |width_num|
	total_width += width_num + SEP_SPACE_NUM
      end

      if $DEBUG
	p col_width
	print "line total width: "
	p total_width
	print "result row: "
	p row_num + 1
	print "\n"
      end

      if total_width > screen_width
	result_num = row_num + 1
	break
      end
    end
    
    return result_num
  end

  def get_sorted_list(result_num, list_size, list)
    result = []
    
    #p result_num
    #p list_size
    last_col = list_size / result_num
    last = 0
    (0..last_col).each do |col_num|
      range_last =  (col_num+1)*result_num-1
      if range_last <= list_size - 1
	result.push( list[(col_num*result_num)..range_last].dup )
	last = range_last
      end
    end
    
    rest = last + 1
    if rest <= list_size - 1
      result.push( list[rest..-1] )
    end

    result
  end    

  def get_result_string
    col_width_max = []
    @sorted_list.each do |arr|
      max = 0
      arr.each do |str|
	if max < str.size 
	  max = str.size
	end
      end
      col_width_max.push(max)
    end

    # $B:G8e$N=DNs$N=x?t(B  last_col
    # $BM>$j$,(B0$B$H$=$&$G$J$$>l9g$GCM$,JQ$o$k(B
    if @org_list.size % @result_row_num == 0
      last_col = @org_list.size / @result_row_num - 1
    else
      last_col = @org_list.size / @result_row_num
    end
    result_str = ''
    sep_space = ' ' * SEP_SPACE_NUM

    #p @sorted_list
    ( 0..(@result_row_num-1) ).each do |y|
      (0..last_col).each do |x|
	unless @sorted_list[x][y].nil?
	  str = @sorted_list[x][y]
	  added_space_num = col_width_max[x] - str.size 
	  result_str.concat(' '*added_space_num + str + sep_space)
	end
      end
      result_str.concat("\n")
    end
    result_str
  end

  def print_ls
    print get_result_string
  end

end

if $0 == __FILE__
  ls = LS.new(Module.methods.grep(/^pr/), 70)
  ls.print_ls

#    ls = LS.new(123.methods, 70)
#    ls.print_ls

  ls = LS.new(["kill", "kill"], 70)
  ls.print_ls
end 
