#! ruby -Ks
#-- File_merge_path.rb
#-- File_merge_path.pi

require "File_split3"

def File.merge_path( path1,path2="*.*",option=nil )
  dir1,name1,ext1 = File.split3(path1)
  dir2,name2,ext2 = File.split3(path2)
  dir2  = dir1  if dir2  == ''
  name2 = name1 if name2 == ''
  ext2  = ext1  if ext2  == ''
  if option
    dir2 = ''  unless option.include? :d
    name2 = '' unless option.include? :n
    ext2 = ''  unless option.include? :e
  end
  dir2 << "/" if dir2 != '' && dir2[-1] != ?/
  dir2+name2+ext2
end;

if __FILE__ == $0
  p File.merge_path( __FILE__ )            #=> "G:/Apollo/ap-cvs/apollo/lib/*.*"
  p File.merge_path( __FILE__,"*.*" )      #=> "G:/Apollo/ap-cvs/apollo/lib/*.*"
  p File.merge_path( __FILE__,".pi" )      #=> "G:/Apollo/ap-cvs/apollo/lib/File_merge_path.pi"
  p File.merge_path( __FILE__,"",[:n,:e] ) #=> "File_merge_path.rb"
end

