<?php
/**
 * 
 * @author keiji
 * @package aowp.aspect.weaver.command
 */
/**
 * 
 * @author keiji
 * @package aowp.aspect.weaver.command
 */
abstract class AOWP_WeaveCommand {
	
	public static function weaveAdvice(AOWP_Advice &$advice, AOWP_JoinPoint &$joinPoint) {
		$weaveCommand = null;
		if ($joinPoint instanceof AOWP_ArrayGetJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_ArraySetJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_ConstructorCallJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_FieldGetJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_FieldSetJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_FunctionCallJoinPoint) {
			$weaveCommand = new AOWP_FunctionCallJoinPointWeaveCommand();
		}
		else if ($joinPoint instanceof AOWP_FunctionExecutionJoinPoint) {
			$weaveCommand = new AOWP_FunctionExecutionJoinPointWeaveCommand();
		}
		else if ($joinPoint instanceof AOWP_GlobalVariableGetJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_GlobalVariableSetJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_MethodCallJoinPoint) {
			$weaveCommand = new AOWP_MethodCallJoinPointWeaveCommand();
		}
		else if ($joinPoint instanceof AOWP_MethodExecutionJoinPoint) {
			$weaveCommand = new AOWP_MethodExecutionJoinPointWeaveCommand();
		}
		else if ($joinPoint instanceof AOWP_ScriptCallJoinPoint) {
		}
		else if ($joinPoint instanceof AOWP_ScriptExecutionJoinPoint) {
			$weaveCommand = new AOWP_ScriptExecutionJoinPointWeaveCommand();
		}
		else if ($joinPoint instanceof AOWP_ExitJoinPoint) {
			$weaveCommand = new AOWP_ExitJoinPointWeaveCommand();
		}
		
		if ($weaveCommand !== null) {
			if ($advice instanceof AOWP_BeforeAdvice) {
				$weaveCommand->weaveBeforeAdvice($advice, $joinPoint);
			}
			else if ($advice instanceof AOWP_AfterAdvice) {
				if ($advice->isHavePointcut(new AOWP_RequestPointcut(null)) &&
					$joinPoint instanceof AOWP_ExitJoinPoint) {
					$weaveCommand->weaveBeforeAdvice($advice, $joinPoint);
				}
				else {
					$weaveCommand->weaveAfterAdvice($advice, $joinPoint);
				}
			}
			else if ($advice instanceof AOWP_AroundAdvice) {
				$weaveCommand->weaveAroundAdvice($advice, $joinPoint);
			}
		}
	}
	
}
?>