<?php
/**
 * 
 * @author keiji
 * @package aowp.aspect.weaver.command
 */
/**
 * 
 * @author keiji
 * @package aowp.aspect.weaver.command
 */
class AOWP_FunctionCallJoinPointWeaveCommand implements AOWP_IWeaveCommand {

	/**
	 * @see aspect/weaver/command/AOWP_IWeaveCommand#weaveBeforeAdvice()
	 * @param mixed $advice {@link AOWP_BeforeAdvice}
	 * @param mixed $joinPoint {@link AOWP_FunctionCallJoinPoint}
	 */
	public function  weaveBeforeAdvice(AOWP_Advice &$advice, AOWP_JoinPoint &$joinPoint) {
		$functionCallElement = $joinPoint->getAST();
		
		// ラッピングする関数を作成。
		$wrappingFunctionElement = new AOWP_PHPFunctionElement(AOWP_WeavingASTHelper::getRandomName('function'));
		foreach ($functionCallElement->arguments as $argument) {
			$wrappingFunctionElement->addParameter(AOWP_WeavingASTHelper::getRandomName('parameter', true));
		}
		// includeの為のautoload関数の設定。
		$wrappingFunctionElement->setElement(AOWP_WeavingASTHelper::createIncludeStatemenetElement($joinPoint->getFileFullPath()));
		// アスペクトのインスタンス化。
		$aspectInstantiationElement = AOWP_WeavingASTHelper::createAspectInstantiationAST($advice->getClassNameOfAspect());
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($aspectInstantiationElement));
		// ジョインポイントのインスタンス化。
		$joinPointInstantiationElement = AOWP_WeavingASTHelper::createJoinPointInstantiationAST($joinPoint);
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointInstantiationElement));
		// 関数呼び出しの引き数を、ジョインポイントに設定。
		for ($i = 0; $i < $wrappingFunctionElement->getParameterCount(); $i++) {
			$joinPointArgumentSetElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'addArgument');
			$joinPointArgumentSetElement->addArgument(AOWP_PHPArgumentElement::createVariableArgument($wrappingFunctionElement->getParameterName($i)));
			$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointArgumentSetElement));
		}
		// アドバイスを実行するIf文。
		$adviceExecutionElement = AOWP_WeavingASTHelper::createAdviceExecutionAST($aspectInstantiationElement->getLeftVarialeName(),
			$advice->getIndex(), $joinPointInstantiationElement->getLeftVarialeName());
		$wrappingFunctionElement->setElement($adviceExecutionElement);
		// リターン文。
		$returnFunctionCallElement = new AOWP_PHPFunctionCallElement($functionCallElement->getFunctionName());
		for ($i = 0; $i < count($functionCallElement->getArguments()); $i++) {
			$getArgumentElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'getArgument');
			$getArgumentElement->addArgument(AOWP_PHPArgumentElement::createStringArgument($i));
			$returnFunctionCallElement->addArgument(new AOWP_PHPArgumentElement(null, $getArgumentElement));
		}
		$returnStatementElement = new AOWP_PHPReturnStatementElement(null, $returnFunctionCallElement);
		$wrappingFunctionElement->setElement($returnStatementElement);
		
		// ラッピング関数の重複定義を防ぐためのIf文を追加。
		$ifFunctionDeclarationElement = AOWP_WeavingASTHelper::createIfForFunctionDeclaration($wrappingFunctionElement);

		// ラッピング関数を、元のコードに追加。
		AOWP_WeavingASTHelper::insertElement($functionCallElement, $ifFunctionDeclarationElement);
				
		// 対象のメソッド呼び出しを、作成したラッピング関数の呼び出しに変更する。
		AOWP_FunctionCallJoinPointWeaveCommand::_changeIntoWrapingFunctionCall($functionCallElement, $wrappingFunctionElement->getFunctionName());
	}

	public function  weaveAfterAdvice(AOWP_Advice &$advice, AOWP_JoinPoint &$joinPoint) {
		$functionCallElement = $joinPoint->getAST();
		
		// ラッピングする関数を作成。
		$wrappingFunctionElement = new AOWP_PHPFunctionElement(AOWP_WeavingASTHelper::getRandomName('function'));
		foreach ($functionCallElement->arguments as $argument) {
			$wrappingFunctionElement->addParameter(AOWP_WeavingASTHelper::getRandomName('parameter', true));
		}
		// includeの為のautoload関数の設定。
		$wrappingFunctionElement->setElement(AOWP_WeavingASTHelper::createIncludeStatemenetElement($joinPoint->getFileFullPath()));
		// アスペクトのインスタンス化。
		$aspectInstantiationElement = AOWP_WeavingASTHelper::createAspectInstantiationAST($advice->getClassNameOfAspect());
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($aspectInstantiationElement));
		// ジョインポイントのインスタンス化。
		$joinPointInstantiationElement = AOWP_WeavingASTHelper::createJoinPointInstantiationAST($joinPoint);
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointInstantiationElement));
		// 元の関数を実行し、その返り値をジョインポイントに設定。
		$joinPointReturnSetElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'setReturnValue');
		$originalFunctionCallElement = new AOWP_PHPFunctionCallElement($functionCallElement->getFunctionName());
		for ($i = 0; $i < $wrappingFunctionElement->getParameterCount(); $i++) {
			$originalFunctionCallElement->addVariableArgument($wrappingFunctionElement->getParameterName($i));
		}
		$joinPointReturnSetElement->addArgument(new AOWP_PHPArgumentElement(null, $originalFunctionCallElement));
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointReturnSetElement));
		// メソッド呼び出しの引き数を、ジョインポイントに設定。
		for ($i = 0; $i < $wrappingFunctionElement->getParameterCount(); $i++) {
			$joinPointArgumentSetElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'addArgument');
			$joinPointArgumentSetElement->addArgument(AOWP_PHPArgumentElement::createVariableArgument($wrappingFunctionElement->getParameterName($i)));
			$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointArgumentSetElement));
		}
		// アドバイスを実行するIf文。
		$adviceExecutionElement = AOWP_WeavingASTHelper::createAdviceExecutionAST($aspectInstantiationElement->getLeftVarialeName(),
			$advice->getIndex(), $joinPointInstantiationElement->getLeftVarialeName());
		$wrappingFunctionElement->setElement($adviceExecutionElement);
		// リターン文。
		$returnGetFromJoinPointElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'getReturnValue');
		$returnStatementElement = new AOWP_PHPReturnStatementElement(null, $returnGetFromJoinPointElement);
		$wrappingFunctionElement->setElement($returnStatementElement);

		// ラッピング関数の重複定義を防ぐためのIf文を追加。
		$ifFunctionDeclarationElement = AOWP_WeavingASTHelper::createIfForFunctionDeclaration($wrappingFunctionElement);

		// ラッピング関数を、元のコードに追加。
		AOWP_WeavingASTHelper::insertElement($functionCallElement, $ifFunctionDeclarationElement);
				
		// 対象のメソッド呼び出しを、作成したラッピング関数の呼び出しに変更する。
		AOWP_FunctionCallJoinPointWeaveCommand::_changeIntoWrapingFunctionCall($functionCallElement, $wrappingFunctionElement->getFunctionName());
	}

	public function  weaveAroundAdvice(AOWP_Advice &$advice, AOWP_JoinPoint &$joinPoint) {
		$functionCallElement = $joinPoint->getAST();
		
		// ラッピングする関数を作成。
		$wrappingFunctionElement = new AOWP_PHPFunctionElement(AOWP_WeavingASTHelper::getRandomName('function'));
		foreach ($functionCallElement->arguments as $argument) {
			$wrappingFunctionElement->addParameter(AOWP_WeavingASTHelper::getRandomName('parameter', true));
		}
		// includeの為のautoload関数の設定。
		$wrappingFunctionElement->setElement(AOWP_WeavingASTHelper::createIncludeStatemenetElement($joinPoint->getFileFullPath()));
		// アスペクトのインスタンス化。
		$aspectInstantiationElement = AOWP_WeavingASTHelper::createAspectInstantiationAST($advice->getClassNameOfAspect());
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($aspectInstantiationElement));
		// ジョインポイントのインスタンス化。
		$joinPointInstantiationElement = AOWP_WeavingASTHelper::createJoinPointInstantiationAST($joinPoint);
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointInstantiationElement));
		// ジョインポイントにproceedの関数名を設定。
		$joinPointProceedSetElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'setProceedFunctionName');
		$joinPointProceedSetElement->addArgument(AOWP_PHPArgumentElement::createStringArgument($functionCallElement->getFunctionName()));
		$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointProceedSetElement));
		// 関数呼び出しの引き数を、ジョインポイントに設定。
		for ($i = 0; $i < $wrappingFunctionElement->getParameterCount(); $i++) {
			$joinPointArgumentSetElement = new AOWP_PHPSimpleMethodCallElement($joinPointInstantiationElement->getLeftVarialeName(), 'addArgument');
			$joinPointArgumentSetElement->addArgument(AOWP_PHPArgumentElement::createVariableArgument($wrappingFunctionElement->getParameterName($i)));
			$wrappingFunctionElement->setElement(new AOWP_PHPStatementElement($joinPointArgumentSetElement));
		}
		// アドバイスを実行するIf文。
		$originalFunctionCallElement = new AOWP_PHPFunctionCallElement($functionCallElement->getFunctionName());
		for ($i = 0; $i < $wrappingFunctionElement->getParameterCount(); $i++) {
			$originalFunctionCallElement->addVariableArgument($wrappingFunctionElement->getParameterName($i));
		}
		$adviceExecutionElement = AOWP_WeavingASTHelper::createAdviceExecutionASTForAround($aspectInstantiationElement->getLeftVarialeName(),
			$advice->getIndex(), $joinPointInstantiationElement->getLeftVarialeName(), $originalFunctionCallElement);
		$wrappingFunctionElement->setElement($adviceExecutionElement);
		
		// ラッピング関数の重複定義を防ぐためのIf文を追加。
		$ifFunctionDeclarationElement = AOWP_WeavingASTHelper::createIfForFunctionDeclaration($wrappingFunctionElement);

		// ラッピング関数を、元のコードに追加。
		AOWP_WeavingASTHelper::insertElement($functionCallElement, $ifFunctionDeclarationElement);
				
		// 対象のメソッド呼び出しを、作成したラッピング関数の呼び出しに変更する。
		AOWP_FunctionCallJoinPointWeaveCommand::_changeIntoWrapingFunctionCall($functionCallElement, $wrappingFunctionElement->getFunctionName());
	}

	private static function _changeIntoWrapingFunctionCall(AOWP_PHPFunctionCallElement &$targetFunctionCallElement, $wrappingFunctionName) {
		// 対象のメソッド呼び出しを、作成したラッピング関数の呼び出しに変更する。
		$parentElement = $targetFunctionCallElement->getParent();
		// ラッピング関数の呼び出しAST。
		$wrappingFunctionCallElement = new AOWP_PHPFunctionCallElement($wrappingFunctionName);
		foreach ($targetFunctionCallElement->getArguments() as $argument) {
			$wrappingFunctionCallElement->addArgument($argument);
		}
		// 元のメソッド呼び出しと、置き換え。
		$parentElement->{$targetFunctionCallElement->getParentPropertyName()} = $wrappingFunctionCallElement;
	}
	
}

?>