<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * 現在、サポートされていません (ver. 0.8)。
 * 次期リリース予定です。
 * 関数やクラス定義のソースコード上のジョインポイントは含まれません。
 * 例えば、
 * <code>
 * <?php
 * someFunction("Hello!");
 * $a = 'someText';
 * 
 * function someFunction($echoText) {
 * 	echo $echoText;
 * }
 * ?>
 * </code>
 * の場合、5-7行目の関数定義のコード上のジョインポイントは選択されません。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_WithinGlobalPointcut extends AOWP_Pointcut {
	
	private $_fileNamePattern;
	
	/**
	 * 引き数で、対象のファイル名のパターンを指定します。
	 * 引き数は、{@link AOWP_Pointcut::patternMatch}で評価されます。
	 * 
	 * @param $fileNamePattern
	 * @return unknown_type
	 */
	public function __construct($fileNamePattern) {
		$this->_fileNamePattern = $fileNamePattern;
    }
   
    protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		return AOWP_Pointcut::patternMatch($this->_fileNamePattern, $joinPoint->getScriptName()) &&
			$joinPoint->isDeclaredGlobal();
    }

}
?>
