<?php
/**
 * @package aowp.aspect.pointcut.designators
 */

/**
 * 現在、サポートされていません (ver. 0.8)。
 * 次期リリース予定です。
 * この記述子は、
 * <code>
 * echo $object->field
 * </code>
 * のような、フィールド参照を選択します。
 * <code>
 * echo $object->$fieldName
 * </code>
 * のような、可変変数を用いたフィールド参照は、無視します。
 * 
 * @package aowp.aspect.pointcut.designators
 *
 */
class AOWP_FieldGetPointcut extends AOWP_Pointcut {
    private $_className;
    private $_fieldName;
	
	/**
	 * 
	 * @param string $className クラス名
	 * @param string $fieldName フィールド名
	 */
    public function __construct($className, $fieldName) 
    {
    	$this->_className = $className;
    	$this->_fieldName = $fieldName;
    }
   
    protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {    	
    	return $joinPoint instanceof AOWP_FieldGetJoinPoint &&
    		AOWP_Pointcut::patternMatch($this->_fieldName, $joinPoint->getFieldName());
    }

	protected function _runtimeMatch(AOWP_JoinPoint $joinPoint) {
		return AOWP_Pointcut::patternMatch($this->_className, get_class($joinPoint->getInvokedObject()));
	}
}
?>