<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * exitを表すジョインポイントです。
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
class AOWP_ExitJoinPoint extends AOWP_JoinPointWithArguments implements AOWP_IFunctionCallJoinPoint {
	
	/**
	 * 
	 * @var integer
	 */
	private $_staticArgumentCount;

	public function __construct(AOWP_PHPExitExprElement $element = null, $fileName = null) {
		parent::__construct($element, $fileName);
		if ($element->expr != null) {
			$this->setStaticArgumentCount(1);
		}
		else {
			$this->setStaticArgumentCount(0);
		}
	}
	
	public function setStaticArgumentCount($staticArgumentCount) {
		$this->_staticArgumentCount = $staticArgumentCount;
	}
	public function getStaticArgumentCount() {
		return $this->_staticArgumentCount;
	}
	
	/**
	 * 関数名を取得します。
	 * 
	 * @return string
	 */
	public function getFunctionName() {
		return 'exit';
	}
	
	public function proceed(array $argument = array()) {
		if (count($argument) > 0) {
			exit($argument[0]);
		}
		else {
			exit();
		}
	}
	
}
?>