<?php
/**
 * @package aowp.aspect
 */

/**
 * @package aowp.aspect
 */
class AOWP_ConfigurationManager {
	const ASPECT_FOLDER_NAME = 'aspect';
	
	public static $WEAVING_TIME_FLAG = true;
	
	private static function _getConfigurationSamplePath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . 'ConfigurationSample.class.php';
	}
	private static function _getConfigurationPath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Configuration.class.php';
	}
	private static function _getRuntimeAutoloadplusFolder() {
		return AOWP_ConfigurationManager::getRuntimeSourcePath() . 'libs' . DIRECTORY_SEPARATOR .
			'autoloadplus';
	}
	
	public static function getCacheFolder() {
		return AOWP_ConfigurationManager::getRuntimeDataFolder() . DIRECTORY_SEPARATOR;
	}
	public static function getRuntimeSourcePath() {
		return AOWP_ConfigurationManager::getRuntimeDataFolder() . DIRECTORY_SEPARATOR . 'sources' . DIRECTORY_SEPARATOR;
	}
	public static function getRuntimeIncludePath($targetSourcePath = null) {
		if ($targetSourcePath === null) {
			return AOWP_ConfigurationManager::_getRuntimeAutoloadplusFolder() . DIRECTORY_SEPARATOR . 'bin' . DIRECTORY_SEPARATOR . 'include.php';
		}
		else {
			return AOWP_PHPFileManager::getRelativePath(AOWP_ConfigurationManager::getRuntimeIncludePath(), dirname($targetSourcePath));
		}
	}
	public static function getRuntimeAspectFolder() {
		return AOWP_ConfigurationManager::getRuntimeDataFolder() . DIRECTORY_SEPARATOR . AOWP_ConfigurationManager::ASPECT_FOLDER_NAME . DIRECTORY_SEPARATOR;
	}	
	public static function setupRuntimeEnvironment() {
		if (file_exists(AOWP_ConfigurationManager::getRuntimeSourcePath())) {
			AOWP_PHPFileManager::removeFolder(AOWP_ConfigurationManager::getRuntimeSourcePath());
		}
		AOWP_PHPFileManager::mkdir(AOWP_ConfigurationManager::getRuntimeSourcePath());
		AOWP_Logger::logging('Copy to runtime environment.');
		AOWP_PHPFileManager::copy(AOWP_ConfigurationManager::getAOWPClassPath() . DIRECTORY_SEPARATOR . 'classes', AOWP_ConfigurationManager::getRuntimeSourcePath());
		AOWP_PHPFileManager::copy(AOWP_ConfigurationManager::getAOWPClassPath() . DIRECTORY_SEPARATOR . 'libs', AOWP_ConfigurationManager::getRuntimeSourcePath());
		AOWP_ConfigurationManager::createConfiguration(
			realpath(AOWP_ConfigurationManager::getAOWPClassPath()),
			realpath(AOWP_ConfigurationManager::getProjectHomePath()),
			realpath(AOWP_ConfigurationManager::getAspectDirPath()),
			realpath(AOWP_ConfigurationManager::getRuntimeDataFolder()),
			AOWP_Configuration::INCLUDE_PHP_FILE_PATERN,
			AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN,
			realpath(AOWP_ConfigurationManager::getRuntimeSourcePath() . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'aspect')
		);
		ALP_Configuration::setProjectLocation(AOWP_ConfigurationManager::getRuntimeSourcePath(), AOWP_ConfigurationManager::_getRuntimeAutoloadplusFolder());
		$defLocMap = ALP_DefLocMapGenerator::generateDefLocMap(AOWP_ConfigurationManager::getRuntimeSourcePath() . 'classes');
		$defLocMap->saveMapping(AOWP_ConfigurationManager::_getRuntimeAutoloadplusFolder() . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'mapping.txt');
	}
	public static function setupAspectForRuntime() {
		if (file_exists(AOWP_ConfigurationManager::getRuntimeAspectFolder())) {
			AOWP_PHPFileManager::removeFolder(AOWP_ConfigurationManager::getRuntimeAspectFolder());
		}
		AOWP_PHPFileManager::mkdir(AOWP_ConfigurationManager::getRuntimeAspectFolder());
		AOWP_PHPFileManager::copy(AOWP_ConfigurationManager::getAspectDirPath(), AOWP_ConfigurationManager::getRuntimeDataFolder());
		if (basename(AOWP_ConfigurationManager::getAspectDirPath()) != AOWP_ConfigurationManager::ASPECT_FOLDER_NAME) {
			AOWP_PHPFileManager::move(AOWP_ConfigurationManager::getRuntimeDataFolder() . DIRECTORY_SEPARATOR . basename(AOWP_ConfigurationManager::getAspectDirPath()), AOWP_ConfigurationManager::getRuntimeDataFolder() . DIRECTORY_SEPARATOR . AOWP_ConfigurationManager::ASPECT_FOLDER_NAME);
		}
	}
	
	public static function getProjectHomePath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . AOWP_Configuration::PROJECT_HOME_PATH;
	}
	public static function getRuntimeDataFolder() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . AOWP_Configuration::RUNTIME_DATA_FOLDER;
	}
	public static function getAspectDirPath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . AOWP_Configuration::ASPECT_DIR_PATH;
	}
	public static function getAOWPClassPath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . AOWP_Configuration::AOWP_CLASS_PATH;
	}
	
	/**
	 * This method generates and saves PHP file to define class for AOWP's configuration at weaving time and runtime.<br/>
	 * This method should be invoked before parsing PHP files and weaving defined aspects.
	 * 
	 * @param $aowpHome
	 * @param $projectPath
	 * @param $aspectPath
	 * @param $dataFolderName
	 * @param $includPattern
	 * @param $excludeFilePattern
	 */
	public static function setupConfiguration(
		$aowpHome,
		$projectPath,
		$aspectPath,
		$dataFolderName,
		$includPattern,
		$excludeFilePattern,
		$configClassLocation = null
	) {
		AOWP_ConfigurationManager::createConfiguration(
			AOWP_PHPFileManager::getRelativePath($aowpHome, dirname(__FILE__)),
			AOWP_PHPFileManager::getRelativePath($projectPath, dirname(__FILE__)),
			AOWP_PHPFileManager::getRelativePath($aspectPath, dirname(__FILE__)),
			AOWP_PHPFileManager::getRelativePath($projectPath . DIRECTORY_SEPARATOR . $dataFolderName, dirname(__FILE__)),
			$includPattern,
			$excludeFilePattern,
			$configClassLocation
		);
	}
		
	public static function createConfiguration(
		$aowpHome,
		$projectPath,
		$aspectPath,
		$runtimeDataFolder,
		$includPattern,
		$excludeFilePattern,
		$configClassLocation = null
	) {
		AOWP_Logger::logging($aowpHome);
		AOWP_Logger::logging($projectPath);
		AOWP_Logger::logging($aspectPath);
		AOWP_Logger::logging($runtimeDataFolder);
		AOWP_Logger::setStartTime();
		$weavingDataFolder = $aowpHome . DIRECTORY_SEPARATOR . $runtimeDataFolder;
		$configClassLocation = $configClassLocation === null ?
			dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Configuration.class.php' :
			$configClassLocation . DIRECTORY_SEPARATOR . 'Configuration.class.php';
		
		// Generate configuration files.
		$configSampleFilePath = AOWP_ConfigurationManager::_getConfigurationSamplePath();
		$sampleContent = file_get_contents($configSampleFilePath);
		$src = array(
			'%AOWP_CLASS_PATH%', 
			'%PROJECT_HOME_PATH%', 
			'%ASPECT_DIR_PATH%', 
			'%RUNTIME_DATA_FOLDER%', 
			'%INCLUDE_PHP_FILE_PATERN%', 
			'%EXCLUDE_PHP_FILE_PATERN%'
		);
		AOWP_PHPFileManager::getRelativePath($projectPath . DIRECTORY_SEPARATOR . $runtimeDataFolder, dirname(__FILE__));
		$dist = array(
			AOWP_PHPFileManager::getRelativePath($aowpHome, dirname($configClassLocation)),
			AOWP_PHPFileManager::getRelativePath($projectPath, dirname($configClassLocation)),
			AOWP_PHPFileManager::getRelativePath($aspectPath, dirname($configClassLocation)),
			AOWP_PHPFileManager::getRelativePath($runtimeDataFolder, dirname($configClassLocation)),
			$includPattern,
			$excludeFilePattern
		);
		$configContent = str_replace($src, $dist, $sampleContent);
		if (AOWP_PHPFileManager::saveFile($configClassLocation, $configContent)) {
			AOWP_Logger::logging('[Setup configuration] Configuration class is created.');
		}
		else {
			AOWP_Logger::logging('[Setup configuration] Failed to save configuration file.');
		}
	}
	
}
?>