/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import java.io.IOException;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.Horizontal;
import net.osdn.pdf_brewer.Overflow;
import net.osdn.pdf_brewer.Vertical;
import net.osdn.pdf_brewer.instruction.Instruction;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class Context {
    private Context parent;
    private int indent;
    private double left;
    private double top;
    private double right;
    private double bottom;
    private FontLoader fontLoader;
    private String fontName;
    private float fontSize;
    private float lineHeight;
    private Horizontal textAlign;
    private Overflow textOverflow;
    private float lineWidth;
    private int lineStyle;
    private int capStyle;
    private Horizontal hAlign;
    private Vertical vAlign;

    public Context(FontLoader loader, PDRectangle mediaBox) {
        this.parent = null;
        this.indent = -1;
        this.left = 0.0;
        this.right = Instruction.pt2mm(mediaBox.getWidth());
        this.top = 0.0;
        this.bottom = Instruction.pt2mm(mediaBox.getHeight());
        this.fontLoader = loader;
        this.fontName = "serif";
        this.fontSize = 14.0f;
        this.lineHeight = 1.8f;
        this.textAlign = Horizontal.Left;
        this.textOverflow = Overflow.Wrap;
        this.lineWidth = 0.6666667f;
        this.lineStyle = 0;
        this.capStyle = -1;
        this.hAlign = Horizontal.Left;
        this.vAlign = Vertical.Top;
    }

    public Context(Context parent, int index) {
        this.parent = parent;
        this.indent = index;
        this.left = parent.getLeft();
        this.right = parent.getRight();
        this.top = parent.getTop();
        this.bottom = parent.getBottom();
        this.fontLoader = parent.getFontLoader();
        this.fontName = parent.getFontName();
        this.fontSize = parent.getFontSize();
        this.lineHeight = parent.getLineHeight();
        this.textAlign = parent.getTextAlignment();
        this.textOverflow = parent.getTextOverflow();
        this.lineWidth = parent.getLineWidth();
        this.lineStyle = parent.getLineStyle();
        this.capStyle = parent.getCapStyle();
        this.hAlign = parent.getHorizontalAlignment();
        this.vAlign = parent.getVerticalAlignment();
    }

    public Context getParent() {
        return this.parent;
    }

    public int getIndent() {
        return this.indent;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getRight() {
        return this.right;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBox(double left, double top, double right, double bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public Horizontal getHorizontalAlignment() {
        return this.hAlign;
    }

    public void setHorizontalAlignment(Horizontal hAlign) {
        this.hAlign = hAlign;
    }

    public Vertical getVerticalAlignment() {
        return this.vAlign;
    }

    public void setVerticalAlignment(Vertical vAlign) {
        this.vAlign = vAlign;
    }

    public FontLoader getFontLoader() {
        return this.fontLoader;
    }

    public void setFont(String fontName, float fontSize) throws IOException {
        TrueTypeFont ttf;
        if (fontName != null && (ttf = this.getFontLoader().getFont(fontName)) != null) {
            this.fontName = ttf.getName();
        }
        if (fontSize != Float.NaN && (double)fontSize > 0.0) {
            this.fontSize = fontSize;
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) throws IOException {
        TrueTypeFont ttf = this.getFontLoader().getFont(fontName);
        if (ttf != null) {
            this.fontName = ttf.getName();
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        if (fontSize != Float.NaN && (double)fontSize > 0.0) {
            this.fontSize = fontSize;
        }
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public Horizontal getTextAlignment() {
        return this.textAlign;
    }

    public void setTextAlignment(Horizontal textAlign) {
        this.textAlign = textAlign;
    }

    public Overflow getTextOverflow() {
        return this.textOverflow;
    }

    public void setTextOverflow(Overflow textOverflow) {
        this.textOverflow = textOverflow;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getCapStyle() {
        return this.capStyle;
    }

    public void setCapStyle(int capStyle) {
        this.capStyle = capStyle;
    }
}

