/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans.document;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlEntry;
import com.esotericsoftware.yamlbeans.document.YamlScalar;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlSequence
extends YamlElement
implements YamlDocument {
    List<YamlElement> elements = new LinkedList<YamlElement>();

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void addElement(YamlElement element) {
        this.elements.add(element);
    }

    @Override
    public void deleteElement(int item) throws YamlException {
        this.elements.remove(item);
    }

    @Override
    public YamlElement getElement(int item) throws YamlException {
        return this.elements.get(item);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.anchor != null) {
            sb.append('&');
            sb.append(this.anchor);
            sb.append(' ');
        }
        if (this.tag != null) {
            sb.append(" !");
            sb.append(this.tag);
        }
        if (!this.elements.isEmpty()) {
            sb.append('[');
            for (YamlElement element : this.elements) {
                sb.append(element.toString());
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public void emitEvent(Emitter emitter, YamlConfig.WriteConfig config) throws EmitterException, IOException {
        emitter.emit(new SequenceStartEvent(this.anchor, this.tag, this.tag == null, config.isFlowStyle()));
        for (YamlElement element : this.elements) {
            element.emitEvent(emitter, config);
        }
        emitter.emit(Event.SEQUENCE_END);
    }

    @Override
    public YamlEntry getEntry(String key) throws YamlException {
        throw new YamlException("Can only get entry on mapping!");
    }

    @Override
    public YamlEntry getEntry(int index) throws YamlException {
        throw new YamlException("Can only get entry on mapping!");
    }

    @Override
    public boolean deleteEntry(String key) throws YamlException {
        throw new YamlException("Can only delete entry on mapping!");
    }

    @Override
    public void setEntry(String key, boolean value) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setEntry(String key, Number value) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setEntry(String key, String value) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setEntry(String key, YamlElement value) throws YamlException {
        throw new YamlException("Can only set entry on mapping!");
    }

    @Override
    public void setElement(int item, boolean value) throws YamlException {
        this.elements.set(item, new YamlScalar(value));
    }

    @Override
    public void setElement(int item, Number value) throws YamlException {
        this.elements.set(item, new YamlScalar(value));
    }

    @Override
    public void setElement(int item, String value) throws YamlException {
        this.elements.set(item, new YamlScalar(value));
    }

    @Override
    public void setElement(int item, YamlElement element) throws YamlException {
        this.elements.set(item, element);
    }

    @Override
    public void addElement(boolean value) throws YamlException {
        this.elements.add(new YamlScalar(value));
    }

    @Override
    public void addElement(Number value) throws YamlException {
        this.elements.add(new YamlScalar(value));
    }

    @Override
    public void addElement(String value) throws YamlException {
        this.elements.add(new YamlScalar(value));
    }

    @Override
    public Iterator<YamlElement> iterator() {
        return this.elements.iterator();
    }
}

