/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.instruction;

import java.io.IOException;
import java.util.List;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.instruction.Instruction;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class Rect
extends Instruction {
    private double p1;
    private double p2;
    private double p3;
    private double p4;

    public Rect(int indent, List<Object> params) {
        super(indent, params);
        if (params.size() != 4) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(0) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(1) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(2) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        if (!(params.get(3) instanceof Number)) {
            throw new IllegalArgumentException();
        }
        this.p1 = ((Number)params.get(0)).doubleValue();
        this.p2 = ((Number)params.get(1)).doubleValue();
        this.p3 = ((Number)params.get(2)).doubleValue();
        this.p4 = ((Number)params.get(3)).doubleValue();
    }

    @Override
    public void process(PdfBrewer brewer, Context context) throws IOException {
        int lineStyle;
        float pageHeight = brewer.getPage().getMediaBox().getHeight();
        double x = this.p1 >= 0.0 ? context.getLeft() + this.p1 : context.getRight() + this.p1;
        double y = this.p2 >= 0.0 ? context.getTop() + this.p2 : context.getBottom() + this.p2;
        double w = this.p3 > 0.0 ? this.p3 : (this.p1 < 0.0 ? this.p3 : context.getRight() + this.p3 - x);
        double h = this.p4 > 0.0 ? this.p4 : (this.p2 < 0.0 ? this.p4 : context.getBottom() + this.p4 - y);
        float ptX = Rect.mm2pt(x);
        float ptY = pageHeight - Rect.mm2pt(y);
        float ptW = Rect.mm2pt(w);
        float ptH = Rect.mm2pt(-h);
        PDPageContentStream stream = brewer.getContentStream();
        float lw = context.getLineWidth();
        stream.setLineWidth(lw);
        int capStyle = context.getCapStyle();
        if (capStyle != 0 && capStyle != 1 && capStyle != 2) {
            capStyle = -1;
        }
        if ((lineStyle = context.getLineStyle()) == 1) {
            if (capStyle == -1) {
                capStyle = 1;
            }
            stream.setLineCapStyle(capStyle);
            stream.setLineDashPattern(new float[]{0.0f, lw * 2.5f}, 0.0f);
        } else if (lineStyle == 2) {
            if (capStyle == -1) {
                capStyle = 0;
            }
            stream.setLineCapStyle(capStyle);
            stream.setLineDashPattern(new float[]{lw * 3.0f, lw * 3.0f}, 0.0f);
        } else {
            if (capStyle == -1) {
                capStyle = 2;
            }
            stream.setLineCapStyle(capStyle);
            stream.setLineDashPattern(new float[]{lw, 0.0f}, 0.0f);
        }
        stream.addRect(ptX, ptY, ptW, ptH);
        stream.stroke();
    }
}

