/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.DeferredConstruction;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.esotericsoftware.yamlbeans.parser.CollectionStartEvent;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.EventType;
import com.esotericsoftware.yamlbeans.parser.Parser;
import com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class YamlReader {
    private final YamlConfig config;
    Parser parser;
    private final Map<String, Object> anchors = new LinkedHashMap<String, Object>();

    public YamlReader(Reader reader) {
        this(reader, new YamlConfig());
    }

    public YamlReader(Reader reader, YamlConfig config) {
        this.config = config;
        this.parser = new Parser(reader, config.readConfig.defaultVersion);
    }

    public YamlReader(String yaml) {
        this(new StringReader(yaml));
    }

    public YamlReader(String yaml, YamlConfig config) {
        this(new StringReader(yaml), config);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public Object get(String alias) {
        return this.anchors.get(alias);
    }

    public void close() throws IOException {
        this.parser.close();
        this.anchors.clear();
    }

    public Object read() throws YamlException {
        return this.read(null);
    }

    public <T> T read(Class<T> type) throws YamlException {
        return this.read(type, null);
    }

    public <T> T read(Class<T> type, Class elementType) throws YamlException {
        try {
            Event event;
            do {
                if ((event = this.parser.getNextEvent()) == null) {
                    return null;
                }
                if (event.type != EventType.STREAM_END) continue;
                return null;
            } while (event.type != EventType.DOCUMENT_START);
            return (T)this.readValue(type, elementType, null);
        }
        catch (Parser.ParserException ex) {
            throw new YamlException("Error parsing YAML.", ex);
        }
        catch (Tokenizer.TokenizerException ex) {
            throw new YamlException("Error tokenizing YAML.", ex);
        }
    }

    protected Object readValue(Class type, Class elementType, Class defaultType) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        String tag = null;
        String anchor = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case ALIAS: {
                this.parser.getNextEvent();
                anchor = ((AliasEvent)event).anchor;
                Object value = this.anchors.get(anchor);
                if (value == null) {
                    throw new YamlReaderException("Unknown anchor: " + anchor);
                }
                return value;
            }
            case MAPPING_START: 
            case SEQUENCE_START: {
                tag = ((CollectionStartEvent)event).tag;
                anchor = ((CollectionStartEvent)event).anchor;
                break;
            }
            case SCALAR: {
                tag = ((ScalarEvent)event).tag;
                anchor = ((ScalarEvent)event).anchor;
                break;
            }
        }
        return this.readValueInternal(this.chooseType(tag, defaultType, type), elementType, anchor);
    }

    private Class<?> chooseType(String tag, Class<?> defaultType, Class<?> providedType) throws YamlReaderException {
        if (tag != null) {
            Class userConfiguredByTag = this.config.tagToClass.get(tag);
            if (userConfiguredByTag != null) {
                return userConfiguredByTag;
            }
            ClassLoader classLoader = this.config.readConfig.classLoader == null ? this.getClass().getClassLoader() : this.config.readConfig.classLoader;
            try {
                Class<?> loadedFromTag = this.findTagClass(tag, classLoader);
                if (loadedFromTag != null) {
                    return loadedFromTag;
                }
            }
            catch (ClassNotFoundException e) {
                throw new YamlReaderException("Unable to find class specified by tag: " + tag);
            }
        }
        if (defaultType != null) {
            return defaultType;
        }
        return providedType;
    }

    protected Class<?> findTagClass(String tag, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(tag, true, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private Object readValueInternal(Class type, Class elementType, String anchor) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        Object event;
        if (type == null || type == Object.class) {
            event = this.parser.peekNextEvent();
            switch (((Event)event).type) {
                case MAPPING_START: {
                    type = LinkedHashMap.class;
                    break;
                }
                case SCALAR: {
                    type = String.class;
                    break;
                }
                case SEQUENCE_START: {
                    type = ArrayList.class;
                    break;
                }
                default: {
                    throw new YamlReaderException("Expected scalar, sequence, or mapping but found: " + (Object)((Object)((Event)event).type));
                }
            }
        }
        if (type == String.class) {
            event = this.parser.getNextEvent();
            if (((Event)event).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for String type but found: " + (Object)((Object)((Event)event).type));
            }
            String string = ((ScalarEvent)event).value;
            if (anchor != null) {
                this.anchors.put(anchor, string);
            }
            return string;
        }
        if (Beans.isScalar(type)) {
            event = this.parser.getNextEvent();
            if (((Event)event).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for primitive type '" + type.getClass() + "' but found: " + (Object)((Object)((Event)event).type));
            }
            String string = ((ScalarEvent)event).value;
            try {
                Object convertedValue;
                if (type == String.class) {
                    convertedValue = string;
                } else if (type == Integer.TYPE) {
                    convertedValue = string.length() == 0 ? 0 : Integer.decode(string);
                } else if (type == Integer.class) {
                    convertedValue = string.length() == 0 ? null : Integer.decode(string);
                } else if (type == Boolean.TYPE) {
                    convertedValue = string.length() == 0 ? false : Boolean.valueOf(string);
                } else if (type == Boolean.class) {
                    convertedValue = string.length() == 0 ? null : Boolean.valueOf(string);
                } else if (type == Float.TYPE) {
                    convertedValue = Float.valueOf(string.length() == 0 ? 0.0f : Float.valueOf(string).floatValue());
                } else if (type == Float.class) {
                    convertedValue = string.length() == 0 ? null : Float.valueOf(string);
                } else if (type == Double.TYPE) {
                    convertedValue = string.length() == 0 ? 0.0 : Double.valueOf(string);
                } else if (type == Double.class) {
                    convertedValue = string.length() == 0 ? null : Double.valueOf(string);
                } else if (type == Long.TYPE) {
                    convertedValue = string.length() == 0 ? 0L : Long.decode(string);
                } else if (type == Long.class) {
                    convertedValue = string.length() == 0 ? null : Long.decode(string);
                } else if (type == Short.TYPE) {
                    convertedValue = string.length() == 0 ? (short)0 : Short.decode(string);
                } else if (type == Short.class) {
                    convertedValue = string.length() == 0 ? null : Short.decode(string);
                } else if (type == Character.TYPE) {
                    convertedValue = Character.valueOf(string.length() == 0 ? (char)'\u0000' : string.charAt(0));
                } else if (type == Character.class) {
                    convertedValue = string.length() == 0 ? null : Character.valueOf(string.charAt(0));
                } else if (type == Byte.TYPE) {
                    convertedValue = string.length() == 0 ? (byte)0 : Byte.decode(string);
                } else if (type == Byte.class) {
                    convertedValue = string.length() == 0 ? null : Byte.decode(string);
                } else {
                    throw new YamlException("Unknown field type.");
                }
                if (anchor != null) {
                    this.anchors.put(anchor, convertedValue);
                }
                return convertedValue;
            }
            catch (Exception ex) {
                throw new YamlReaderException("Unable to convert value to required type \"" + type + "\": " + string, ex);
            }
        }
        if (Enum.class.isAssignableFrom(type)) {
            event = this.parser.getNextEvent();
            if (((Event)event).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for enum type but found: " + (Object)((Object)((Event)event).type));
            }
            String string = ((ScalarEvent)event).value;
            if (string.length() == 0) {
                return null;
            }
            try {
                return Enum.valueOf(type, string);
            }
            catch (Exception ex) {
                throw new YamlReaderException("Unable to find enum value '" + string + "' for enum class: " + type.getName());
            }
        }
        for (Map.Entry entry : this.config.scalarSerializers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(type)) continue;
            ScalarSerializer serializer = (ScalarSerializer)entry.getValue();
            Event event2 = this.parser.getNextEvent();
            if (event2.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for type '" + type + "' to be deserialized by scalar serializer '" + serializer.getClass().getName() + "' but found: " + (Object)((Object)event2.type));
            }
            Object value = serializer.read(((ScalarEvent)event2).value);
            if (anchor != null) {
                this.anchors.put(anchor, value);
            }
            return value;
        }
        event = this.parser.peekNextEvent();
        switch (((Event)event).type) {
            case MAPPING_START: {
                void var5_11;
                Object object;
                event = this.parser.getNextEvent();
                try {
                    object = this.createObject(type);
                }
                catch (InvocationTargetException ex) {
                    throw new YamlReaderException("Error creating object.", ex);
                }
                if (anchor != null) {
                    this.anchors.put(anchor, object);
                }
                ArrayList<Object> keys = new ArrayList<Object>();
                while (true) {
                    if (this.parser.peekNextEvent().type == EventType.MAPPING_END) break;
                    Object key = this.readValue(null, null, null);
                    boolean isExplicitKey = key instanceof Map;
                    Object var9_31 = null;
                    if (isExplicitKey) {
                        Map.Entry nameValuePair = ((Map)key).entrySet().iterator().next();
                        key = nameValuePair.getKey();
                        Object v = nameValuePair.getValue();
                    }
                    if (object instanceof Map) {
                        void var9_35;
                        if (!isExplicitKey) {
                            Object object2 = this.readValue(elementType, null, null);
                        }
                        if (!this.config.allowDuplicates && ((Map)object).containsKey(key)) {
                            throw new YamlReaderException("Duplicate key found '" + key + "'");
                        }
                        ((Map)object).put(key, var9_35);
                        continue;
                    }
                    try {
                        void var9_37;
                        if (!this.config.allowDuplicates && keys.contains(key)) {
                            throw new YamlReaderException("Duplicate key found '" + key + "'");
                        }
                        keys.add(key);
                        Beans.Property property = Beans.getProperty(type, (String)key, this.config.beanProperties, this.config.privateFields, this.config);
                        if (property == null) {
                            if (this.config.readConfig.ignoreUnknownProperties) continue;
                            throw new YamlReaderException("Unable to find property '" + key + "' on class: " + type.getName());
                        }
                        Class propertyElementType = this.config.propertyToElementType.get(property);
                        if (propertyElementType == null) {
                            propertyElementType = property.getElementType();
                        }
                        Class propertyDefaultType = this.config.propertyToDefaultType.get(property);
                        if (!isExplicitKey) {
                            Object object3 = this.readValue(property.getType(), propertyElementType, propertyDefaultType);
                        }
                        property.set(object, var9_37);
                    }
                    catch (Exception ex) {
                        if (ex instanceof YamlReaderException) {
                            throw (YamlReaderException)ex;
                        }
                        throw new YamlReaderException("Error setting property '" + key + "' on class: " + type.getName(), ex);
                    }
                }
                this.parser.getNextEvent();
                if (object instanceof DeferredConstruction) {
                    try {
                        Object object4 = ((DeferredConstruction)object).construct();
                        if (anchor != null) {
                            this.anchors.put(anchor, object4);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        throw new YamlReaderException("Error creating object.", ex);
                    }
                }
                return var5_11;
            }
            case SEQUENCE_START: {
                void var5_14;
                event = this.parser.getNextEvent();
                if (Collection.class.isAssignableFrom(type)) {
                    try {
                        Collection collection = (Collection)Beans.createObject(type, this.config.privateConstructors);
                    }
                    catch (InvocationTargetException ex) {
                        throw new YamlReaderException("Error creating object.", ex);
                    }
                } else if (type.isArray()) {
                    ArrayList arrayList = new ArrayList();
                    elementType = type.getComponentType();
                } else {
                    throw new YamlReaderException("A sequence is not a valid value for the type: " + type.getName());
                }
                if (!type.isArray() && anchor != null) {
                    this.anchors.put(anchor, var5_14);
                }
                while (true) {
                    event = this.parser.peekNextEvent();
                    if (((Event)event).type == EventType.SEQUENCE_END) break;
                    var5_14.add(this.readValue(elementType, null, null));
                }
                this.parser.getNextEvent();
                if (!type.isArray()) {
                    return var5_14;
                }
                Object array = Array.newInstance(elementType, var5_14.size());
                int i = 0;
                for (Object e : var5_14) {
                    Array.set(array, i++, e);
                }
                if (anchor != null) {
                    this.anchors.put(anchor, array);
                }
                return array;
            }
            case SCALAR: {
                if (((ScalarEvent)event).value.length() != 0) break;
                event = this.parser.getNextEvent();
                return null;
            }
        }
        throw new YamlReaderException("Expected data for a " + type.getName() + " field but found: " + (Object)((Object)((Event)event).type));
    }

    protected Object createObject(Class type) throws InvocationTargetException {
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(type, this.config);
        if (deferredConstruction != null) {
            return deferredConstruction;
        }
        return Beans.createObject(type, this.config.privateConstructors);
    }

    public static void main(String[] args) throws Exception {
        YamlReader reader = new YamlReader(new FileReader("test/test.yml"));
        System.out.println(reader.read());
    }

    public class YamlReaderException
    extends YamlException {
        public YamlReaderException(String message, Throwable cause) {
            super("Line " + YamlReader.this.parser.getLineNumber() + ", column " + YamlReader.this.parser.getColumn() + ": " + message, cause);
        }

        public YamlReaderException(String message) {
            this(message, null);
        }
    }
}

