package net.osdn.util.yaml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.mozilla.universalchardet.UniversalDetector;

public class CharsetDetector {
	
	private static Charset UTF_8 = Charset.forName("UTF-8");
    private static UniversalDetector detector = new UniversalDetector(null);
    private static byte[] buf = new byte[8192];

    public static synchronized Charset detectCharset(File file) throws IOException {
    	if(file == null) {
    		throw new NullPointerException();
    	}
    	
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            return detectCharset(in);
        } finally {
        	if(in != null) {
        		try { in.close(); } catch(Exception e) {}
        	}
        }
    }
    
    public static synchronized Charset detectCharset(InputStream in) throws IOException {
    	if(in == null) {
    		throw new NullPointerException();
    	}
    	
        try {
        	int size;
        	while((size = in.read(buf)) > 0 && !detector.isDone()) {
                detector.handleData(buf, 0, size);
        	}
            detector.dataEnd();
            String charset = detector.getDetectedCharset();
            if(charset != null) {
            	return Charset.forName(charset);
            } else {
            	return null;
            }
        } finally {
            detector.reset();
        }
    }
    
    public static List<String> readAllLines(File file) throws IOException {
    	List<String> lines = new ArrayList<String>();
    	
    	Charset charset = CharsetDetector.detectCharset(file);
    	if(charset == null) {
    		charset = UTF_8;
    	}
    	
    	BufferedReader reader = null;
    	try {
    		boolean isFirst = true;
    		reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), charset));
    		String line;
    		while((line = reader.readLine()) != null) {
				//最初の読み取りが 0xFEFF で始まる場合、UTF-8のBOMと見なして除去します。
				if(isFirst) {
					if(charset.equals(UTF_8) && line.length() > 0 && line.charAt(0) == (char)0xFEFF) {
						line = line.substring(1);
					}
					isFirst = false;
				}
				lines.add(line);
			}
    	} finally {
    		if(reader != null) {
    			reader.close();
    		}
    	}
    	return lines;
    }
}
