/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.TrustRecorder;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JNLPSignedResourcesHelper {
    static final String SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING = "Signed jnlp file removed after signing.";
    static final boolean DEBUG = Config.getDeployDebug() || Config.getPluginDebug();
    LaunchDesc mainDesc = null;
    private Thread warmupValidationThread = null;
    private boolean warmupOk = true;
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";
    private static final String SIGNED_JNLP_TEMPLATE = "JNLP-INF/APPLICATION_TEMPLATE.JNLP";

    public JNLPSignedResourcesHelper(LaunchDesc launchDesc) {
        this.mainDesc = launchDesc;
        AppPolicy.createInstance(this.mainDesc.getCanonicalHome().getHost());
    }

    public synchronized void warmup() {
        if (this.warmupOk) {
            WarmupValidator warmupValidator = new WarmupValidator();
            this.warmupValidationThread = new Thread(warmupValidator);
            this.warmupValidationThread.setDaemon(true);
            this.warmupValidationThread.start();
        }
    }

    public void checkSignedLaunchDesc() throws IOException, JNLPException {
        this.checkSignedLaunchDesc(null, null);
    }

    public void checkSignedLaunchDesc(URL uRL, URL uRL2) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        JNLPSignedResourcesHelper.addExtensions(arrayList, this.mainDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
            this.checkSignedLaunchDescHelper(launchDesc, uRL, uRL2);
        }
    }

    synchronized void ensureWarmupFinished() {
        if (this.warmupValidationThread != null) {
            try {
                this.warmupValidationThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.warmupValidationThread = null;
            this.warmupOk = false;
        }
    }

    public boolean checkSignedResources(Preloader preloader, boolean bl) throws IOException, JNLPException, ExitException {
        if (TrustRecorder.isAllSigned((URL)this.mainDesc.getCanonicalHome())) {
            Config.getHooks().trackUsage(this.mainDesc.getAppInfo(), this.mainDesc.getMainDeploymentRuleSet());
            return true;
        }
        if (TrustRecorder.isNotAllSigned((URL)this.mainDesc.getCanonicalHome())) {
            return false;
        }
        this.ensureWarmupFinished();
        boolean bl2 = true;
        ArrayList arrayList = new ArrayList();
        JNLPSignedResourcesHelper.addExtensions(arrayList, this.mainDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
            launchDesc.setParentURL(this.mainDesc.getParentURL());
            bl2 = JNLPSignedResourcesHelper.checkSignedResourcesHelper(launchDesc, preloader, bl) && bl2;
        }
        if (!bl) {
            TrustRecorder.recordAllSigned((URL)this.mainDesc.getCanonicalHome(), (boolean)bl2);
        }
        return bl2;
    }

    public static void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        if (launchDesc == null) {
            return;
        }
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        JNLPSignedResourcesHelper.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private void checkSignedLaunchDescHelper(LaunchDesc launchDesc, URL uRL, URL uRL2) throws IOException, JNLPException {
        block14: {
            byte[] byArray = null;
            byte[] byArray2 = null;
            JNLPSigningException jNLPSigningException = null;
            try {
                byArray2 = JNLPSignedResourcesHelper.getSignedJNLPFile(launchDesc, true);
                if (byArray2 != null) {
                    try {
                        launchDesc.checkSigningTemplate(byArray2);
                        if (DEBUG) {
                            Trace.println((String)"Signed JNLP Template matches LaunchDesc", (TraceLevel)TraceLevel.SECURITY);
                        }
                        return;
                    }
                    catch (JNLPSigningException jNLPSigningException2) {
                        if (DEBUG) {
                            Trace.println((String)"Signed JNLP Template fails to match ld", (TraceLevel)TraceLevel.SECURITY);
                        }
                        jNLPSigningException = jNLPSigningException2;
                    }
                }
                if ((byArray = JNLPSignedResourcesHelper.getSignedJNLPFile(launchDesc, false)) == null) {
                    if (jNLPSigningException != null) {
                        throw jNLPSigningException;
                    }
                    break block14;
                }
                if (Arrays.equals(SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING.getBytes(), byArray)) {
                    throw new JNLPSigningException(launchDesc, SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING);
                }
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray, uRL, uRL2, launchDesc.getLocation());
                if (Trace.isEnabled((TraceLevel)TraceLevel.SECURITY)) {
                    Trace.println((String)"Downloaded JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)launchDesc.toString(), (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)launchDesc2.toString(), (TraceLevel)TraceLevel.SECURITY);
                }
                launchDesc.checkSigning(launchDesc2);
                return;
            }
            catch (LaunchDescException launchDescException) {
                launchDescException.setIsSignedLaunchDesc();
                throw launchDescException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (JNLPException jNLPException) {
                throw jNLPException;
            }
        }
        if (launchDesc.getCachedCertificates() != null && launchDesc.getCachedCertificates()[0].isSignedJNLP()) {
            throw new JNLPSigningException(launchDesc, null);
        }
    }

    public static boolean hasProgressResources(ResourcesDesc resourcesDesc) {
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!jARDescArray[i].isProgressJar()) continue;
            return true;
        }
        return false;
    }

    private static boolean performSecurityCheckForSandbox(LaunchDesc launchDesc, Preloader preloader, CodeSource codeSource, boolean bl) throws ExitException {
        AppInfo appInfo = launchDesc.getAppInfo();
        try {
            if (bl) {
                appInfo.setPermissionAttrOverride();
            }
            SandboxSecurity.isPermissionGranted((CodeSource)codeSource, (AppInfo)appInfo, (DeploymentRuleSet)launchDesc.getMainDeploymentRuleSet(), (Preloader)preloader);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException.getMessage(), securityException, 0);
        }
        finally {
            appInfo.unsetPermissionAttrOverride();
        }
        return launchDesc.isSecureJVMArgs();
    }

    private static boolean checkSignedResourcesHelper(LaunchDesc launchDesc, Preloader preloader, boolean bl) throws IOException, JNLPException, ExitException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        if (bl && !JNLPSignedResourcesHelper.hasProgressResources(resourcesDesc)) {
            return true;
        }
        CodeSource codeSource = null;
        if (launchDesc.isSecure() && ((codeSource = JNLPSignedResourcesHelper.getMainJarCodeSource(launchDesc, bl)) == null || codeSource.getCertificates() == null || !Config.isJavaVersionAtLeast16())) {
            return JNLPSignedResourcesHelper.performSecurityCheckForSandbox(launchDesc, preloader, codeSource, bl);
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        final AtomicBoolean atomicBoolean3 = new AtomicBoolean(true);
        AtomicBoolean atomicBoolean4 = new AtomicBoolean(false);
        AtomicBoolean atomicBoolean5 = new AtomicBoolean(true);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        URL uRL = launchDesc.getCanonicalHome();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicReference<Object> atomicReference2 = new AtomicReference<Object>(null);
        SigningInfo signingInfo = null;
        if (DEBUG) {
            Trace.println((String)("Validating signatures for " + launchDesc.getLocation() + " " + launchDesc.getSourceURL()), (TraceLevel)TraceLevel.SECURITY);
        }
        if (launchDesc.getLocation() != null) {
            object4 = launchDesc.getSourceURL();
            if (object4 == null) {
                object4 = launchDesc.getLocation();
            }
            signingInfo = new SigningInfo((URL)object4, launchDesc.getVersion());
        }
        object4 = new SigningInfo[jARDescArray.length];
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; !bl3 && i < jARDescArray.length; ++i) {
            object3 = jARDescArray[i];
            object4[i] = new SigningInfo(((JARDesc)object3).getLocation(), ((JARDesc)object3).getVersion());
            if (DEBUG) {
                Trace.println((String)("Round 1 (" + i + " out of " + jARDescArray.length + "):" + ((JARDesc)object3).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
            }
            if (object4[i].isFileKnownToBeNotCached()) {
                if (DEBUG) {
                    Trace.println((String)("    Skip: " + ((JARDesc)object3).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                }
                atomicBoolean2.set(true);
                continue;
            }
            bl3 = true;
            if (!DEBUG) continue;
            Trace.println((String)("Entry [" + ((JARDesc)object3).getLocationString() + "] is not prevalidated. Revert to full validation of this JAR."), (TraceLevel)TraceLevel.SECURITY);
        }
        atomicBoolean5.set(false);
        final AtomicReference<Object> atomicReference3 = new AtomicReference<Object>(null);
        object3 = new AtomicReference<LaunchDesc>(launchDesc);
        ArrayList<2> arrayList = new ArrayList<2>();
        for (int i = 0; i < jARDescArray.length; ++i) {
            object2 = new AtomicReference<JARDesc>(jARDescArray[i]);
            object = new AtomicReference(object4[i]);
            Callable callable = new Callable((AtomicReference)object2, (AtomicReference)object, atomicBoolean2, atomicBoolean4, atomicBoolean5, atomicReference2, (AtomicReference)object3, atomicReference, atomicInteger){
                final /* synthetic */ AtomicReference val$jdsRef;
                final /* synthetic */ AtomicReference val$sInfoRef;
                final /* synthetic */ AtomicBoolean val$anySkipped;
                final /* synthetic */ AtomicBoolean val$isMainJarEmpty;
                final /* synthetic */ AtomicBoolean val$nonEmptyJarFound;
                final /* synthetic */ AtomicReference val$unsigned;
                final /* synthetic */ AtomicReference val$ldRef;
                final /* synthetic */ AtomicReference val$certChainsRef;
                final /* synthetic */ AtomicInteger val$jarsCached;
                {
                    this.val$jdsRef = atomicReference2;
                    this.val$sInfoRef = atomicReference32;
                    this.val$anySkipped = atomicBoolean32;
                    this.val$isMainJarEmpty = atomicBoolean4;
                    this.val$nonEmptyJarFound = atomicBoolean5;
                    this.val$unsigned = atomicReference4;
                    this.val$ldRef = atomicReference5;
                    this.val$certChainsRef = atomicReference6;
                    this.val$jarsCached = atomicInteger;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() {
                    if (atomicReference3.get() != null || !atomicBoolean.get() || !atomicBoolean3.get()) {
                        return null;
                    }
                    JARDesc jARDesc = (JARDesc)this.val$jdsRef.get();
                    SigningInfo signingInfo = (SigningInfo)this.val$sInfoRef.get();
                    if (signingInfo == null) {
                        signingInfo = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
                    }
                    if (signingInfo.isFileKnownToBeNotCached()) {
                        if (DEBUG) {
                            Trace.println((String)("    Skip " + jARDesc.getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                        }
                        this.val$anySkipped.set(true);
                        return null;
                    }
                    List list = null;
                    try {
                        list = signingInfo.check();
                    }
                    catch (IOException iOException) {
                        atomicReference3.compareAndSet(null, iOException);
                        return null;
                    }
                    if (signingInfo.isJarKnownToBeEmpty()) {
                        if (jARDesc.isMainJarFile()) {
                            this.val$isMainJarEmpty.set(true);
                        }
                        return null;
                    }
                    this.val$nonEmptyJarFound.set(true);
                    if (list == null) {
                        AtomicBoolean atomicBoolean2 = atomicBoolean;
                        synchronized (atomicBoolean2) {
                            if (atomicBoolean.get()) {
                                atomicBoolean.set(false);
                                this.val$unsigned.set(jARDesc.getLocation());
                            }
                        }
                        if (((LaunchDesc)this.val$ldRef.get()).getSecurityModel() != 0) {
                            atomicBoolean2 = ResourceProvider.get().getCachedResource(jARDesc.getLocation(), jARDesc.getVersion());
                            ResourceProvider.get().markRetired((Resource)atomicBoolean2, true);
                        }
                        return null;
                    }
                    if (!this.val$certChainsRef.compareAndSet(null, list)) {
                        List list2 = null;
                        AtomicReference atomicReference = this.val$certChainsRef;
                        synchronized (atomicReference) {
                            this.val$certChainsRef.set(SigningInfo.overlapChainLists(list, (List)this.val$certChainsRef.get()));
                            list2 = (List)this.val$certChainsRef.get();
                        }
                        if (DEBUG) {
                            Trace.println((String)("Have " + (list2 == null ? 0 : list2.size()) + " common certificates after processing " + jARDesc.getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                        }
                        if (list2 == null) {
                            atomicBoolean3.set(false);
                            if (((LaunchDesc)this.val$ldRef.get()).getSecurityModel() != 0) {
                                atomicReference = ResourceProvider.get().getCachedResource(jARDesc.getLocation(), jARDesc.getVersion());
                                ResourceProvider.get().markRetired((Resource)atomicReference, true);
                            }
                        }
                    }
                    this.val$jarsCached.incrementAndGet();
                    return null;
                }
            };
            arrayList.add(callable);
        }
        if (arrayList.size() > 0) {
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                executorService.invokeAll(arrayList);
            }
            catch (InterruptedException interruptedException) {
                executorService.shutdownNow();
                throw new RuntimeException(interruptedException);
            }
            executorService.shutdown();
        }
        if (atomicBoolean4.get()) {
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.main.jar.empty"), null);
        }
        if (!atomicBoolean3.get()) {
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
        }
        if (atomicReference3.get() != null) {
            throw new RuntimeException(atomicReference3.get());
        }
        if (!launchDesc.isSecure()) {
            if (!atomicBoolean.get()) {
                String string = (String)ToolkitStore.get().getAppContext().get((Object)"jarverifier.weak.ctx_key");
                throw new UnsignedAccessViolationException(launchDesc, atomicReference2.get(), true, string);
            }
            List list = atomicReference.get();
            object2 = JNLPSignedResourcesHelper.normalizeCertificateList(list);
            if (launchDesc.getCachedCertificates() != null) {
                object = launchDesc.getCachedCertificates();
                for (int i = 0; i < ((CachedCertificatesHelper[])object).length; ++i) {
                    JNLPSignedResourcesHelper.checkCachedChain(launchDesc, (List)object2, object[i].getCertPath());
                }
            }
            if (atomicInteger.get() > 0) {
                object = null;
                JARDesc jARDesc = launchDesc.getMainJar();
                URL uRL2 = jARDesc != null ? jARDesc.getLocation() : launchDesc.getCanonicalHome();
                object = Config.isJavaVersionAtLeast15() ? new CodeSource(uRL2, list.toArray(new CodeSigner[list.size()])) : new CodeSource(uRL2, object2.toArray(new Certificate[object2.size()]));
                long l = AppPolicy.getInstance().grantUnrestrictedAccess(launchDesc, launchDesc.getMainDeploymentRuleSet(), (CodeSource)object, preloader, bl);
                bl2 = true;
            } else {
                bl2 = true;
            }
        } else {
            return JNLPSignedResourcesHelper.performSecurityCheckForSandbox(launchDesc, preloader, codeSource, bl);
        }
        if (bl2 && !atomicBoolean2.get() && atomicBoolean5.get()) {
            launchDesc.setTrusted();
        }
        if (DEBUG) {
            Trace.println((String)("LD - All JAR files signed: " + uRL), (TraceLevel)TraceLevel.BASIC);
        }
        return atomicBoolean.get();
    }

    static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException {
        if (launchDesc.getResources() == null || launchDesc.isLibrary()) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getMainJar();
        if (jARDesc == null) {
            return null;
        }
        return JNLPSignedResourcesHelper.getSignedJNLPBits(jARDesc.getLocation(), jARDesc.getVersion(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSignedJNLPBits(URL uRL, String string, boolean bl) throws IOException {
        String string2 = bl ? SIGNED_JNLP_TEMPLATE : SIGNED_JNLP_ENTRY;
        ZipFile zipFile = null;
        try {
            Object object;
            Object object2;
            zipFile = new JarFile(ResourceProvider.get().getCachedResourceFilePath(uRL, string), false);
            Object object3 = ((JarFile)zipFile).getJarEntry(string2);
            if (object3 == null) {
                object2 = ((JarFile)zipFile).entries();
                while (object2.hasMoreElements() && object3 == null) {
                    object = (JarEntry)object2.nextElement();
                    if (!((ZipEntry)object).getName().equalsIgnoreCase(string2)) continue;
                    object3 = object;
                }
            }
            if (object3 == null) {
                if (JNLPSignedResourcesHelper.hasSigningEntryForFile((JarFile)zipFile, string2)) {
                    Trace.println((String)("Signed jnlp file: " + string2 + "was removed from jar file: " + uRL), (TraceLevel)TraceLevel.SECURITY);
                    object2 = SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING.getBytes();
                    return object2;
                }
                object2 = null;
                return object2;
            }
            object2 = new byte[(int)((ZipEntry)object3).getSize()];
            object = new DataInputStream(((JarFile)zipFile).getInputStream((ZipEntry)object3));
            ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
            ((FilterInputStream)object).close();
            Object object4 = object2;
            return object4;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static boolean hasSigningEntryForFile(JarFile jarFile, String string) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName().toUpperCase(Locale.ENGLISH);
            if (!string2.startsWith("META-INF/") || !string2.endsWith(".SF")) continue;
            try {
                Manifest manifest = new Manifest(jarFile.getInputStream(jarEntry));
                for (String string3 : manifest.getEntries().keySet()) {
                    if (!string.equalsIgnoreCase(string3)) continue;
                    return true;
                }
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
        return false;
    }

    static void checkCachedChain(LaunchDesc launchDesc, List list, CertPath certPath) throws LaunchDescException {
        if (list == null) {
            return;
        }
        List<? extends Certificate> list2 = certPath.getCertificates();
        for (int i = 0; i < list2.size(); ++i) {
            Certificate certificate = list2.get(i);
            if (list.contains(certificate)) continue;
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.unmatched.embedded.cert"), null);
        }
    }

    static List normalizeCertificateList(List list) {
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                if (Config.isJavaVersionAtLeast15() && list.get(i) instanceof CodeSigner) {
                    object = (CodeSigner)list.get(i);
                    CertPath certPath = ((CodeSigner)object).getSignerCertPath();
                    if (certPath == null) continue;
                    arrayList.addAll(certPath.getCertificates());
                    continue;
                }
                if (!(list.get(i) instanceof SigningInfo.CertChain)) continue;
                object = (SigningInfo.CertChain)list.get(i);
                arrayList.addAll(Arrays.asList(((SigningInfo.CertChain)object).getCertificates()));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static CodeSource getMainJarCodeSource(LaunchDesc launchDesc, boolean bl) {
        Certificate[] certificateArray = null;
        CodeSigner[] codeSignerArray = null;
        JARDesc jARDesc = null;
        jARDesc = bl ? launchDesc.getResources().getProgressJar() : launchDesc.getMainJar();
        if (jARDesc != null) {
            try {
                SigningInfo signingInfo = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
                if (Config.isJavaVersionAtLeast15()) {
                    List list = signingInfo.check();
                    if (list == null) {
                        throw new JARSigningException(jARDesc.getLocation(), jARDesc.getVersion(), 3);
                    }
                    codeSignerArray = list.toArray(new CodeSigner[list.size()]);
                } else {
                    List list = JNLPSignedResourcesHelper.normalizeCertificateList(signingInfo.check());
                    certificateArray = list.toArray(new Certificate[list.size()]);
                }
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                Trace.println((String)("Treat jar as unsigned due to exception: " + exception), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        if (Config.isJavaVersionAtLeast15()) {
            return new CodeSource(jARDesc != null ? jARDesc.getLocation() : launchDesc.getCanonicalHome(), codeSignerArray);
        }
        return new CodeSource(jARDesc != null ? jARDesc.getLocation() : launchDesc.getCanonicalHome(), certificateArray);
    }

    class WarmupValidator
    implements Runnable {
        WarmupValidator() {
        }

        public void run() {
            if (DEBUG) {
                Trace.println((String)"Staring warmup validation", (TraceLevel)TraceLevel.SECURITY);
            }
            ArrayList arrayList = new ArrayList();
            JNLPSignedResourcesHelper.addExtensions(arrayList, JNLPSignedResourcesHelper.this.mainDesc);
            for (int i = 0; i < arrayList.size(); ++i) {
                LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
                try {
                    this.processSingleDesc(launchDesc);
                    continue;
                }
                catch (Exception exception) {
                    Trace.ignored((Throwable)exception);
                }
            }
        }

        private void processSingleDesc(LaunchDesc launchDesc) throws GeneralSecurityException, IOException {
            CachedCertificatesHelper[] cachedCertificatesHelperArray = launchDesc.getCachedCertificates();
            if (cachedCertificatesHelperArray != null) {
                for (int i = 0; i < cachedCertificatesHelperArray.length; ++i) {
                    Certificate[] certificateArray = cachedCertificatesHelperArray[i].getCertPath().getCertificates().toArray(new X509Certificate[0]);
                    CodeSource codeSource = new CodeSource(launchDesc.getCanonicalHome(), certificateArray);
                    TrustDecider.validateChainForWarmup((X509Certificate[])certificateArray, (CodeSource)codeSource, (int)i, (AppInfo)launchDesc.getAppInfo(), (DeploymentRuleSet)launchDesc.getMainDeploymentRuleSet());
                }
            }
        }
    }
}

