/*
 * Copyright (c) 2000-2003 SOFTWARE AG, All Rights Reserved.
 */


package com.softwareag.tamino.db.api.objectModel.dom4j;

import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import org.dom4j.Element;


/**
 ** TDOM4JElementIterator defines all operations needed for an unidirectional
 ** iterator that is capable to navigate typesafe over org.dom4j.Element
 ** instances in forward direction. This iterator can directly be created
 ** from a given TXMLObjectIterator for TXMLObject instances that make use
 ** of DOM4J as the object model.
 **
 **/

public class TDOM4JElementIterator {
	
	/**
	 ** Special Constructor. Intializes this iterator from a TResultSetIterator instance.
	 **/
	public TDOM4JElementIterator(TXMLObjectIterator xmlObjectIterator) {
		this.xmlObjectIterator = xmlObjectIterator;
	}
	
	/**
	 ** Indicates if iterator has next Element instance.
	 **/
	public boolean hasNext() {
		return xmlObjectIterator.hasNext();
	}
	
	/**
	 ** Returns the next element in the list. This method may be called repeatedly to iterate
	 ** through the list.
	 **
	 ** @return The next org.dom4j.Element instance.
	 ** @exception NoSuchElementException if iteration has no more elements.
	 ** @exception TIteratorException if iteration failed because of an underlying Tamino problem.
	 **/
	public Element next() throws TNoSuchXMLObjectException, TIteratorException {
		return (Element)xmlObjectIterator.next().getElement();
	}
	
	// The wrapped TXMLObjectIterator instance
	private TXMLObjectIterator xmlObjectIterator = null;
	
}
