/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


package com.softwareag.tamino.db.api.examples.message;

import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;


/**
 ** ElementDefaultHandler extends the TSAXElementDefaultHandler class. It does its work
 ** by delegating the events to a MessageDefaultHandler.
 **/

public class ElementDefaultHandler extends TSAXElementDefaultHandler {
	
	/**
	 ** Initializes the ElementDefaultHandler with the MessageDefaultHandler.
	 **/
	public ElementDefaultHandler(MessageDefaultHandler messageDefaultHandler) {
		this.messageDefaultHandler = messageDefaultHandler;
	}
	
	
	/**
	 ** Returns the first TSAXElement instance representing the first member of the query result
	 ** set. Each class extending TSAXElementDefaultHandler may choose to implement this method
	 ** or not. An implementation is required if the getFirstXMLObject method of the TResponse
	 ** instance build for the query in question is to return meaningful information. The instance
	 ** returned by this method is the instance returned by the getFirstXMLObject method of TResponse.
	 ** Normally, an implementation of this method is closely related to an implementation of the
	 ** getElementIterator method.
	 **
	 **
	 ** @return TSAXElement instance if one is given, null otherwise.
	 **/
	public TSAXElement getFirstElement() {
		return messageDefaultHandler.getFirstMessage();
	}
	
	/**
	 ** Returns an iterator to iterate over the members of the query result set.
	 ** Each class extending TSAXElementDefaultHandler may choose to implement this method
	 ** or not. An implementation is required if the getXMLObjectIterator method of the TResponse
	 ** instance build for the query in question is to return meaningful information. The instance
	 ** returned by this method corresponds to the instance returned by the getXMLObjectIterator
	 ** method of TResponse.
	 ** Normally, an implementation of this method is closely related to an implementation of the
	 ** getFirstElement method.
	 **
	 ** @return java.util.Iterator if one is given, null otherwise.
	 **/
	public Iterator getElementIterator() {
		return messageDefaultHandler.getMessageIterator();
	}
	
	/**
	 **	Receive notification of the beginning of an element.
	 **
	 **	@param      uri         The Namespace URI, or the empty string if the element has no Namespace URI or if Namespace processing is not being performed.
	 **	@param      localName   The local name (without prefix), or the empty string if Namespace processing is not being performed.
	 **	@param      qName       The qualified name (with prefix), or the empty string if qualified names are not available.
	 **	@param      atts         The attributes attached to the element. If there are no attributes, it shall be an empty Attributes object.
	 **
	 **	@exception  SAXException  Any SAX exception, possibly wrapping another exception.
	 **/
	public void startElement(String uri,String localName,String qName,Attributes attributes) throws SAXException {
		messageDefaultHandler.startElement( uri , localName , qName , attributes );
	}
    
	/**
	 **	Receive notification of the ending of an element.
	 **
	 **	@param      uri         The Namespace URI, or the empty string if the element has no Namespace URI or if Namespace processing is not being performed.
	 **	@param      localName   The local name (without prefix), or the empty string if Namespace processing is not being performed.
	 **	@param      qName       The qualified name (with prefix), or the empty string if qualified names are not available.
	 **
	 **	@exception  SAXException  Any SAX exception, possibly wrapping another exception.
	 **/
	public void endElement (String uri, String localName, String qName) throws SAXException {
		messageDefaultHandler.endElement( uri , localName , qName );
	}
    
	/**
	 **	Receive notification of character data.
	 **
	 **	@param      ch      The characters from the XML document.
	 **	@param      start   The start position in the array.
	 **	@param      length  The number of characters to read from the array.
	 **
	 **	@exception  SAXException  Any SAX exception, possibly wrapping another exception.
	 **/
	public void characters(char ch[], int start, int length) throws SAXException {
		messageDefaultHandler.characters( ch , start , length );
	}
	
	/**
	 ** Clears the content that might currently be available thru getFirstElement and
	 ** getElementIterator.
	 **/
	public void reset() {
		messageDefaultHandler.reset();
	}
	
	// The MessageDefaultHandler which processes the sax events.
	private MessageDefaultHandler messageDefaultHandler = null;
	
}


