/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


package com.softwareag.tamino.db.api.examples.message;

import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocument;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocumentDefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;


/**
 ** DocumentDefaultHandler extends the TDocumentDefaultHandler class. It does its work
 ** by delegating the events to a MessageDefaultHandler.
 **/

public class DocumentDefaultHandler extends TSAXDocumentDefaultHandler {
	
	/**
	 ** Initializes the DocumentDefaultHandler with the MessageDefaultHandler.
	 **/
	public DocumentDefaultHandler(MessageDefaultHandler messageDefaultHandler) {
		this.messageDefaultHandler = messageDefaultHandler;
	}
	
	/**
	 ** Returns a TSAXDocument representing the single underlying XML document. Each
	 ** class extending TSAXDocumentDefaultHandler may choose to implement this method
	 ** or not. An implementation is required if the getDocument method of TXMLObject
	 ** instances created for the SAYX object model in question is to return meaningful
	 ** information. The instance returned by this method is the instance returned by
	 ** the getDocument method of TXMLObject.
	 **
	 ** @return a TSAXDocument instance or null.
	 **/
	public TSAXDocument getDocument() {
		return messageDefaultHandler.getFirstMessage();
	}
	
	/**
	 **	Receive notification of the beginning of an element.
	 **
	 **	@param      uri         The Namespace URI, or the empty string if the element has no Namespace URI or if Namespace processing is not being performed.
	 **	@param      localName   The local name (without prefix), or the empty string if Namespace processing is not being performed.
	 **	@param      qName       The qualified name (with prefix), or the empty string if qualified names are not available.
	 **	@param      atts         The attributes attached to the element. If there are no attributes, it shall be an empty Attributes object.
	 **
	 **	@exception  SAXException  Any SAX exception, possibly wrapping another exception.
	 **/
	public void startElement(String uri,String localName,String qName,Attributes attributes) throws SAXException {
		messageDefaultHandler.startElement( uri , localName , qName , attributes );
	}
    
	/**
	 **	Receive notification of the ending of an element.
	 **
	 **	@param      uri         The Namespace URI, or the empty string if the element has no Namespace URI or if Namespace processing is not being performed.
	 **	@param      localName   The local name (without prefix), or the empty string if Namespace processing is not being performed.
	 **	@param      qName       The qualified name (with prefix), or the empty string if qualified names are not available.
	 **
	 **	@exception  SAXException  Any SAX exception, possibly wrapping another exception.
	 **/
	public void endElement (String uri, String localName, String qName) throws SAXException {
		messageDefaultHandler.endElement( uri , localName , qName );
	}
    
	/**
	 **	Receive notification of character data.
	 **
	 **	@param      ch      The characters from the XML document.
	 **	@param      start   The start position in the array.
	 **	@param      length  The number of characters to read from the array.
	 **
	 **	@exception  SAXException  Any SAX exception, possibly wrapping another exception.
	 **/
	public void characters(char ch[], int start, int length) throws SAXException {
		messageDefaultHandler.characters( ch , start , length );
	}
	
	/**
	 ** Clears the document content that is currently available with getDocument.
	 **/
	public void clear() {
		messageDefaultHandler.reset();
	}
	
	// The MessageDefaultHandler which processes the sax events.
	private MessageDefaultHandler messageDefaultHandler = null;
	
}

