/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


/*
 * MusicianCollaborationResult.java
 */
package com.softwareag.tamino.db.api.examples.jazz;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TAccessFailureMessage;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionException;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMObjectModel;
import com.softwareag.tamino.db.api.response.TResponse;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;


public class MusicianCollaborationResult {
	
	/** Creates new musicianCollaborationResult */
	public MusicianCollaborationResult(String databaseURI,
									   String collection) throws TConnectionException {
		// Obtain the connection factory
		TConnectionFactory connectionFactory =
		TConnectionFactory.getInstance();
		// Obtain the connection to the database
		connection = connectionFactory.newConnection( databaseURI );
		// Obtain the concrete TXMLObjectAccessor using the JDOM object model
		accessor = connection.newXMLObjectAccessor(
			TAccessLocation.newInstance( collection ) ,
			TJDOMObjectModel.getInstance() );
	}
	
	// process query
	private TResponse processQuery(String s) throws Exception {
		TQuery query = TQuery.newInstance( s );
		try {
			// Invoke the query operation
			return accessor.query( query );
		}
		catch (TQueryException queryException) {
			// Inform about the reason for the failure
			showAccessFailure(queryException);
			return null;
		}
	}
	
	// Show the reason for the access failure
	private void showAccessFailure(TAccessorException accessorException) throws Exception {
		// Obtain an access failure message telling the exact reason
		//   if Tamino request failed
		TAccessFailureMessage
		accessFailure = accessorException.getAccessFailureException();
		if ( accessFailure != null )
			throw new Exception( "Access failed:" + accessFailure );
		else
			throw new Exception(
				"Access failed:" + accessorException.getMessage() );
	}
	
	// show result
	private void show(String keyValue)  throws Exception {
		try  {
			// Build a query and process it
			TResponse response =
			processQuery( "jazzMusician[@ID"+"='" + keyValue + "']" );
			// Get first (and single) object
			if (!response.hasFirstXMLObject())
				throw new Exception("Nothing found");
			TXMLObject xmlObject = response.getFirstXMLObject();
			// Get top-level JDOM element
			Element jazzMusician = (Element) xmlObject.getElement();
			// Now get collaborations
			response = processQuery(
				"collaboration[jazzMusician"+"='" + keyValue + "']" );
			// Iterate over result documents
			TXMLObjectIterator collabIt = response.getXMLObjectIterator();
			while (collabIt.hasNext()) {
				xmlObject = collabIt.next();
				// Get top-level JDOM element
				Element collab = (Element) xmlObject.getElement();
				// clone to remove context
				collab = (Element) collab.clone();
				// Get a list of all direct children with name "result"
				List resultChildren = collab.getChildren("result");
				// get iterator over children
				ListIterator resultIt = resultChildren.listIterator();
				// now loop over the "result" children
				while (resultIt.hasNext()) {
					// get a single "result" child
					Element resultElement = (Element) resultIt.next();
					// get the content
					String resultID = resultElement.getText();
					// now read album records with resultID as key
					response = processQuery(
						"album[productNo"+"='" + resultID + "']" );
					// Process the album if we have one
					if (response.hasFirstXMLObject()) {
						// get first (and only) result document
						xmlObject = response.getFirstXMLObject();
						// Get top-level JDOM element
						Element album = (Element) xmlObject.getElement();
						// clone to remove context
						album = (Element) album.clone();
						// remove "tracks" elements
						album.removeChildren("track");
						// remove ino:id
						album.removeAttribute("id",INO_NAMESPACE);
						// add album to collaboration clone
						collab.addContent(album);
					}
				}
				// remove "result" elements from collaboration
				collab.removeChildren("result");
				// remove ino:id
				collab.removeAttribute("id",INO_NAMESPACE);
				// and add collab to jazzMusician
				jazzMusician.addContent(collab);
			}
			// Output with JDOM output tool
			XMLOutputter outputter = new XMLOutputter();
			outputter.output(jazzMusician, System.out);
		}
		catch (Exception e)  {
			throw e;
		}
		finally  {
			// Close the connection
			connection.close();
		}
	}
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) throws Exception  {
		MusicianCollaborationResult musicianCollaborationResult =
		new MusicianCollaborationResult( DATABASE_URI , COLLECTION );
		musicianCollaborationResult.show(args[0]);
	}
	
	// Constant for the database URI
	private final static String DATABASE_URI = "http://localhost/tamino/jazz";
	
	// Constant for the collection
	private final static String COLLECTION = "encyclopedia";
	
	// Constant for ino namespace
	private final static Namespace INO_NAMESPACE =
	Namespace.getNamespace("ino",
						   "http://namespaces.softwareag.com/tamino/response2");
	
	// The database connection
	private TConnection connection = null;
	
	// The accessor instance, here a high level TXMLObjectAccessor.
	private TXMLObjectAccessor accessor = null;
}

