/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


/*
 || Example for the Tamino API for Java.
 ||
 || Assumes that there is a Tamino database called "mydb".
 || The example simply uses the default collection ino:etc.
 || This collection should only be used for examples/test code.
 || It shouldn't generally be used for real applications.
 ||
 || The example does the following:
 ||
 || establishes a connection to the Tamino database
 || obtains an XML accessor
 || inserts a new document of <Greeting>...</Greeting> into ino:etc
 || queries for the inserted document
 || closes the connection
 */
package com.softwareag.tamino.db.api.examples.greeting;


import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.dom4j.TDOM4JObjectModel;
import com.softwareag.tamino.db.api.response.TResponse;
import java.io.StringReader;
import java.io.StringWriter;




public class XMLGreetingDOM4J {
	
	public static void main(String[] args) throws Exception {
		// Put the XML content into a StringReader
		StringReader stringReader = new StringReader( XML );
		// Instantiate the specific TDOM4JObjectModel
		TXMLObjectModel dom4jObjectModel = TDOM4JObjectModel.getInstance();
		// Do the object model registration.
		TXMLObjectModel.register( dom4jObjectModel );
		// Instantiate an empty TXMLObject instance related to the DOM4J object model.
		TXMLObject xmlObject = TXMLObject.newInstance( dom4jObjectModel );
		// Establish the DOM4J representation by reading the content from the character input stream.
		xmlObject.readFrom( stringReader );
		// Establish the Tamino connection.
		TConnection connection = TConnectionFactory.getInstance().newConnection( DATABASE_URI );
		// Obtain a TXMLObjectAccessor with a DOM4J object model.
		TXMLObjectAccessor xmlObjectAccessor = connection.newXMLObjectAccessor( TAccessLocation.newInstance( "ino:etc" ),
																			   dom4jObjectModel );
		try {
			// Invoke the insert operation.
			xmlObjectAccessor.insert( xmlObject );
			// Show the ino:id of the newly inserted document.
			System.out.println( "Insert succeeded, ino:id=" + xmlObject.getId() );
		}
		catch (TInsertException insertException) {
			// Tell about the reason for the failure.
			System.out.println( "Insert failed!" );
			if ( insertException.hasAccessFailureException() )
				System.out.println( "Insert rejected by Tamino. Reason:" + insertException.getAccessFailureException() );
			else
				System.out.println( "Insert failed due to following reason:" + insertException.getRootCause().getMessage() );
		}
		// Prepare to read the instance.
		TQuery query = TQuery.newInstance( xmlObject.getDoctype() + "[@ino:id=" + xmlObject.getId() + "]" );
		try {
			// Invoke the query operation.
			TResponse response = xmlObjectAccessor.query( query );
			if ( response.hasFirstXMLObject() ) {
				StringWriter stringWriter = new StringWriter();
				response.getFirstXMLObject().writeTo( stringWriter );
				System.out.println( "Retrieved following instance:" + stringWriter );
			}
			else
				System.out.println( "No instance found!" );
		}
		catch (TQueryException queryException) {
			// Tell about the reason for the failure.
			System.out.println( "Query failed!" );
			if ( queryException.hasAccessFailureException() )
				System.out.println( "Query rejected by Tamino. Reason:" + queryException.getAccessFailureException() );
			else
				System.out.println( "Insert failed due to following reason:" + queryException.getRootCause().getMessage() );
		}
		// OK, everything is done. Lets close the connection.
		connection.close();
	}
	
	// Constant for the database URI. Please edit to use your uri of interest.
	public final static String DATABASE_URI = "http://localhost/tamino/mydb";
	
	// Constant for the applications XML message that shall be written to the connected database.
	public final static String XML = "<Greeting by='XMLGreetingApplication'>Hello World</Greeting>";
	
}
