package net.java.amateras.uml.model;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.ConnectionBendpoint;

import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractUMLConnectionModel extends AbstractUMLModel {

	private AbstractUMLEntityModel source;

	private AbstractUMLEntityModel target;

	private List bendpoints = new ArrayList();

	public static final String P_BEND_POINT = "_bend_point";
	
	public void addBendpoint(int index, ConnectionBendpoint point) {
		bendpoints.add(index, point);
		firePropertyChange(P_BEND_POINT, null, null);
	}
	
//	public void addBendpoint(int index, Point point) {
//		if(point.x < 0){
//			point.x = 0;
//		}
//		if(point.y < 0){
//			point.y = 0;
//		}
//		bendpoints.add(index, point);
//		firePropertyChange(P_BEND_POINT, null, null);
//	}
	
	public List getBendpoints() {
		if (bendpoints == null) {
			bendpoints = new ArrayList();
		}
		return bendpoints;
	}

	public void removeBendpoint(int index) {
		bendpoints.remove(index);
		firePropertyChange(P_BEND_POINT, null, null);
	}
	
	public void removeBendpoint(ConnectionBendpoint point) {
		bendpoints.remove(point);
		firePropertyChange(P_BEND_POINT, null, null);
	}
	
	public void replaceBendpoint(int index, ConnectionBendpoint point) {
		bendpoints.set(index, point);
		firePropertyChange(P_BEND_POINT, null, null);
	}	

//	// ̃xhE|Cg̒u(xhE|Cg̈ړɎgp)
//	public void replaceBendpoint(int index, Point point) {
//		if(point.x < 0){
//			point.x = 0;
//		}
//		if(point.y < 0){
//			point.y = 0;
//		}
//		bendpoints.set(index, point);
//		firePropertyChange(P_BEND_POINT, null, null);
//	}

	// ̃RlNV̍sourceɐڑ
	public void attachSource() {
		// ̃RlNVɐڑĂꍇ͖
		if (!source.getModelSourceConnections().contains(this)) {
			source.addSourceConnection(this);
		}
	}

	// ̃RlNV̐[targetɐڑ
	public void attachTarget() {
		if (!target.getModelTargetConnections().contains(this)) {
			target.addTargetConnection(this);
		}
	}

	// ̃RlNV̍sourceO
	public void detachSource() {
		if (source != null) {
			source.removeSourceConnection(this);
		}
	}

	// ̃RlNV̐[targetO
	public void detachTarget() {
		if (target != null) {
			target.removeTargetConnection(this);
		}
	}

	public AbstractUMLEntityModel getSource() {
		return source;
	}

	public AbstractUMLEntityModel getTarget() {
		return target;
	}

	public void setSource(AbstractUMLEntityModel model) {
		source = model;
	}

	public void setTarget(AbstractUMLEntityModel model) {
		target = model;
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new ColorPropertyDescriptor(P_FOREGROUND_COLOR, UMLPlugin
						.getDefault().getResourceString("property.foreground"))
				};
	}

}
