package net.java.amateras.uml.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.java.amateras.uml.classdiagram.figure.ClassFigureFactory;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.RootModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;

public class InterfaceEditPart extends AbstractUMLEntityEditPart {

	protected List getModelChildren() {
		InterfaceModel model = (InterfaceModel) getModel();
		return FilterUtil.getFilteredChildren(model);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		if (evt.getPropertyName().equals(InterfaceModel.P_NAME)) {
			RenameUtil.rename((String) evt.getOldValue(), (String) evt
					.getNewValue(), (RootModel) getParent().getModel());
		} else if (evt.getPropertyName().equals(InterfaceModel.P_CHILDREN)) {
			refreshChildren();
		} else if (evt.getPropertyName().equals(ClassModel.P_FILTER)) {
			List list = new ArrayList(getChildren());
			for (Iterator iter = list.iterator(); iter.hasNext();) {
				EditPart element = (EditPart) iter.next();
				removeChild(element);
			}
			refreshChildren();
		}
	}

	protected IFigure createFigure() {
		InterfaceModel model = (InterfaceModel) getModel();

		UMLClassFigure figure = ClassFigureFactory.getInterfaceFigure();

		figure.setClassName(model.getName());
		figure.setStereoType(model.getStereoType());
		figure.setBackgroundColor(model.getBackgroundColor());
		figure.setForegroundColor(model.getForegroundColor());
		return figure;
	}

	protected void refreshVisuals() {
		super.refreshVisuals();

		UMLClassFigure figure = (UMLClassFigure) getFigure();
		InterfaceModel model = (InterfaceModel) getModel();

		figure.setClassName(model.getName());
		figure.setStereoType(model.getStereoType());
		figure.setBackgroundColor(model.getBackgroundColor());
		figure.setForegroundColor(model.getForegroundColor());
	}

}
