package net.java.amateras.uml.activitydiagram.editpart;

import net.java.amateras.uml.activitydiagram.model.ForkNodeModel;
import net.java.amateras.uml.activitydiagram.model.JoinNodeModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;

import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

/**
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractActivityEntityEditPart extends AbstractUMLEntityEditPart {
	
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE, new NodeEditPolicy());
	}
	
	private class NodeEditPolicy extends GraphicalNodeEditPolicy {

		protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
			AbstractUMLEntityModel model = (AbstractUMLEntityModel) getHost().getModel();
			CreateConnectionCommand command = (CreateConnectionCommand) request.getStartCommand();
			command.setTarget(model);
			return command;
		}

		protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
			AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel) request.getNewObject();
			AbstractUMLEntityModel model = (AbstractUMLEntityModel) getHost().getModel();
			CreateConnectionCommand command = new CreateConnectionCommand();
			command.setConnection(conn);
			command.setSource(model);
			request.setStartCommand(command);
			return command;
		}

		protected Command getReconnectTargetCommand(ReconnectRequest request) {
			AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel) request.getConnectionEditPart().getModel();
			AbstractUMLEntityModel model = (AbstractUMLEntityModel) getHost().getModel();
			ReconnectTargetCommand command = new ReconnectTargetCommand();
			command.setConnection(conn);
			command.setTarget(model);
			return command;
		}

		protected Command getReconnectSourceCommand(ReconnectRequest request) {
			AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel) request.getConnectionEditPart().getModel();
			AbstractUMLEntityModel model = (AbstractUMLEntityModel) getHost().getModel();
			ReconnectSourceCommand command = new ReconnectSourceCommand();
			command.setConnection(conn);
			command.setSource(model);
			return command;
		}
	}
	
	private static boolean check(AbstractUMLEntityModel source, AbstractUMLEntityModel target){
		if(source == null || target == null || source == target){
			return false;
		}
		if(target instanceof ForkNodeModel){
			if(target.getModelTargetConnections().size() > 0){
				return false;
			}
		}
		if(source instanceof JoinNodeModel){
			if(source.getModelSourceConnections().size() > 0){
				return false;
			}
		}
		return true;
	}

	/** RlNV̍쐬R}h */
	private class CreateConnectionCommand extends Command {

		private AbstractUMLEntityModel source;

		private AbstractUMLEntityModel target;

		private AbstractUMLConnectionModel connection;

		public AbstractUMLConnectionModel getConnectionModel() {
			return connection;
		}

		public boolean canExecute() {
			return check(source, target);
		}

		public void execute() {
			connection.attachSource();
			connection.attachTarget();
		}

		public void setConnection(Object model) {
			connection = (AbstractUMLConnectionModel) model;
		}

		public void setSource(Object model) {
			source = (AbstractUMLEntityModel) model;
			connection.setSource(source);
		}

		public void setTarget(Object model) {
			target = (AbstractUMLEntityModel) model;
			connection.setTarget(target);
		}

		public void undo() {
			connection.detachSource();
			connection.detachTarget();
		}
	}

	/** RlNṼ^[QbgĐڑR}h */
	private class ReconnectTargetCommand extends Command {

		private AbstractUMLEntityModel target;

		private AbstractUMLEntityModel oldTarget;

		private AbstractUMLConnectionModel connection;

		public void execute() {
			connection.detachTarget();
			connection.setTarget(target);
			connection.attachTarget();
		}

		public void setConnection(Object model) {
			connection = (AbstractUMLConnectionModel) model;
			oldTarget = connection.getTarget();
		}

		public void setTarget(Object model) {
			target = (AbstractUMLEntityModel) model;
		}

		public boolean canExecute() {
			return check(connection.getSource(), target);
		}

		public void undo() {
			connection.detachTarget();
			connection.setTarget(oldTarget);
			connection.attachTarget();
		}
	}

	/** RlNṼ\[XĐڑR}h */
	private class ReconnectSourceCommand extends Command {

		private AbstractUMLEntityModel source;

		private AbstractUMLEntityModel oldSource;

		private AbstractUMLConnectionModel connection;

		public void execute() {
			connection.detachSource();
			connection.setSource(source);
			connection.attachSource();
		}

		public void setConnection(Object model) {
			connection = (AbstractUMLConnectionModel) model;
			oldSource = connection.getSource();
		}

		public void setSource(Object model) {
			source = (AbstractUMLEntityModel) model;
		}

		public boolean canExecute() {
			return check(source, connection.getTarget());
		}

		public void undo() {
			connection.detachSource();
			connection.setSource(oldSource);
			connection.attachSource();
		}
	}

}
