package net.java.amateras.uml;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UMLPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private BooleanFieldEditor booleanEditor;

	private BooleanFieldEditor antiAlias;

	private BooleanFieldEditor showGrid;

	private SpinnerFieldEditor gridSize;

	private BooleanFieldEditor snapToGeometry;

	private BooleanFieldEditor newThema;

	public UMLPreferencePage() {
		super("Amateras UML");
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		// for Diagram Layout (Grid)
		Group layoutGroup = new Group(composite, SWT.NULL);
		layoutGroup.setText(UMLPlugin.getDefault().getResourceString(
				"preference.layout"));
		layoutGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		showGrid = new BooleanFieldEditor(UMLPlugin.PREF_SHOW_GRID, UMLPlugin
				.getDefault().getResourceString("preference.layout.showGrid"),
				layoutGroup);
		gridSize = new SpinnerFieldEditor(UMLPlugin.PREF_GRID_SIZE, UMLPlugin
				.getDefault().getResourceString("preference.layout.gridSize"),
				1, 100, layoutGroup);
		snapToGeometry = new BooleanFieldEditor(UMLPlugin.PREF_SNAP_GEOMETRY,
				UMLPlugin.getDefault().getResourceString(
						"preference.layout.snapToGeometry"), layoutGroup);
		layoutGroup.setLayout(new GridLayout(3, false));

		// for Sequence Diagram
		Group sequenceGroup = new Group(composite, SWT.NULL);
		sequenceGroup.setText(UMLPlugin.getDefault().getResourceString(
				"preference.sequence"));
		sequenceGroup.setLayout(new GridLayout(1, false));
		sequenceGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		booleanEditor = new BooleanFieldEditor(UMLPlugin.PREF_CREATE_RETURN,
				UMLPlugin.getDefault().getResourceString(
						"preference.sequence.returnmessage"), sequenceGroup);

		// Graphics style.
		Group themaGroup = new Group(composite, SWT.NULL);
		themaGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		themaGroup.setText(UMLPlugin.getDefault().getResourceString(
				"preference.appearance"));

		antiAlias = new BooleanFieldEditor(UMLPlugin.PREF_ANTI_ALIAS, UMLPlugin
				.getDefault().getResourceString("preference.antialias"),
				themaGroup);
		
		newThema = new BooleanFieldEditor(UMLPlugin.PREF_NEWSTYLE, UMLPlugin
				.getDefault().getResourceString("preference.appearance.new"),
				themaGroup);

		// Initializes values
		fillInitialValues();

		return composite;
	}

	private void fillInitialValues() {
		IPreferenceStore store = UMLPlugin.getDefault().getPreferenceStore();

		booleanEditor.setPreferenceStore(store);
		booleanEditor.load();

		antiAlias.setPreferenceStore(store);
		antiAlias.load();

		showGrid.setPreferenceStore(store);
		showGrid.load();

		gridSize.setPreferenceStore(store);
		gridSize.load();

		snapToGeometry.setPreferenceStore(store);
		snapToGeometry.load();
		
		newThema.setPreferenceStore(store);
		newThema.load();
	}

	public boolean performOk() {
		booleanEditor.store();
		antiAlias.store();
		showGrid.store();
		gridSize.store();
		snapToGeometry.store();
		newThema.store();
		return true;
	}

	public void init(IWorkbench workbench) {
	}

}