#!/usr/local/bin/perl
################################################################################
#
# ȥåХåCGIץ
#
################################################################################
use lib 'lib';
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use Unicode::Japanese;
use Util;
#===============================================================================
# 
#===============================================================================
open(FILE, "diary.cgi") or die 'ɤ߹ߤ˼Ԥޤ';
while(my $line = <FILE>){
	if($line =~ /^$DATA_DIR/ || $line =~ /^$PLUGIN_DIR/){
		eval($line);
		last:
	}
}
close(FILE);

#===============================================================================
# 
#===============================================================================
my $cgi = CGI->new();
my $plugin = SNS::Plugin->new($PLUGIN_DIR,$cgi);
my $path_info  = $ENV{PATH_INFO};

if($path_info =~ m</([^/]+)$>){
	my $date = $1;
	if($date ne ''){
		#ʸȽ
		my $charset = '';
		if ($cgi->param('charset')){ #1.charsetѥ᥿Ƚ
			$charset = &decide_charset($cgi->param('charset'));
		}
		if($charset eq ''){ #2.ieѥ᥿Ƚ
			if ($cgi->param('ie')){
				$charset = &decide_charset($cgi->param('ie'));
			}
		}
		if($charset eq ''){ #3.ưȽ
			$charset = 'auto';
		}
		
		# ѥ᡼
		my $title     = Unicode::Japanese->new($cgi->param('title'), $charset)->euc();
		my $excerpt   = Unicode::Japanese->new($cgi->param('excerpt'), $charset)->euc();
		my $blog_name = Unicode::Japanese->new($cgi->param('blog_name'), $charset)->euc();
		my $url       = Unicode::Japanese->new($cgi->param('url'), $charset)->euc();
		
		if(SNS::Plugin::_trackback_filter($title, $excerpt, $blog_name, $url)){
			# ǡե˽񤭹
			my ($sec,$min,$hour,$mday,$mon,$year,$wday) = localtime(time());
			if($url =~ m<^http://|^https://>){
				open(TB, ">>$DATA_DIR/$date.tb");
				print TB qq{<a href="@{[&trim($url)]}">@{[Util::escapeHTML(&trim($title))]} - @{[Util::escapeHTML(&trim($blog_name))]}</a>\n};
				print TB time()."\n";
				print TB Util::escapeHTML(&trim($excerpt))."\n";
				close(TB);
			}
		}
		&print_response('');
		
		exit;
	}
}

&print_response('No Entry');

#===============================================================================
# 쥹ݥ
#===============================================================================
sub print_response {
	my $message = shift;
	print qq{Content-Type: text/xml;charset=EUC-JP\n\n};
	print qq{<response>};
	if($message eq ''){
		print qq{<error>0</error>};
	} else {
		print qq{<error>1</error>};
		print qq{<message>$message</message>};
	}
	print qq{</response>};
}

#===============================================================================
# ʸɷѴؿ
#===============================================================================
sub decide_charset{
	my $charset = shift;
	
	if ($charset =~ /euc-jp/i || $charset =~ /euc/i){
		return "euc";
	}
	if ($charset =~ /shift_jis/i || $charset =~ /sjis/i){
		return "sjis";
	}
	if ($charset =~ /utf-?8/i){
		return "utf8";
	}
	if ($charset =~ /iso-2022-jp/i){
		return "jis";
	}
	return "";
}

#===============================================================================
# ԥɤ
#===============================================================================
sub trim {
	my $value = shift;
	$value =~ s/[\r\n]+/ /g;
	return $value;
}

