###############################################################################
#
# 桼ƥƥ
#
###############################################################################
package Util;
#===============================================================================
# äξShift_JIS˥󥳡ɤprintޤ
#===============================================================================
sub print_encode {
	my @args = @_;
	foreach my $arg (@args){
		if(&handyphone()){
			my $unicode = Unicode::Japanese->new($arg,'euc');
			print $unicode->conv('sjis');
		} else {
			print $arg;
		}
	}
}
#===============================================================================
# ߤΥꥯȤӤ餫ɤåޤ
#===============================================================================
sub handyphone {
	my $ua = $ENV{'HTTP_USER_AGENT'};
	if(!defined($ua)){
		return 0;
	}
	if($ua=~/^DoCoMo\// || $ua=~ /^J-PHONE\// || $ua=~ /UP\.Browser/ || $ua=~ /\(DDIPOCKET\;/){
		return 1;
	} else {
		return 0;
	}
}
#===============================================================================
# ꥹȤʸ󤬴ޤޤ뤫ɤĴ٤ޤ
#===============================================================================
sub includes {
	my $text  = shift;
	my $words = shift;
	if($#{@$words}==-1){
		return 1;
	}
	foreach my $word (@$words){
		if(index($text,$word)!=-1){
			return 1;
		}
	}
	return 0;
}

#===============================================================================
# ե̾Content-Typeؿ
#===============================================================================
sub get_mime_type {
	my $file  = shift;
	my $type  = substr($file,rindex($file,"."));
	my $ctype;
	
	if   ($type eq ".gif" ){ $ctype = "image/gif"; }
	elsif($type eq ".txt" ){ $ctype = "text/plain"; }
	elsif($type eq ".html"){ $ctype = "text/html"; }
	elsif($type eq ".htm" ){ $ctype = "text/html"; }
	elsif($type eq ".css" ){ $ctype = "text/css"; }
	elsif($type eq ".jpeg"){ $ctype = "image/jpeg"; }
	elsif($type eq ".jpg" ){ $ctype = "image/jpeg"; }
	elsif($type eq ".bmp" ){ $ctype = "image/bmp"; }
	elsif($type eq ".doc" ){ $ctype = "application/msword"; }
	elsif($type eq ".xls" ){ $ctype = "application/vnd.ms-excel"; }
	else                   { $ctype = "application/octet-stream"; }
	
	$ctype;
}
#==============================================================================
# ʸΥȥԤޤ
#==============================================================================
sub trim {
	my $str = shift;
	
	$str =~ s/^(\r|\n)+//g;
	$str =~ s/(\r|\n)+$//g;
	
	return $str;
}
#==============================================================================
# HTML򥨥פޤ
#==============================================================================
sub escapeHTML {
	my $retstr = shift;
	my $brconv = shift;
	
	$retstr =~ s/&/&amp;/g;
	$retstr =~ s/\"/&quot;/g;
	$retstr =~ s/\'/&#39;/g;
	$retstr =~ s/</&lt;/g;
	$retstr =~ s/>/&gt;/g;
	
	if($brconv==1){
		$retstr =~ s/\r\n/<br>/g;
		$retstr =~ s/\r/<br>/g;
		$retstr =~ s/\n/<br>/g;
	}
	
	return $retstr;
}

#==============================================================================
# Ϥ줿ʸXMLΥƥƥѴ֤ޤ
#==============================================================================
sub escapeXML {
	my ($str) = @_;
	my %table = (
		'&' => '&amp;',
		'<' => '&lt;',
		'>' => '&gt;',
		"'" => '&apos;',
		'"' => '&quot;',
	);
	$str =~ s/([&<>\'\"])/$table{$1}/go;
	return $str;
}

#===============================================================================
# ʸΤߤޤ
#===============================================================================
sub delete_tag {
	my $text = shift;
	$text =~ s/<(.|\s)+?>//g;
	return $text;
}

#==============================================================================
# time()ͤW3CDTFդˤ֤ޤ
#==============================================================================
sub W3CDTF {
	my ($time, $tz_str) = @_;
	my ($sec, $min, $hour, $mday, $mon, $year) = (localtime($time))[0..5];
	return sprintf('%04d-%02d-%02dT%02d:%02d:%02d%.6s',
	               $year+1900,$mon+1,$mday,$hour,$min,$sec,$tz_str);
}

#==============================================================================
# URL󥳡ɤޤ
#==============================================================================
sub url_encode {
	my $retstr = shift;
	$retstr =~ s/([^ 0-9A-Za-z])/sprintf("%%%.2X", ord($1))/eg;
	$retstr =~ tr/ /+/;
	return $retstr;
}

#==============================================================================
# URLǥɤޤ
#==============================================================================
sub url_decode{
	my $retstr = shift;
	$retstr =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;
	return $retstr;
}
#==============================================================================
# դMM/DD HH:MM˥եޥåȤޤ
#==============================================================================
sub format_short_date {
	my $date = shift;
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($date);
	
	#$year = $year + 1900;
	$mon  = $mon  + 1;
	
	return sprintf("%02d/%02d %02d:%02d",$mon,$mday,$hour,$min);
}
#==============================================================================
# إåɽ
#==============================================================================
sub print_header {
	my $title   = shift;
	my $theme   = shift;
	my $css     = shift;
	my $rssfile = shift;
	
	if(handyphone()){
		print_encode("<html><head><title>",&Util::escapeHTML($title),"</title></head>\n");
		print_encode("<body><h1>".&Util::escapeHTML($title)."</h1><hr>\n");
	} else {
		print "<html>\n";
		print "<head>\n";
		print "<title>",&Util::escapeHTML($title),"</title>\n";
		print "<link rel=\"stylesheet\" type=\"text/css\" href=\"$theme\">\n";
		print "<style type=\"text/css\">\n";
		print $css;
		print "</style>\n";
		print "</head>\n";
		print "<body>\n";
		
		print "<div class=\"adminmenu\">\n";
		print "  <span class=\"adminmenu\">\n";
		print "    <a href=\"diary.cgi?".time()."\">$SNS::Lang::RECENT</a>\n";
		print "  </span>\n";
		if($rssfile ne "" && -e $rssfile){
			print "  <span class=\"adminmenu\">\n";
			print "    <a href=\"$rssfile\">RSS</a>\n";
			print "  </span>\n";
		}
		if($main::LOGIN==1){
			my ($n_sec, $n_min, $n_hour, $n_mday, $n_mon, $n_year) = localtime(time());
			$n_year += 1900;
			$n_mon  += 1;
			print "  <span class=\"adminmenu\">\n";
			print "    <a href=\"diary.cgi?do_edit=1&Year=$n_year&Month=$n_mon&Day=$n_mday\">$SNS::Lang::WRITE</a>\n";
			print "  </span>\n";
			print "  <span class=\"adminmenu\">\n";
			print "    <a href=\"diary.cgi?do_config=1\">$SNS::Lang::CONFIG</a>\n";
			print "  </span>\n";
		}
		print "</div>\n";
		print "<h1>".&Util::escapeHTML($title)."</h1>\n";
	}
}
#==============================================================================
# եåɽ
#==============================================================================
sub print_footer {
	if(handyphone()){
		print_encode("<hr><center>\n");
		my $diary = @SNS::Plugin::list[0];
		my $now   = sprintf("%04d%02d%02d",$diary->year,$diary->month,$diary->day);
		# եΰ
		my @list  = ();
		my @files = glob($main::DATA_DIR."/*.dat");
		@files = sort {$a cmp $b} @files;
		foreach my $file (@files){
			if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
				push(@list,sprintf("%04d%02d%02d",$1,$2,$3));;
			}
		}
		# ȼ뤫Ĵ٤
		my $prev = "";
		my $next = "";
		foreach my $date (@list){
			if($date < $now){
				if($prev eq "" || $prev < $date){
					$prev = $date;
				}
			} elsif($date > $now){
				$next = $date;
				last;
			}
		}
		if($prev ne ""){
			if($prev =~ /^([0-9]{4})([0-9]{2})([0-9]{2})$/){
				$prev = sprintf("%04d-%02d-%02d",$1,$2,$3);
				print_encode("<a href=\"diary.cgi?Date=$prev\">&lt;$SNS::Lang::PREV_DAY</a> ");
			}
		}
		if($next ne ""){
			if($next =~ /^([0-9]{4})([0-9]{2})([0-9]{2})$/){
				$next = sprintf("%04d-%02d-%02d",$1,$2,$3);
				print_encode("<a href=\"diary.cgi?Date=$next\">$SNS::Lang::NEXT_DAY&gt;</a>");
			}
		}
		if($prev ne "" || $next ne ""){
			print "<br>";
		}
		print_encode("Powered by sns</center></body></html>\n");
	} else {
		print "<div class=\"footer\">\n";
		print "  Powered by <a href=\"$SNS::URL\">$SNS::Lang::SNS $SNS::VERSION</a>";
		print "</div>\n";
		print "</body>\n";
		print "</html>\n";
	}
}
#==============================================================================
# ƥȤɤ߹
#==============================================================================
sub load_text {
	my $file = shift;
	
	open(DATA,$file) or return "";
	my $content = join("",<DATA>);
	close(DATA);
	
	return $content;
}
#==============================================================================
# ƥȤ¸
#==============================================================================
sub save_text {
	my $file    = shift;
	my $content = shift;
	
	open(DATA,">$file") or die "$file¸˼Ԥޤ";
	print DATA $content;
	close(DATA);
}
#==============================================================================
# ɤ߹ߡϥåե󥹤֤
#==============================================================================
sub load_config {
	my $file = shift;
	open(CONFIG,$file);
	my $config = {};
	while(my $line = <CONFIG>){
		chomp($line);
		my ($key,$value) = split(/=/,$line);
		
		$config->{$key} = $value;
	}
	close(CONFIG);
	
	return $config;
}
#==============================================================================
# ¸
#==============================================================================
sub save_config {
	my $file   = shift;
	my $config = shift;
	open(CONFIG,">$file");
	foreach my $key (keys(%$config)){
		print CONFIG "$key=".$config->{$key}."\n";
	}
	close(CONFIG);
}
#==============================================================================
# ƥȥե
#==============================================================================
sub textfield {
	my $name  = shift;
	my $size  = shift;
	my $value = shift;
	
	return "<input type=\"text\" name=\"".&escapeHTML($name)."\" size=\"$size\" value=\"".&escapeHTML($value)."\">";
}
#==============================================================================
# åܥå
#==============================================================================
sub checkbox {
	my $name     = shift;
	my $value    = shift;
	my $checked  = shift;
	my $label    = shift;
	
	my $buf = "<input type=\"checkbox\" name=\"".&escapeHTML($name)."\" value=\"".&escapeHTML($value)."\"";
	$buf.= " id=\"".&escapeHTML($name)."_".&escapeHTML($value)."\"";
	if($checked==1 || $checked eq "true"){
		$buf .= " checked";
	}
	$buf .= "> ";
	$buf .= "<label for=\"".&escapeHTML($name)."_".&escapeHTML($value)."\">".&escapeHTML($label)."</label>";

	return $buf;
}
#==============================================================================
# ƥȥꥢ
#==============================================================================
sub textarea {
	my $name     = shift;
	my $cols     = shift;
	my $rows     = shift;
	my $value    = shift;
	
	return "<textarea name=\"".&escapeHTML($name)."\" cols=\"$cols\" rows=\"$rows\">".&escapeHTML($value)."</textarea>\n";
}
#==============================================================================
# ܥܥå
#==============================================================================
sub combobox {
	my $name     = shift;
	my $items    = shift;
	my $selected = shift;
	
	my $buf = "<select name=\"".&Util::escapeHTML($name)."\">\n";
	foreach my $item (@$items){
		$buf .= "  <option value=\"".&Util::escapeHTML($item->{VALUE})."\"";
		if($item->{VALUE} eq $selected){
			$buf .= " selected";
		}
		$buf .= ">".&Util::escapeHTML($item->{LABEL})."</option>\n";
	}
	$buf .= "</select>\n";
	return $buf;
}

1;
