package SNS::FSWiki;
use strict;
###############################################################################
#
# FSWikiȤϢѤδؿ󶡤ޤ
#
###############################################################################
#==============================================================================
# åѤѿ
$SNS::FSWiki::EXCLUDES = undef;
$SNS::FSWiki::CACHE_REGEXP = '';
$SNS::FSWiki::CACHE_EXISTS = {};
$SNS::FSWiki::INTERWIKI = undef;
$SNS::FSWiki::KEYWORD = undef;
#==============================================================================
# FSWikiΥڡ̾˥ޥåɽֵѤޤ
# ˤFSWikiΥǡǥ쥯ȥꤷޤ
#==============================================================================
sub get_fswiki_pages {
	my $dir = shift;
	if($SNS::FSWiki::CACHE_REGEXP ne ''){
		return $SNS::FSWiki::CACHE_REGEXP;
	}
	unless(defined($SNS::FSWiki::EXCLUDES)){
		my @excludes = split(/\r\n/, $SNS::WikiParser::EXCLUDES);
		$SNS::FSWiki::EXCLUDES = \@excludes;
	}
	my $regexp = "";
	if($dir ne ""){
		my @pages = ();
		opendir(DIR, $dir);
		foreach my $file (readdir(DIR)){
			if($file =~ /\.wiki$/){
				$file =~ s/\.wiki$//;
				my $page = Util::url_decode($file);
				foreach (@$SNS::FSWiki::EXCLUDES){
					if($page eq $_){
						$page = '';
						last;
					}
				}
				push(@pages, $page) if($page ne '');
			}
		}
		closedir(DIR);
		
		# Ĺޥåˤʤ褦˥
		@pages = sort { length($b) <=> length($a); } @pages;
		
		foreach my $page (@pages){
			$regexp .= '|' if($regexp ne '');
			$regexp .= quotemeta($page);
		}
	}
	$SNS::FSWIKI::CACHE_REGEXP = $regexp;
	return $regexp;
}
#==============================================================================
# FSWikiΥɾޤ
# ˤFSWikiΥǡǥ쥯ȥꤷޤ
#==============================================================================
sub get_fswiki_keywords {
	my $dir    = shift;
	my $parser = shift;
	if(defined($SNS::FSWiki::KEYWORD)){
		return $SNS::FSWiki::KEYWORD;
	}
	my @keywords = ();
	
	if(-e "$dir/Keyword.wiki"){
		open(FILE, "$dir/Keyword.wiki");
		while(my $line = <FILE>){
			# ̾
			if($line =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/
			|| $line =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
			|| $line =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/){
			
				my $label = $1;
				my $url   = $2;
				push @keywords, {LABEL=>$label, URL=>$url};

			# InterWiki
			} elsif($parser->_exists_interwiki($line)){
				my $label = $parser->{INTERWIKI_LABEL};
				my $url   = $parser->{INTERWIKI_URL};
				push @keywords, {LABEL=>$label, URL=>$url};

			# ڡ̾
			} elsif($line =~ /\[\[([^\[]+?)\|(.+?)\]\]/){
				my $label = $1;
				my $page  = $2;
				push @keywords, {LABEL=>$label, PAGE=>$page};
				
			# ǤդURL
			} elsif($line =~ /\[([^\[]+?)\|(.+?)\]/){
				my $label = $1;
				my $url   = $2;
				push @keywords, {LABEL=>$label, URL=>$url};
			}
		}
		close(FILE);
	}
	
	# Ĺޥåˤʤ褦˥
	@keywords = sort { length($b->{LABEL}) <=> length($a->{LABEL}); } @keywords;
	
	$SNS::FSWiki::KEYWORD = \@keywords;
	return \@keywords;
}

#==============================================================================
# FSWikiΥڡ¸ߤ뤫ɤĴ٤ޤ
# ˤFSWikiΥǡǥ쥯ȥꤷޤ
#==============================================================================
sub exists_fswiki_page {
	my $dir = shift;
	my $name = shift;
	if($dir eq ''){
		return 1;
	}
	if(defined($SNS::FSWiki::CACHE_EXISTS->{$name})){
		return $SNS::FSWiki::CACHE_EXISTS->{$name};
	}
	my $result = (-e "$dir/@{[Util::url_encode($name)]}.wiki");
	$SNS::FSWiki::CACHE_EXISTS->{$name} = $result;
	return $result;
}

#==============================================================================
# FSWikiInterWikiNameޤ
# ˤFSWikiΥǡǥ쥯ȥꤷޤ
#==============================================================================
sub get_fswiki_interwiki {
	my $dir = shift;
	if(defined($SNS::FSWiki::INTERWIKI)){
		return $SNS::FSWiki::INTERWIKI;
	}
	my @interwiki = ();
	
	# ǥեȤǻȤ(category, diary)
	push(@interwiki, {LABEL=>'category', URL=>'diary.cgi?Search=', ENC=>'euc'});
	push(@interwiki, {LABEL=>'diary', URL=>'diary.cgi?Date=', ENC=>'euc'});
	
	if(-e "$dir/InterWikiName.wiki"){
		open(FILE, "$dir/InterWikiName.wiki");
		while(my $line = <FILE>){
			# ̾
			if($line =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[\w\.,%~^+\-%\/\?\(\)!\$&=:;\*#\@']*)\]\s*([\w\-]+)/
			    ||  $line =~ /\[([^\[]+?)\|((file:[^\[\]]*))\]\s*([\w\-]+)/
			    ||  $line =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[\w\.,%~^+\-%\/\?\(\)!\$&=:;\*#\@']*)\]\s*([\w\-]+)/){
				my $label = $1;
				my $url   = $2;
				my $enc   = $4;
				push @interwiki, {URL=>$url, LABEL=>$label, ENC=>$enc};
				
			# ʸɤλʤ
			} elsif($line =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/
			    ||  $line =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
			    ||  $line =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/){
				my $label = $1;
				my $url   = $2;
				my $enc   = "";
				push @interwiki, {URL=>$url, LABEL=>$label, ENC=>$enc};

			# ǤդURL
			} elsif($line =~ /\[([^\[]+?)\|(.+?)\]\s*([\w\-]+)/){
				my $label = $1;
				my $url   = $2;
				my $enc   = $3;
				push @interwiki, {URL=>$url, LABEL=>$label, ENC=>$enc};

			# ǤդURL(ʸɤλʤ)
			} elsif($line =~ /\[([^\[]+?)\|(.+?)\]/){
				my $label = $1;
				my $url   = $2;
				my $enc   = "";
				push @interwiki, {URL=>$url, LABEL=>$label, ENC=>$enc};

			}
		}
		close(FILE);
	}
	
	$SNS::FSWiki::INTERWIKI = \@interwiki;
	return \@interwiki;
}

1;
