###############################################################################
#
# SNS
#
###############################################################################
package SNS;
use SNS::Parser;
use SNS::TrackBack;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class    = shift;
	my $data_dir = shift;
	my $plugin   = shift;
	
	my $self = {};
	$self->{data_dir} = $data_dir;
	$self->{parser}->{HTML} = SNS::HTMLParser->new();
	$self->{parser}->{Wiki} = SNS::WikiParser->new();
	$self->{plugin} = $plugin;
	
	$SNS::Plugin::sns = $self;
	
	return bless $self,$class;
}

#==============================================================================
# SNS::Diary֥Ȥ֤ޤ
#==============================================================================
sub load_diary {
	my $self  = shift;
	my $args  = shift;
	my $year  = $args->{'year'};
	my $month = $args->{'month'};
	my $day   = $args->{'day'};
	my $rows  = $args->{'rows'};
	my $login = $args->{'login'};
	my @list;
	
	# ǯꤷƣɤ߹
	if(defined($year) && defined($month) && defined($day)){
		push(@list,$self->_load_one_day($year,$month,$day));
		
	# ǯꤷƣʬɤ߹
	} elsif(defined($year) && defined($month)){
		my @files = glob(sprintf("%s/%04d%02d*.*",$self->{data_dir},$year,$month));
		if($login){
			foreach my $file (sort {$b cmp $a} @files){
				if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.(dat|tmp)$/){
					push(@list,$self->_load_one_day($1,$2,$3));
				}
			}
		}  else {
			foreach my $file (sort {$b cmp $a} @files){
				if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
					push(@list,$self->_load_one_day($1,$2,$3));
				}
			}
		}
	# Ƕxɤ߹
	} else {
		my $count = 0;
		my @files = glob($self->{data_dir}."/*.*");
		@files = sort {$b cmp $a} @files;
		foreach my $file (@files){
			last if $count == $rows;
			if($login){
				if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.(dat|tmp)$/){
					push(@list,$self->_load_one_day($1,$2,$3));
					$count++;
				}
			} else {
				if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
					push(@list,$self->_load_one_day($1,$2,$3));
					$count++;
				}
			}
		}
	}
	
	return @list;
}

#==============================================================================
# SNS::Diary֥Ȥ֤ޤ
#==============================================================================
sub search_diary {
	my $self  = shift;
	my @words = split(/\s+/,shift);
	my @list;
	
	my @files = glob($self->{data_dir}."/*.dat");
	foreach my $file (sort {$b cmp $a} @files){
		if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
			my $year  = $1;
			my $month = $2;
			my $day   = $3;
			my $flag  = 1;
			
			open(DATA,$file) or die "$fileΥץ˼Ԥޤ";
			my $source = join("",<DATA>);
			close(DATA);
			
			# إåʬ
			$source =~ s/^@.*?\n//g;

			foreach my $word (@words){
				if(index($source,$word)==-1){
					$flag = 0;
					last;
				}
			}
			if($flag==1){
				push(@list,$self->_load_one_day($year,$month,$day));
			}
		}
	}
	return @list;
}

#==============================================================================
# ʸ򹹿ޤ
#==============================================================================
sub update_diary {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my $cgi     = shift;
	my $config  = shift;
	my $content = &Util::trim($cgi->param('Content'));
	my $style   = $cgi->param('Style');
	my $hidden  = $cgi->param('Hidden');
	
	if($style eq ""){
		$style = "HTML";
	}
	
	# ԥɤ
	$content =~ s/\r\n/\n/g;
	$content =~ s/\r/\n/g;
	
	my $tmpfile  = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"tmp");
	my $filename = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"dat");
	
	# äե
	unlink($tmpfile)  if(-e $tmpfile);
	unlink($filename) if(-e $filename);
	
	$filename = $tmpfile if($hidden);
	
	if($content ne ""){
		# ¸
		open(DATA,">$filename") or die "$filenameΥץ˼Ԥޤ";
		print DATA "\@style=$style\n";
		print DATA $content;
		close(DATA);
		# ȥåХå
		my $title = $cgi->param('tbtitle');
		my $trackback = $cgi->param('trackback');
		my $excerpt = $cgi->param('excerpt');
		if($title ne "" && $excerpt ne ""){
			$trackback =~ s/\r\n/\n/g;
			$trackback =~ s/\r/\n/g;
			foreach my $line (split(/\n/, $trackback)){
				my $sender = SNS::TrackBack->new();
				$sender->execute($cgi, $line, "$year-$month-$day", $config->{'title'}, $title, $excerpt);
			}
		}
	} else {
		# 
		unlink($filename);
		$cmtfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
		$tbfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"tb");
		unlink($cmtfile) if(-e $cmtfile);
		unlink($tbfile) if(-e $tbfile);
	}
}

#==============================================================================
# RSS򹹿ޤ
#==============================================================================
sub update_rss {
	my $self   = shift;
	my $cgi    = shift;
	my $config = shift;
	
	# RSS򹹿ʼꤢǤ10ʬ
	my @list = $self->load_diary({rows=>15});
	my $index_url = &Util::escapeXML($cgi->url(-path_info => 1));
	my $title     = &Util::escapeXML($config->{title});
	my $mod_time  = &Util::W3CDTF(time(),"+09:00");
	
	my $link_buf = "";
	my $item_buf = "";
	
	foreach my $diary (@list){
		my @sections    = $diary->parse();
		my $day_modtime = &Util::W3CDTF($diary->lastmodified(),"+09:00");
		
		foreach my $section (@sections){
			my $anchor = &Util::escapeXML(sprintf("$index_url?Date=%04d-%02d-%02d#%04d%02d%02d%02d",
			                      $diary->year,$diary->month,$diary->day,
			                      $diary->year,$diary->month,$diary->day,$section->{ID}));
			
			$link_buf .= "<rdf:li rdf:resource=\"$anchor\"/>\n";
			$item_buf .= "<item rdf:about=\"$anchor\">\n".
			             "  <title>".&Util::delete_tag($section->{TITLE})."</title>\n".
			             "  <link>$anchor</link>\n".
#			             "  <description>".&Util::escapeXML($section->{CONTENT})."</description>".
			             "  <dc:date>$day_modtime</dc:date>\n".
			             "</item>\n";
		}
	}
	
	my $rss  = "<?xml version=\"1.0\" encoding=\"EUC-JP\" standalone=\"yes\"?>\n".
	           "<rdf:RDF xmlns=\"http://purl.org/rss/1.0/\"\n".
	           "         xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n".
	           "         xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n".
	           "         xml:lang=\"ja\">\n".
	           "  <channel rdf:about=\"$index_url\">\n".
	           "    <title>$title</title>\n".
	           "    <link>$index_url</link>\n".
	           "    <dc:language>ja</dc:language>\n".
	           "    <dc:date>$mod_time</dc:date>\n".
	           "    <items>\n".
	           "      <rdf:Seq>\n".
	           "        $link_buf\n".
	           "      </rdf:Seq>\n".
	           "    </items>\n".
	           "  </channel>\n".
	           "  $item_buf\n".
	           "</rdf:RDF>\n";
	
	open(RSS,">".$config->{rssfile}) or die "RSSեι˼Ԥޤ";
	print RSS $rss;
	close(RSS);
}

#==============================================================================
# Ȥɲäޤ
#==============================================================================
sub add_comment {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my $name    = shift;
	my $comment = shift;
	my $time    = time();
	
	$name    =~ s/,//g;
	$comment =~ s/,//g;
	
	if(SNS::Plugin::_comment_filter($name, $comment)){
		my $filename = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
		
		open(DATA,">>$filename") or die "$filenameΥץ˼Ԥޤ";
		print DATA "$name,$comment,$time\n";
		close(DATA);
	}
}

#==============================================================================
# Ȥ򹹿ޤ
#==============================================================================
sub update_comment {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my $count   = shift;
	my $name    = shift;
	my $comment = shift;
	
	$name    =~ s/,//g;
	$comment =~ s/,//g;
	my $filename = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
	
	my $buf = "";
	my $i   =  0;
	
	open(DATA,"$filename") or die "$filenameΥץ˼Ԥޤ";
	while(my $line=<DATA>){
		if($i==$count){
			if($name eq "" || $comment eq ""){
				
			} else {
				my ($a,$b,$time) = split(/,/,$line);
				$buf .= "$name,$comment,$time";
			}
		} else {
			$buf .= $line;
		}
		$i++;
	}
	close(DATA);
	
	open(DATA,">$filename") or die "$filenameΥץ˼Ԥޤ";
	print DATA $buf;
	close(DATA);
}

#==============================================================================
# եźդޤ
#==============================================================================
sub attach_file {
	my $self     = shift;
	my $year     = shift;
	my $month    = shift;
	my $day      = shift;
	my $filename = shift;
	my $filecont = shift;
	
	my $savefile = sprintf("$main::ATTACH_DIR/%04d%02d%02d.%s",$year,$month,$day,&Util::url_encode($filename));
	
	if($filecont){
		open(DATA,">$savefile");
		binmode(DATA);
		print DATA $filecont;
		close(DATA);
		
	} else {
		unlink($savefile);
	}
}

#==============================================================================
# ȥåХåޤ
#==============================================================================
sub remove_trackback {
	my $self = shift;
	my $date = shift;
	my @removes = @_;
	my $count = 0;
	my $tb_count = 0;
	my $tmp = '';
	my $buf = '';
	my $tb_filename = "$main::DATA_DIR/$date.tb";
	
	open(TB, $tb_filename) or die "$tb_filenameΥץ˼Ԥޤ";
	while(my $line = <TB>){
		if($count==0){
			$tmp .= $line;
			$count = 1;
		} elsif($count==1){
			$tmp .= $line;
			$count = 2;
		} elsif($count==2){
			$tmp .= $line;
			my $flag = 0;
			foreach my $i (@removes){
				if($i == $tb_count){
					$flag = 1;
					last;
				}
			}
			if($flag==0){
				$buf .= $tmp;
			}
			$tmp = '';
			$count = 0;
			$tb_count++;
		}
	}
	close(TB);
	
	open(TB, ">$tb_filename") or die "$tb_filenameΥץ˼Ԥޤ";
	print TB $buf;
	close(TB);	
}

#==============================================================================
# Ϥޤ
#==============================================================================
sub write_log {
	my $self  = shift;
	my $nolog = shift;
	
	$nolog =~ s/\r\n/\n/g;
	$nolog =~ s/\r/\n/g;
	
	my @deny    = split(/\n/,$nolog);
	my $ip      = $ENV{"REMOTE_ADDR"};
	my $referer = $ENV{"HTTP_REFERER"};
	
	if($referer eq ""){ $referer = "-"; }
	
	foreach my $url (@deny){
		if(index($referer,$url)!=-1){
			return;
		}
	}
	
	my ($sec,$min,$hour,$mday,$mon,$year,$wday) = localtime(time());
	
	my $logfile = sprintf("%s/%04d%02d%02d.log",$self->{data_dir},$year+1900,$mon+1,$mday);
	my $date    = sprintf("%04d/%02d/%02d",$year+1900,$mon+1,$mday);
	my $week    = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
	my $time    = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
	
	open(LOG,">>$logfile");
	binmode(LOG);
	print LOG "$ip $referer $date $week $time\n";
	close(LOG);
}

#==============================================================================
# եޤ
#==============================================================================
sub get_referer {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my %referer;
	
	my $logfile = sprintf("%s/%04d%02d%02d.log",$self->{data_dir},$year,$month,$day);
	
	open(LOG,$logfile);
	while(my $line = <LOG>){
		chomp $line;
		my ($ip,$ref,$date,$week,$time) = split(/ /,$line);
		if($ref ne "-"){
			$referer{$ref}++;
		}
	}
	close(LOG);
	
	my @urls = sort {$referer{$b}<=>$referer{$a}} keys(%referer);
	my @result;
	foreach my $url (@urls){
		push(@result,{URL=>$url,COUNT=>$referer{$url}});
	}
	return @result;
}

#==============================================================================
# ʬɽ
#==============================================================================
sub print_diary {
	my $self     = shift;
	my $config   = shift;
	my $diary    = shift;
	my $detail   = shift;
	my $words    = shift;
	my $preview  = shift;
	my @sections = $diary->parse($words);
	my $date     = $diary->date;
	
	Util::print_encode("<div class=\"day\">\n");
	
	# 
	Util::print_encode("<h2><span class=\"title\">\n");
	if($config->{"datelink"} eq "true"){
		Util::print_encode("<A HREF=\"diary.cgi?Date=$date\" CLASS=\"datelink\">");
	}
	Util::print_encode($diary->year."/".$diary->month."/".$diary->day);
	if($config->{"datelink"} eq "true"){
		Util::print_encode("</A>\n");
	}
	if($diary->hidden()){
		Util::print_encode(" [$SNS::Lang::DRAFT]");
	}
	if($main::LOGIN==1 && !$preview){
		Util::print_encode(" <a href=\"diary.cgi?do_edit=1&Date=".$diary->date."\">$SNS::Lang::EDIT</a>");
	}
	
	Util::print_encode("</span></h2>\n");
	
	# ʸ
	Util::print_encode("<div class=\"body\">\n");
	foreach my $section (@sections){
		my $anchor = sprintf("%04d%02d%02d%02d",$diary->year,$diary->month,$diary->day,$section->{ID});
		Util::print_encode("<div class=\"section\"><h3>");
		Util::print_encode("<a href=\"diary.cgi?Date=$date#$anchor\">");
		Util::print_encode("<span class=\"sanchor\">".$config->{prefix}."</span>");
		Util::print_encode("</a>");
		Util::print_encode("<a name=\"$anchor\">\n");
		
		# ȥΥƥʷӤξϥ󥯤ˤʤ
		my $sec_title = $section->{TITLE};
		unless(Util::handyphone()){
			$sec_title =~ s/\[(.*?)\]/"[<a href=\"diary.cgi?Search=".&Util::url_encode("[$1]")."\">$1<\/a>]"/eg;
		}
		$self->{plugin}->process($sec_title,$diary);
		Util::print_encode("</a></h3>\n");
		$self->{plugin}->process($section->{CONTENT},$diary);
		Util::print_encode("</div>\n");
	}
	Util::print_encode("</div>\n");
	
	unless($preview){
		# 
		if($config->{comment} eq "true" && $SNS::Plugin::cgi->param("Search") eq ""){
			$self->print_comment($diary);
		}
		
		# ȥåХå(Ӥξ̵ɽʤ)
		unless(Util::handyphone()){
			if($config->{trackback} eq "true" && $SNS::Plugin::cgi->param("Search") eq ""){
				$self->print_trackback($diary);
			}
		}
		
		# ե(Ӥξ̵ɽʤ)
		unless(Util::handyphone()){
			if($config->{referer} eq "true" && $SNS::Plugin::cgi->param("Search") eq ""){
				$self->print_referer($diary,$detail);
			}
		}
	}
	
	Util::print_encode("</div>\n");
}

#==============================================================================
# եɽޤ
#==============================================================================
sub print_referer {
	my $self   = shift;
	my $diary  = shift;
	my $detail = shift;
	
	if($detail==1){
		print "<div class=\"refererlist\">\n";
		print "  <div class=\"caption\">$SNS::Lang::REFERER</div>\n";
		print "  <ul>\n";
		foreach my $ref ($self->get_referer($diary->year,$diary->month,$diary->day)){
			my $conv = $ref->{URL} =~ /UTF-8/i ? 'utf8' : 'auto';
			my $url  = Unicode::Japanese->new(&Util::url_decode($ref->{URL}),$conv);
			print "    <li><a href=\"".$ref->{URL}."\">".&Util::escapeHTML($url->conv("euc"))."</a> &times;".$ref->{COUNT}."</li>\n";
		}
		print "  </ul>\n";
		print "</div>\n";
	} else {
		my $count = 0;
		print "<div class=\"referer\">\n";
		print "$SNS::Lang::REFERER |\n";
		foreach my $ref ($self->get_referer($diary->year,$diary->month,$diary->day)){
			last if $count==20;
			print " <a href=\"".$ref->{URL}."\">".$ref->{COUNT}."</a> |\n";
			$count++;
		}
		print "</div>\n";
	}

}

#==============================================================================
# Ȥɽޤ
#==============================================================================
sub print_comment {
	my $self  = shift;
	my $diary = shift;
	my $edit  = shift;
	
	unless(Util::handyphone()){
		print "<div class=\"comment\">\n";
		print "<div class=\"caption\">$SNS::Lang::COMMENT</div>\n";
		print "<div class=\"commentshort\">\n";
	} else {
		Util::print_encode("<div>$SNS::Lang::COMMENT</div>\n");
	}
	if($edit==1){
		my $count = 0;
		print "<form action=\"diary.cgi\" method=\"POST\">\n";
		foreach $comment (@{$diary->comment}){
			print &Util::textfield("Name$count"   ,10,$comment->{NAME});
			print &Util::textfield("Comment$count",60,$comment->{COMMENT});
			print "<br>\n";
			$count++;
		}
		print "  <input type=\"submit\" name=\"modify_comment\" value=\"$SNS::Lang::CHANGE\">\n";
		print "  <input type=\"reset\" value=\"$SNS::Lang::RESET\">\n";
		print "  <input type=\"hidden\" name=\"CommentCount\"  value=\"$count\">\n";
		print "  <input type=\"hidden\" name=\"Date\"  value=\"".$diary->date."\">\n";
		print "</form>\n";
		
	} else {
		foreach $comment (@{$diary->comment}){
			unless(Util::handyphone()){
				print "<p>\n".
					"  <span class=\"commentator\">".&Util::escapeHTML($comment->{NAME})."</span> ".
					"  ".&Util::escapeHTML($comment->{COMMENT})." ".
					"  (".&Util::format_short_date($comment->{TIME}).")\n".
					"</p>\n";
			} else {
				Util::print_encode("".&Util::escapeHTML($comment->{NAME}).
								   "  ".&Util::escapeHTML($comment->{COMMENT})." ".
								   "  (".&Util::format_short_date($comment->{TIME}).")\n".
								   "<br>\n");
			}
		}
	}
	Util::print_encode("</div>\n");
	
	if($edit != 1){
		Util::print_encode("<form action=\"diary.cgi\" method=\"POST\">\n");
		Util::print_encode("  $SNS::Lang::NAME<input type=\"text\" name=\"Name\" size=\"10\" value=\"".
						   &Util::escapeHTML($main::COMMENT_NAME)."\">\n");
		Util::print_encode("  $SNS::Lang::COMMENT<input type=\"text\" name=\"Comment\" size=\"40\">\n");
		Util::print_encode("  <input type=\"submit\" name=\"post_comment\" value=\"$SNS::Lang::COMMENT\">\n");
		Util::print_encode("  <input type=\"hidden\" name=\"Date\"  value=\"".$diary->date."\">\n");
		Util::print_encode("</form>\n");
	}
	
	Util::print_encode("</div>\n");
}

#==============================================================================
# ȥåХåɽޤ
#==============================================================================
sub print_trackback {
	my $self  = shift;
	my $diary = shift;
	my $edit  = shift;

	my $url = $SNS::Plugin::cgi->url();
	$url =~ s|/[^/]*?$||;
	
	Util::print_encode(qq{
	<div class="comment">
	  <div class="caption">
	    <a name="tb">$SNS::Lang::TRACKBACK</a> - 
	    $url/tb.cgi/@{[sprintf("%04d%02d%02d",$diary->year,$diary->month,$diary->day)]}
	  </div>
	});
	
	if($edit==1){
		Util::print_encode("<form action=\"diary.cgi\" method=\"POST\">\n");
	}
	Util::print_encode("<div class=\"commentshort\">\n");
	my $count = 0;
	foreach my $trackback (@{$diary->trackback()}){
		Util::print_encode("<div class=\"commentator\">\n");
		Util::print_encode("<span class=\"commentator\">\n");
		if($edit==1){
			Util::print_encode("<input type=\"checkbox\" name=\"RemoveTrackBack\" value=\"$count\">");
		}
		Util::print_encode($trackback->{head});
		Util::print_encode("(".&Util::format_short_date($trackback->{date}).")");
		Util::print_encode("</span>\n");
		Util::print_encode("</div>\n");
		Util::print_encode("<p>".$trackback->{excerpt}."</p>\n");
		$count++;
	}
	if($edit==1){
		Util::print_encode("<input type=\"submit\" name=\"modify_trackback\" value=\"$SNS::Lang::DELETE\">\n");
		Util::print_encode("<input type=\"reset\" value=\"$SNS::Lang::RESET\">\n");
		Util::print_encode("<input type=\"hidden\" name=\"Date\"  value=\"".$diary->date."\">\n");
	}
	Util::print_encode("</div>\n");
	Util::print_encode("</div>\n");
	
	if($edit==1){
		Util::print_encode("</form>\n");
	}
}

#==============================================================================
# ϥեɽޤ
#==============================================================================
sub print_form {
	my $self    = shift;
	my $diary   = shift;
	my $config  = shift;
	my $preview = shift;
	
	if($diary->content eq ""){
		$diary->style($config->{format});
	}
	
	print "<div class=\"day\">\n";
	print "<form action=\"diary.cgi\" method=\"POST\">\n";
	print "<h2>";
	print "<input type=\"text\" name=\"Year\"  size=\"4\" value=\"".$diary->year."\">/";
	print "<input type=\"text\" name=\"Month\" size=\"2\" value=\"".$diary->month."\">/";
	print "<input type=\"text\" name=\"Day\"   size=\"2\" value=\"".$diary->day."\">";
	print "</h2>\n";
	
	print "<div class=\"body\">\n";
	print "  <textarea name=\"Content\" cols=\"80\" rows=\"20\">".&Util::escapeHTML($diary->content)."</textarea>\n";
	print "  <br>\n";
	
	print "  $SNS::Lang::STYLE ".&Util::combobox("Style",[{VALUE=>'HTML',LABEL=>'HTML'},
												{VALUE=>'Wiki',LABEL=>'Wiki'}],$diary->style)."\n";
	print &Util::checkbox('Hidden', '1', $diary->hidden(), $SNS::Lang::DRAFT);
	print "  <input type=\"submit\" name=\"do_save\" value=\"$SNS::Lang::SAVE\">\n";
	print "  <input type=\"submit\" name=\"do_preview\" value=\"$SNS::Lang::PREVIEW\">\n";
	
	if($config->{trackback} eq "true"){
		print qq|
			<script language="JavaScript">
			function displayTrackBackForm(){
				var obj = document.getElementById('trackback');
				if(obj.style.display == 'none'){
					obj.style.display = '';
					document.getElementById('display_tb').innerHTML = '$SNS::Lang::HIDE_TRACKBACK';
				} else {
					obj.style.display = 'none';
					document.getElementById('display_tb').innerHTML = '$SNS::Lang::DISPLAY_TRACKBACK';
				}
			}
			</script>
		|;
		my $date = sprintf("%04d/%02d/%02d", $diary->year, $diary->month, $diary->day);
		print "<a id=\"display_tb\" href=\"javascript:displayTrackBackForm();\">$SNS::Lang::DISPLAY_TRACKBACK</a>";
		print "<div id=\"trackback\" style=\"display: none\"><br>\n";
		print "$SNS::Lang::TB_TITLE<br>\n";
		print "<input type=\"text\" name=\"tbtitle\" size=\"60\" value=\"$date\"><br>\n";
		print "$SNS::Lang::TB_URL<br>\n";
		print "<textarea name=\"trackback\" rows=\"2\" cols=\"80\"></textarea><br>\n";
		print "$SNS::Lang::TB_EXCERPT<br>\n";
		print "<textarea name=\"excerpt\" rows=\"2\" cols=\"80\"></textarea><br>\n";
		print "</div>\n";
	}
	
	print "</form>\n";
	print "</div>\n";
	
	print "<div class=\"comment\">\n";
	print "  <div class=\"caption\">\n";
	print "    $SNS::Lang::FILE_ATTACH |\n";
	foreach my $file (@{$diary->attach}){
		my $localfile = sprintf("%04d%02d%02d.%s",$year,$month,$day,&Util::url_encode($file));
		print "<a href=\"diary.cgi?download=".&Util::url_encode($localfile)."\">".&Util::escapeHTML($file)."</a>".
		      "[<a href=\"diary.cgi?do_attach=1&Date=".$diary->date."&file=".&Util::url_encode($file)."\">$SNS::Lang::DELETE</a>] |\n";
	}
	print "  </div>\n";
	print "  <div class=\"commentshort\">\n";
	print "    <form action=\"diary.cgi\" method=\"POST\" enctype=\"multipart/form-data\">\n";
	print "      <input type=\"file\"   name=\"file\">\n";
	print "      <input type=\"submit\" name=\"do_attach\" value=\"$SNS::Lang::ATTACH\">\n";
	print "      <input type=\"hidden\" name=\"Date\" value=\"".$diary->date ."\">\n";
	print "    </form>\n";
	print "  </div>\n";
	print "</div>\n";

	if($config->{comment} eq "true"){
		$self->print_comment($diary,1);
	}
	if($config->{trackback} eq "true"){
		$self->print_trackback($diary,1);
	}
	
#	if($config->{referer} eq "true"){
		$self->print_referer($diary,1);
#	}
	print "</div>\n";
}

#==============================================================================
# ѥեɽޤ
#==============================================================================
sub print_config_form {
	my $self     = shift;
	my $config   = shift;
	my $css      = shift;
	my $header   = shift;
	my $footer   = shift;
	my $nolog    = shift;
	my $excludes = shift;
	
	print "<form action=\"diary.cgi\" method=\"POST\">\n";
	
	# ɽ˴ؤ
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\">ɽ˴ؤ</span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ǿǤɽ</h3>\n";
	print "      <p>".&Util::textfield("Once",2,$config->{once})."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ơ</h3>\n";
	print "      <p>\n";
	print "        <select name=\"Style\">\n";
	foreach my $entry (sort(glob("$main::THEME_DIR/*"))){
		if($entry =~ /\/([A-Za-z0-9_\-]+?\.css)$/){
			print "          <option value=\"$main::THEME_URI/$1\"";
			if($config->{"style"} eq "$main::THEME_URI/$1"){ print " selected"; }
			print ">$1\n";
		} elsif(-d $entry && $entry =~ /\/([A-Za-z0-9_\-]+?)$/ && -e "$entry/$1.css") {
			print "          <option value=\"$entry/$1.css\"";
			if($config->{"style"} eq "$entry/$1.css"){ print " selected"; }
			print ">$1.css\n";
		}
	}
	print "        </select>\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\"></h3>\n";
	print "      <p>\n";
	print "        ".&Util::checkbox("DateLink","true",$config->{datelink},"󥫤Ϳ")."\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">Υץեå</h3>\n";
	print "      <p>\n";
	print "        ".&Util::textfield("Prefix",20,$config->{prefix})."\n";
	print "        ˤХ󥫤ϽϤޤ\n";
	print "      </p>\n";
	print "    </div>\n";

	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\"> / ȥåХå</h3>\n";
	print "      <p>\n";
	print "        ".&Util::checkbox("Comment","true",$config->{comment},"ȵǽѤ")."\n";
	print "        ".&Util::checkbox("RequireName","true",$config->{require_name},"̾ʤΥȤϵ")."\n";
	print "        ".&Util::checkbox("TrackBack","true",$config->{trackback},"ȥåХåǽѤ")."\n";
	print "      </p>\n";
	print "    </div>\n";
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ɸΥ</h3>\n";
	print "      <p>\n";
	print "        ".&Util::combobox("Format",[{VALUE=>'HTML',LABEL=>'HTML'},{VALUE=>'Wiki',LABEL=>'Wiki'}],$config->{format})."\n";
	print "      </p>\n";
	print "    </div>\n";

	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">RSS</h3>\n";
	print "      <p>\n";
	print "        ".&Util::textfield("RSSFile",20,$config->{rssfile})."\n";
	print "        ˤRSSեޤ\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "  </div>\n";
	print "</div>\n";
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	# إåեå˴ؤ
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\">إåեå˴ؤ</span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">Υȥ</h3>\n";
	print "      <p>".&Util::textfield("Title",40,$config->{title})."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\"><h3 class=\"subtitle\">륷</h3>\n";
	print "      <p>".&Util::textarea("CSS",60,10,$css)."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\"><h3 class=\"subtitle\">إå</h3>\n";
	print "      <p>".&Util::textarea("Header",60,10,$header)."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\"><h3 class=\"subtitle\">եå</h3>\n";
	print "      <p>".&Util::textarea("Footer",60,10,$footer)."</p>\n";
	print "    </div>\n";
	
	print "  </div>\n";
	print "</div>\n";
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	
	# 
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\"></span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ե</h3>\n";
	print "      <p>".&Util::checkbox("Referer","true",$config->{referer},"ɽ̤˥եɽ")."</p>\n";
	print "      <h3 class=\"subtitle\">URLʣԤˣĤġ</h3>\n";
	print "      <p>".&Util::textarea("NoLog",60,10,$nolog)."</p>\n";
	print "    </div>\n";
	
	print "  </div>\n";
	print "</div>\n";
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	# WikiϢȤ˴ؤ
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\">WikiϢȤ˴ؤ</span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">󥯤</h3>\n";
	print "      <ul>";
	print "<li>", Util::checkbox("WikiPage","1",$config->{wiki_page},"ڡ̾μư"), "<br>\n";
	print "ڡ̾1Ԥ1Ĥĥڡ̾ϤƤ<br>\n";
	print Util::textarea("WikiPageExcludes",60,4,$excludes), "</li>\n";
	print "<li>", Util::checkbox("WikiKeyword","1",$config->{wiki_keyword},""), "</li>\n";
	print "<li>", Util::checkbox("WikiInterWiki","1",$config->{wiki_interwiki},"InterWikiName"), "</li>\n";
	print "      </ul>";
	print "    </div>\n";
	
	print "  </div>\n";
	
	print "</div>\n";
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	print "</form>\n";
}

#==============================================================================
# ե̾ޤ
#==============================================================================
sub _make_filename {
	my $self  = shift;
	my $year  = shift;
	my $month = shift;
	my $day   = shift;
	my $ext   = shift;
	
	return sprintf("%04d%02d%02d.%s",$year,$month,$day,$ext);
}

#==============================================================================
# YYYYMMDDʸǯʬ䤷ޤ
#==============================================================================
sub _split_date {
	my $self = shift;
	my $file = shift;
	
	my $year  = int(substr($file,0,4));
	my $month = int(substr($file,4,2));
	my $day   = int(substr($file,6,2));
	
	return ($year,$month,$day);
}

#==============================================================================
# ʬɤ߹ߡSNS::Diary֥Ȥ֤ޤ
#==============================================================================
sub _load_one_day {
	my $self   = shift;
	my $year   = shift;
	my $month  = shift;
	my $day    = shift;
	
	# ǯ
	my $diary = SNS::Diary->new();
	$diary->year($year);
	$diary->month($month);
	$diary->day($day);
	
	# ʸɤ߹
	my $buf = "";
	my $datfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"dat");
	unless(-e $datfile){
		$datfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"tmp");
	}
	if(-e $datfile){
		open(DATA,$datfile) or die "$datfileΥץ˼Ԥޤ";
		while(my $line = <DATA>){
			# ԥɤ
			$line =~ s/\r\n/\n/g;
			$line =~ s/\r/\n/g;
			# 
			if($line =~ /^\@style=(.+)\n/){
				$diary->parser($self->{parser}->{$1});
				$diary->style($1);
				next;
			}
			$buf .= $line;
		}
		close(DATA);
		$diary->hidden($datfile =~ /\.tmp$/);
		$diary->content($buf);
	}
	
	# μ
	my @status = stat($datfile);
	$diary->lastmodified($status[9]);
	
	unless(defined($diary->parser)){
		$diary->parser($self->{parser}->{HTML});
		$diary->style('HTML');
	}
	
	# Ȥɤ߹
	my $cmtfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
	if(-e $cmtfile){
		open(DATA,$cmtfile) or die "$cmtfileΥץ˼Ԥޤ";
		my $count  = 0;
		my $cmtbuf = [];
		while(my $line = <DATA>){
			chomp $line;
			my ($name,$comment,$time) = split(/,/,$line);
			push(@$cmtbuf,{ID=>$count,NAME=>$name,COMMENT=>$comment,TIME=>$time});
			$count++;
		}
		close(DATA);
		$diary->comment($cmtbuf);
	}
	
	# źեեɤ߹
	my $attach = [];
	foreach my $entry (glob(sprintf("$main::ATTACH_DIR/%04d%02d%02d.*",$year,$month,$day))){
		my ($hoge,$file) = split(/[0-9]{4}[0-9]{2}[0-9]{2}\./,$entry);
		push (@$attach,&Util::url_decode($file));
	}
	$diary->attach($attach);
	
	# ȥåХåɤ߹
	my $tbfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"tb");
	if(-e $tbfile){
		open(DATA, $tbfile) or die "$tbfileΥץ˼Ԥޤ";
		my $count = 0;
		my $trackback = [];
		my $head;
		my $date;
		while(my $line = <DATA>){
			if($count==0){
				$count = 1;
				$head = $line;
			} elsif($count==1){
				$count = 2;
				$date = $line;
			} else {
				push(@$trackback, {head=>$head, date=>$date, excerpt=>$line});
				$count = 0;
			}
		}
		close(DATA);
		
		$diary->trackback($trackback);
	}
	
	return $diary;
}

###############################################################################
#
# SNS::Diary
#
###############################################################################
package SNS::Diary;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	$self->{comment}   = [];
	$self->{trackback} = [];
	$self->{attach}    = [];
	return bless $self,$class;
}

#==============================================================================
# Ƥ뤫ɤ⤷ꤷޤ
#==============================================================================
sub hidden {
	my $self = shift;
	my $visible = shift;
	if(defined($visible)){
		$self->{visible} = $visible;
	} else {
		return $self->{visible};
	}
}

#==============================================================================
# ǯ⤷ꤷޤ
#==============================================================================
sub year {
	my $self = shift;
	my $year = shift;
	if(defined($year)){
		$self->{year} = $year;
	} else {
		return $self->{year};
	}
}

#==============================================================================
# ⤷ꤷޤ
#==============================================================================
sub month {
	my $self  = shift;
	my $month = shift;
	if(defined($month)){
		$self->{month} = $month;
	} else {
		return $self->{month};
	}
}

#==============================================================================
# ⤷ꤷޤ
#==============================================================================
sub day {
	my $self = shift;
	my $day  = shift;
	if(defined($day)){
		$self->{day} = $day;
	} else {
		return $self->{day};
	}
}

#==============================================================================
# YYYY-MM-DDդޤ
#==============================================================================
sub date {
	my $self = shift;
	return sprintf("%04d%02d%02d",$self->year,$self->month,$self->day);
}

#==============================================================================
# ⤷ꤷޤ
#==============================================================================
sub style {
	my $self  = shift;
	my $style = shift;
	if(defined($style)){
		$self->{style} = $style;
	} else {
		return $self->{style};
	}
}

#==============================================================================
# ѡ⤷ꤷޤ
#==============================================================================
sub parser {
	my $self   = shift;
	my $parser = shift;
	if(defined($parser)){
		$self->{parser} = $parser;
	} else {
		return $self->{parser};
	}
}

#==============================================================================
# ʸѡƥΥꥹȤ֤ޤ
#==============================================================================
sub parse {
	my $self  = shift;
	my @words = split(/\s+/,shift);

	my $parser  = $self->parser;
	$parser->init;
	
	return $parser->parse($self->content,\@words);
}

#==============================================================================
# ʸ⤷ꤷޤ
#==============================================================================
sub content {
	my $self    = shift;
	my $content = shift;
	if(defined($content)){
		$self->{content} = $content;
	} else {
		return $self->{content};
	}
}

#==============================================================================
# Ȥ⤷ꤷޤ
#==============================================================================
sub comment {
	my $self    = shift;
	my $comment = shift;
	if(defined($comment)){
		$self->{comment} = $comment;
	} else {
		return $self->{comment};
	}
}

#==============================================================================
# źեե⤷ꤷޤ
#==============================================================================
sub attach {
	my $self   = shift;
	my $attach = shift;
	if(defined($attach)){
		$self->{attach} = $attach;
	} else {
		return $self->{attach};
	}
}

#==============================================================================
# ȥåХå⤷ꤷޤ
#==============================================================================
sub trackback {
	my $self   = shift;
	my $trackback = shift;
	if(defined($trackback)){
		$self->{trackback} = $trackback;
	} else {
		return $self->{trackback};
	}
}

#==============================================================================
# ǽ⤷ꤷޤ
#==============================================================================
sub lastmodified {
	my $self     = shift;
	my $modtime  = shift;
	if(defined($modtime)){
		$self->{lastmodified} = $modtime;
	} else {
		return $self->{lastmodified};
	}
}

###############################################################################
#
# ץ饰󥯥饹
#
###############################################################################
package SNS::Plugin;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class      = shift;
	my $plugin_dir = shift;
	
	$SNS::Plugin::cgi = shift;
	
	my $self = {};
	$self->{plugin_dir} = $plugin_dir;
	$self = bless $self,$class;
	$self->_init;
	return $self;
}
#==============================================================================
# 
#==============================================================================
sub _init {
	my $self = shift;
	my @files = glob($self->{plugin_dir}."/*.pl");
	foreach my $file (@files){
		eval("require \"$file\";");
	}
}
#==============================================================================
# ץȥåȤɸϤ˽񤭽Фޤ
#==============================================================================
sub process {
	my $self   = shift;
	my $source = shift;
	my $diary  = shift;
	
	$SNS::Plugin::diary = $diary;
	
	#¹ԲǽʷѴ
	$source =~ s/\\/\\\\/g;
	$source =~ s/'/\\'/g;
	$source =~ s/<%=(.*?)%>/<%Util::print_encode ($1)%>/g;
	$source =~ s/<%/\');/g;
	$source =~ s/%>/;Util::print_encode (\'/g;
	$source = "Util::print_encode (\'$source\');\n";
	#ץȼ¹
	eval $source;
	# 顼ȯ
	print "<font class=\"alert\">".$@."</font>" if $@;
}

1;
