############################################################
#
# mttrackback1.1ߴTrackBackPingΥϥɥ顣
#
# Written by zedosho<zed_osho@yahoo.co.jp>
#
# Version 0.4 (2005.05.14)
# Version 0.33(2004.08.14)
# Version 0.32(2004.06.25)
# Version 0.31(2004.05.08)
# Version 0.3 (2004.03.25)
# Version 0.2 (2003.09.03)
#
############################################################
package SNS::TrackBack;
use strict;
use LWP::UserAgent;

my $VERSION = "0.4";
my $USER_AGENT = "FreeStyleWiki TrackBackPingPlugin $VERSION";

#顼
sub STATUS_OK {1};
sub STATUS_HTTP_ERR {2};
sub STATUS_PING_ERR {3};
sub STATUS_NO_TRACKBACK_RESPONSE {4};

#===========================================================
# 󥹥ȥ饯
#===========================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#===========================================================
# ping
#===========================================================
sub execute {
	my $self    = shift;
	my $cgi     = shift;
	my $target  = shift;
	my $date    = shift;
	my $title   = shift;
	my $entry   = shift;
	my $excerpt = shift;

	my $mode;
	my %data;					#ѥ᡼ݻϥå
	my $msg;					#åݻ
	my $res;					#HTTP쥹ݥݻ
	
	#---------------------------------
	# pingѥǡΥå
	#---------------------------------
	#μ
	$data{'ping_url'} = $target;
	#֥̾
	$data{'blog_name'} = $title;
	#ڡ̾
	$data{'title'} = $entry;
	#ڡURL
	$data{'url'} = $cgi->url().'?Date='.$date;
	#
	$data{'excerpt'} = $excerpt;
	#Pingڡ̾
	$data{'page'} = $data{'title'};
	#PINGơ
	$data{'status'} = 0;
	#顼å
	$data{'message'} = '';
	#HTTP쥹ݥ
	$data{'response'} = '';
	#ʸ
	$data{'charset'} = 'euc';
	$data{'ie'} = 'euc';

	#---------------------------------
	# 顼å
	#---------------------------------
	$res = $self->_check_parameter(\%data, 1);		#õѥ顼å
	return if $res; # 顼

	#---------------------------------
	# ping
	#---------------------------------
	$self->send_ping(\%data);

	if ($data{'status'} == STATUS_OK){
		#ϤȤΥڡإ쥯
		return;
		#$wiki->redirect($data{'page'});

	}elsif($data{'status'} == STATUS_NO_TRACKBACK_RESPONSE){
		#ȥåХåʳΥ쥹ݥ󥹤֤äƤȤϡRDFõ
		return;
		#return $self->discover_rdf($wiki, \%data, $data{'response'});

	}elsif($data{'status'} == STATUS_HTTP_ERR){
		#HTTP顼HTTP顼ɤɽ
		return die $data{'message'};
		#return $wiki->error('ERROR! ' . $data{'message'});

	}elsif($data{'status'} == STATUS_PING_ERR){
		#PING顼ϥ顼åɽ
		return die $data{'message'};
		#return $wiki->error('ERROR! ' . $data{'message'});

	}else{
		#Ȥϥå
		return die "ȥåХåʥ顼ȯޤ";
		#return $wiki->error('ERROR! ʥ顼Ǥ');
	}
}


#===========================================================
# ping
#===========================================================
sub send_ping {

	my $self = shift;
	my $ref_data = shift;		#ϥåΥե

	my %data;					#ѥ᡼ݻϥå
	my $msg;					#顼åݻ
	my $res;					#HTTP쥹ݥݻ

	#---------------------------------
	# 顼å
	#---------------------------------
	$res = $self->_check_parameter($ref_data, 0);
	return $res if($res); # 顼

	#---------------------------------
	# μ
	#---------------------------------
	$$ref_data{'excerpt'} = $self->_get_excerpt($$ref_data{'excerpt'});

	#---------------------------------
	# PING
	#---------------------------------
	$self->_send_ping($ref_data);

	return;

}

#===========================================================
# 顼å
#===========================================================
sub _check_parameter{

	my $self = shift;
	my $ref_data = shift;			#ϥåΥե
	my $mode = shift;				#顼å⡼(0:̾1:õ)

	if($$ref_data{'ping_url'} eq ''){ return 'URLϤƤޤ'; }
	if($mode == 1){return ''}	#õϤǥåλ

	if($$ref_data{'blog_name'} eq ''){ return 'wiki̾Ǥޤ'; }
	if($$ref_data{'title'} eq ''){ return 'ڡ̾Ǥޤ'; }

	return '';
}

#===========================================================
# TrackBackPing
#===========================================================
sub _send_ping {
	my $self = shift;
	my $ref_data = shift;
	my %prm;
	my ($url, $content);

	my $ua = LWP::UserAgent->new;
	push @{ $ua->requests_redirectable }, 'POST';
	$ua->agent($USER_AGENT);

	#------------------------------------------------------------------
	# pingURL?ʲΥѥ᡼դƤȤˤ
	# Υѥ᡼URLʬʬ䤹
	#------------------------------------------------------------------
	($url, $content) = &SNS::TrackBackUtil::separate_base_url_and_param($$ref_data{'ping_url'});

	#------------------------------------------------------------------
	# ʸɤѴ
	#------------------------------------------------------------------
	my $title = $$ref_data{'title'};
	my $excerpt = $$ref_data{'excerpt'};
	my $blog_name = $$ref_data{'blog_name'};
	
#	Jcode::convert( \$title, $$ref_data{'ie'});
#	Jcode::convert( \$excerpt, $$ref_data{'ie'});
#	Jcode::convert( \$blog_name, $$ref_data{'ie'});

	#------------------------------------------------------------------
	# ping
	#  &иȤʸڤƤޤΤ
	#------------------------------------------------------------------
	my $req = HTTP::Request->new(POST => $url);
	$req->content_type('application/x-www-form-urlencoded');
	$req->content(
			"title=" . &Util::url_encode($title)
		.	"&url=" . &Util::url_encode($$ref_data{'url'})
		.	"&excerpt=" . &Util::url_encode($excerpt)
		.	"&blog_name=" . &Util::url_encode($blog_name)
		.	"&charset=" . $$ref_data{'charset'}
		.	"&ie=" . $$ref_data{'ie'}
		.	"&" . $content);

	#
	my $res = $ua->request($req);

	if(!$res->is_success){
		$$ref_data{'status'} = STATUS_HTTP_ERR;
		$$ref_data{'message'} = $res->status_line;
		$$ref_data{'response'} = '';
		return;
	}

	#Υ쥹ݥ󥹤֤äƤƤ뤫ɤå
	if ($res->content =~ m!<response>.*<error>(\d+).*</error>.*</response>!s){
		#顼åäƤ⡢ơ顼̵ФΤޤޥ쥯Ȥ
		my($e, $msg) = $res->content =~ m!<error>(\d+).*<message>(.+?)</message>!s;
		if ($e){
			$$ref_data{'status'} = STATUS_PING_ERR;
			$$ref_data{'message'} = $msg;
			$$ref_data{'response'} = '';
		}else{
			$$ref_data{'status'} = STATUS_OK;
			$$ref_data{'message'} = '';
			$$ref_data{'response'} = '';
		}
	}else{
		$$ref_data{'status'} = STATUS_NO_TRACKBACK_RESPONSE;
		$$ref_data{'message'} = '۾ʥȥåХåα֤äƤޤ';
		$$ref_data{'response'} = $res->content;
	}

	return;

}

#===========================================================
# ڡʸȴФ
#===========================================================
sub _get_excerpt_from_content {
	my $self = shift;
	my $page_body = shift;

	# ץ饰
	$page_body =~ s/{{((.|\s)+?)}}//g;
	# Ǥä
	$page_body =~ s/(==)(.+?)(==)/$2/g;
	# ܡɤ
	$page_body =~ s/(''')(.+?)(''')/$2/g;
	# å
	$page_body =~ s/('')(.+?)('')/$2/g;
	# ̾󥯤
	$page_body =~ s/\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/$1/g;
	$page_body =~ s/\[([^\[]+?)\|(file:[^\[\]]*)\]/$1/g;
	$page_body =~ s/\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/$1/g;
	# ڡ̾󥯤
	$page_body =~ s/\[\[([^\[]+?)\|(.+?)\]\]/$1/g;
	# ڡ󥯤
	$page_body =~ s/\[\[([^\[]+?)\]\]/$1/g;
	# 
	$page_body =~ s/(__)(.+?)(__)/$2/g;
	# 顼å
	$page_body =~ s/(<<)(.+?)(>>)/$2/g;

	# PRE
	$page_body =~ s/^(\s|\t)//mg;
	# Ф
	$page_body =~ s/^!{1,3}//mg;
	# 
	$page_body =~ s/^\*{1,3}//mg;
	# ֹդ
	$page_body =~ s/^\+{1,3}//mg;
	# ʿ
	$page_body =~ s/^-{4}$//mg;
	# 
	$page_body =~ s/^""//mg;

	# Ԥ
	$page_body =~ s/\n//g;

	#ƬʸʬڤФ
	return &SNS::TrackBackUtil::cut_by_bytelength($page_body ,&SNS::TrackBackUtil::get_excerpt_length($self));

}

#===========================================================
# ȴФ
#===========================================================
sub _get_excerpt {
	my $self = shift;
	my $excerpt = shift;

	#---------------------------------
	# ʸ
	#---------------------------------
	# Ԥ
	$excerpt =~ s/\r\n//g;
	$excerpt =~ s/\n//g;
	$excerpt =~ s/\r//g;

	# ȥ
	$excerpt = &Util::trim($excerpt);

	# ʸϤڤͤ
	$excerpt = &SNS::TrackBackUtil::cut_by_bytelength($excerpt ,&SNS::TrackBackUtil::get_excerpt_length($self));

	return &Util::escapeHTML($excerpt);

}

############################################################
#
# TrackbackUtility饹
#
# Written by zedosho<zed_osho@yahoo.co.jp>
#
# Version 0.4 (2005.05.14)
# Version 0.33(2004.08.14)
# Version 0.32(2004.06.25)
# Version 0.31(2004.05.08)
# Version 0.3 (2004.03.25)
# Version 0.2 (2003.09.03)
#
############################################################
package SNS::TrackBackUtil;
use strict;

my $VERSION = "0.4";

#===========================================================
# ΥХȿʸ
#===========================================================
sub cut_by_bytelength{
	my $str = shift;
	my $len = shift;

	if (length($str) <= $len){ return $str;}
	$str = substr($str,0,$len + 1 - 3);	#...Ѥ;ʬ3ХȺ
	#EUC2byteʸڤƤ顢⤦1ХȺ
	if ($str =~ /\x8F$/ or $str =~ tr/\x8E\xA1-\xFE// % 2) {
		$str = substr($str, 0, length($str)-1);
	}
	return $str . '...';
}

#===========================================================
# ˻ѤХȿ
#	餫ᡢȥåХåѤեɤ߹Ǥ
#===========================================================
sub get_excerpt_length{

	my $class = shift;
	my $len = $class->{"config"}->{"excerpt_byte"} ;

	if ($len){
		return $len;
	}
	#̤ΤȤ128Хȸ
	return 128;
}

#------------------------------------------------------------------
# URL?ʲΥѥ᡼դƤȤˤ
# Υѥ᡼URLʬʬ䤹
#------------------------------------------------------------------
sub separate_base_url_and_param{

	my $s = shift;
	my $url;
	my $content;

	#------------------------------------------------------------------
	# URL?ʲΥѥ᡼դƤȤˤ
	# Υѥ᡼URLʬʬ䤹
	#------------------------------------------------------------------
	if ($s =~ /\?/) {
		($url, $content) = $s =~ m!(.*)\?(.*)!s;
	}else{
		$url = $s;
		$content = '';
	}

	return ($url, $content);
}

;;;1;;;

