#!/usr/local/bin/perl
################################################################################
#
# ɽCGIץ
#
################################################################################
use lib 'lib';
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use Unicode::Japanese;
use Util;
use SNS;
#===============================================================================
# 
#===============================================================================
$DATA_DIR   = './data';     # ǡեǼǥ쥯ȥ
$ATTACH_DIR = './attach';   # źեեǼǥ쥯ȥ
$PLUGIN_DIR = './plugin';   # ץ饰Ǽǥ쥯ȥ
$CONFIG_DIR = './conf';     # եǼǥ쥯ȥ
$THEME_DIR  = './theme';    # ơޤǼǥ쥯ȥ
$THEME_URI  = './theme';    # ơޤURI
$ADMIN_PASS = 'pass';       # ѥѥ
#===============================================================================
# С
#===============================================================================
$SNS::VERSION = '3.9';
$SNS::URL     = 'http://amateras.sourceforge.jp/cgi-bin/fswiki/wiki.cgi?page=sns';
#===============================================================================
# ֥Ȥ
#===============================================================================
my $cgi    = CGI->new();
my $plugin = SNS::Plugin->new($PLUGIN_DIR,$cgi);
my $config = &Util::load_config("$CONFIG_DIR/config.dat");
my $sns    = SNS->new($DATA_DIR,$plugin);
#===============================================================================
# ɽ
#===============================================================================
if($cgi->param("download") ne ""){
	my $download = $cgi->param("download");
	
	my ($date,$file) = split(/\./,$download);
	$file = &Util::url_decode($file);
	$mime = &Util::get_mime_type($file);
	
	my $unicode = Unicode::Japanese->new($file,'euc');
	
	die "ե뤬¸ߤޤ" unless(-e "$ATTACH_DIR/$download");
	
	print "Content-Type: $mime\n";
	print "Content-Disposition:inline;filename=\"".$unicode->conv('sjis')."\"\n\n";
	open(DATA,"$ATTACH_DIR/$download");
	binmode(DATA);
	while(<DATA>){
		print $_;
	}
	close(DATA);
	exit;
}

#===============================================================================
# ѥ᡼
#===============================================================================
my $year   = $cgi->param("Year");
my $month  = $cgi->param("Month");
my $day    = $cgi->param("Day");

# ǯ-ǯ--Υѥ᡼
my $date = $cgi->param("Date");
if($date ne ""){
	($year,$month,$day) = split(/\-/,$date);
	$cgi->param("Year" ,$year);
	$cgi->param("Month",$month);
	$cgi->param("Day"  ,$day);
}
#===============================================================================
# Ȥ
#===============================================================================
$COMMENT_NAME = $cgi->cookie(-name=>'SNS_NAME');

if($cgi->param("post_comment") ne ""){
	my $name    = &Util::trim($cgi->param("Name"));
	my $comment = &Util::trim($cgi->param("Comment"));
	
	unless($config->{require_name} eq "true" && ($name eq "" || $name eq "̵̾")){
		$name = "̵̾" if $name eq "";
		if(&Util::handyphone()){
			$name    = Unicode::Japanese->new($name   ,'sjis')->conv('euc');
			$comment = Unicode::Japanese->new($comment,'sjis')->conv('euc');
		}
		$sns->add_comment($year,$month,$day,$name,$comment) if $comment ne "";
		
		# å
		my $cookie = CGI::Cookie->new(-name=>'SNS_NAME',-value=>$name,-expires=>'+30d');
		print "Set-Cookie: ".$cookie->as_string()."\n";
		$COMMENT_NAME = $name;
	}
}
#===============================================================================
# 󡦥Ƚ
#===============================================================================
$LOGIN = 0;
my $cookie = $cgi->cookie(-name=>'SNS_PASS');
if($cookie eq $ADMIN_PASS){
	$LOGIN = 1;
}
if($cgi->param("do_login") ne ""){
	my $password = $cgi->param("Password");
	if($ADMIN_PASS eq $password){
		my $cookie = CGI::Cookie->new(-name=>'SNS_PASS',-value=>$password);
		print "Set-Cookie: ".$cookie->as_string()."\n";
		$LOGIN = 1;
	}
} elsif($cgi->param("do_logout") ne ""){
	my $cookie = CGI::Cookie->new(-name=>'SNS_PASS',-value=>'',-expires=>'-1d');
	print "Set-Cookie: ".$cookie->as_string()."\n";
	$LOGIN = 0;

}

#===============================================================================s
# ι
#===============================================================================
if($cgi->param("save_config") ne ""){
	$config->{title}        = $cgi->param("Title");
	$config->{once}         = $cgi->param("Once");
	$config->{style}        = $cgi->param("Style");
	my $css                 = $cgi->param("CSS");
	my $header              = $cgi->param("Header");
	my $footer              = $cgi->param("Footer");
	$config->{datelink}     = $cgi->param("DateLink");
	$config->{comment}      = $cgi->param("Comment");
	$config->{trackback}    = $cgi->param("TrackBack");
	$config->{referer}      = $cgi->param("Referer");
	my $nolog               = $cgi->param("NoLog");
	$config->{prefix}       = $cgi->param("Prefix");
	$config->{format}       = $cgi->param("Format");
	$config->{rssfile}      = $cgi->param("RSSFile");
	$config->{require_name} = $cgi->param("RequireName");
	
	&Util::save_config("$CONFIG_DIR/config.dat",$config);
	&Util::save_text("$CONFIG_DIR/header.dat"  ,$header);
	&Util::save_text("$CONFIG_DIR/footer.dat"  ,$footer);
	&Util::save_text("$CONFIG_DIR/css.dat"     ,$css);
	&Util::save_text("$CONFIG_DIR/nolog.dat"   ,$nolog);
}
#===============================================================================
# ¸
#===============================================================================
if($cgi->param("do_save") ne "" && $LOGIN==1){
	$sns->update_diary($year,$month,$day,$cgi,$config);
	if($config->{rssfile} ne ""){
		$sns->update_rss($cgi,$config);
	}
} elsif($cgi->param("do_attach") ne "" && $LOGIN==1){
	my $filename = $cgi->param("file");
	my $hundle   = $cgi->upload("file");
	if($filename ne ""){
		my $filecont;
		while(<$hundle>){ $filecont = $filecont.$_; }
		
		$filename =~ s/\\/\//g;
		$filename = substr($filename,rindex($filename,"/")+1);
		$sns->attach_file($year,$month,$day,$filename,$filecont);
	}
} elsif($cgi->param("modify_comment") ne "" && $LOGIN==1){
	my $count = $cgi->param("CommentCount");
	for(my $i=0;$i<$count;$i++){
		my $name    = $cgi->param("Name$i");
		my $comment = $cgi->param("Comment$i");
		$sns->update_comment($year,$month,$day,$i,$name,$comment);
	}
} elsif($cgi->param("modify_trackback") ne "" && $LOGIN==1){
	my @removes = $cgi->param("RemoveTrackBack");
	my $date = $cgi->param("Date");
	$date =~ s/-//g;
	$sns->remove_trackback($date, @removes);
}

#===============================================================================
# إåȥեå
#===============================================================================
my $header = &Util::load_text("$CONFIG_DIR/header.dat");
my $footer = &Util::load_text("$CONFIG_DIR/footer.dat");
my $css    = &Util::load_text("$CONFIG_DIR/css.dat");
my $nolog  = &Util::load_text("$CONFIG_DIR/nolog.dat");

#===============================================================================
# Ͽ
#===============================================================================
$sns->write_log($nolog);

#===============================================================================
# ɤ߹
#===============================================================================
# 
my $search = $cgi->param("Search");

my @list;
my $param = "";

# 
if($search ne ""){
	@list = $sns->search_diary($search);
	$param = "Search=".&Util::url_encode($search)."&";
	
# ǯꤷɤ߹
} elsif($year ne "" && $month ne "" && $day ne ""){
	@list = $sns->load_diary($year,$month,$day);
	$param = "Date=$year-$month-$day&";
	
# ǯꤷɤ߹
} elsif($year ne "" && $month ne ""){
	@list = $sns->load_diary($year,$month);
	$param = "Date=$year-$month&";
	
# ɤ߹ޤʤ
} elsif($cgi->param("do_config") ne "" && $LOGIN==1){
	
	
# ǿxɤ߹
} else {
	@list = $sns->load_diary($config->{once});
}

$SNS::Plugin::param  = $param;
@SNS::Plugin::list   = @list;
$SNS::Plugin::config = $config;

#===============================================================================
# ʸɤη
#===============================================================================
my $charset = 'EUC-JP';
if(&Util::handyphone()){
	$charset = 'Shift_JIS';
}
#===============================================================================
# 쥹ݥ
#===============================================================================
if($name eq ""){
	print $cgi->header(-type => "text/html; charset=$charset");
	$name = $cgi->cookie(-name=>"name");
} else {
	$cookie = $cgi->cookie(-name=>"name",-value=>$name,expires=>"+7d");
	print $cgi->header(-type => "text/html; charset=$charset",-cookie=> $cookie);
}

&Util::print_header($config->{title},$config->{style},$css,$config->{rssfile});

# 桼إå
unless(&Util::handyphone()){
	print $sns->{plugin}->process($header,undef);
}
# Խ
if(($cgi->param("do_edit") ne "" || $cgi->param("do_attach") ne "" || $cgi->param("modify_comment") ne "") && $LOGIN==1){
	$sns->print_form($list[0],$config);
	
# ѹ
} elsif($cgi->param("do_config") ne "" && $LOGIN==1){
	$sns->print_config_form($config,$css,$header,$footer,$nolog);
	
# ɽ
} else {
	my $rows = $cgi->param("r");
	if($rows eq ""){
		$rows = "";
	}
	my $count = 0;
	foreach my $diary (@list){
		if($count>=$rows){
			if($count>=$rows+$config->{once}){
				last;
			}
			if($year ne "" && $month ne "" && $day ne ""){
				$sns->print_diary($config,$diary,1,$search);
			} else {
				$sns->print_diary($config,$diary,0,$search);
			}
		}
		if(&Util::handyphone()){
			last;
		}
		$count++;
	}
}

# 桼եå
unless(&Util::handyphone()){
	print $sns->{plugin}->process($footer,undef);
}
&Util::print_footer();
