package tk.stepcounter.format;

import tk.stepcounter.CountResult;
import tk.stepcounter.Util;

/**
 * JEgʂtH[}bgďo͂NXłB
 * 
 * TODO ۉ
 */
public class DefaultFormatter implements ResultFormatter {
	
	public String format(CountResult[] results){
		
		long sumStep    = 0;
		long sumComment = 0;
		long sumNone    = 0;
		
		// wb_tH[}bg
		StringBuffer sb = new StringBuffer();
		sb.append("t@C                                  s  s    v  ");
		sb.append("\n");
		sb.append("----------------------------------------------------------------------");
		sb.append("\n");
		// Pss
		for(int i=0;i<results.length;i++){
			CountResult result = results[i];
			// Ή̃JEgʂtH[}bg
			if(result.getFileType()==null){
				sb.append(fillOrCut(result.getFileName(),40));
				sb.append("Ή");
				sb.append("\n");
			// ɃJEgꂽʂtH[}bg
			} else {
				String fileName = result.getFileName();
				String fileType = result.getFileType();
				String step     = String.valueOf(result.getStep());
				String non      = String.valueOf(result.getNon());
				String comment  = String.valueOf(result.getComment());
				String sum      = String.valueOf(result.getStep() + result.getNon() + result.getComment());
				
				sb.append(fillOrCut(result.getFileName(),40));
				sb.append(fillOrCut(result.getFileType(), 6));
				sb.append(leftFillOrCut(step    , 6));
				sb.append(leftFillOrCut(non     , 6));
				sb.append(leftFillOrCut(comment , 6));
				sb.append(leftFillOrCut(sum     , 6));
				sb.append("\n");
				
				sumStep    += result.getStep();
				sumComment += result.getComment();
				sumNone    += result.getNon();
			}
		}
		// vstH[}bg
		sb.append("----------------------------------------------------------------------");
		sb.append("\n");
		sb.append(fillOrCut("v",40));
		sb.append(makeSpace(6));
		sb.append(leftFillOrCut(String.valueOf(sumStep)   ,6));
		sb.append(leftFillOrCut(String.valueOf(sumNone)   ,6));
		sb.append(leftFillOrCut(String.valueOf(sumComment),6));
		sb.append(leftFillOrCut(String.valueOf(sumStep + sumNone + sumComment),6));
		sb.append("\n");
		
		return sb.toString();
	}
	
	/** w肳ꂽ̔pXy[X쐬܂ */
	private String makeSpace(int width){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<width;i++){
			sb.append(" ");
		}
		return sb.toString();
	}
	
	/**
	 * 񂪎w̒łΉEXy[XŖ߁A
	 * w̒ȏłΉE؂藎Ƃ܂B
	 */
	private String fillOrCut(String str,int width){
		int length = Util.getByteLength(str);
		if(length==width){
			return str;
		} else if(length < width){
			return str + makeSpace(width - length);
		} else {
			return Util.substring(str,width);
		}
	}
	
	/**
	 * 񂪎w̒ł΍Xy[XŖ߁A
	 * w̒ȏłΉE؂藎Ƃ܂B
	 */
	private String leftFillOrCut(String str,int width){
		int length = Util.getByteLength(str);
		if(length==width){
			return str;
		} else if(length < width){
			return makeSpace(width - length) + str;
		} else {
			return Util.substring(str,width);
		}
	}
}