package tk.stepcounter;

import java.util.*;
import java.io.*;

/** JX^}CYĎgpłW̃XebvJE^ł */
public class DefaultStepCounter implements StepCounter {
	
	private Vector lineComment = new Vector();
	private Vector areaComment = new Vector();
	private String fileType = "UNDEF";
	
	/** t@C̎ނݒ肵܂ */
	public void setFileType(String fileType){
		this.fileType = fileType;
	}
	
	/** t@C̎ނ擾܂ */
	public String getFileType(){
		return this.fileType;
	}
	
	/** PsRg̊Jnǉ܂ */
	public void addLineComment(String str){
		this.lineComment.add(str);
	}
	
	/** PsRg̊Jn擾܂ */
	public String[] getLineComment(){
		String[] dim = new String[lineComment.size()];
		for(int i=0;i<lineComment.size();i++){
			dim[i] = (String)lineComment.get(i);
		}
		return dim;
	}
	
	/** sRgǉ܂ */
	public void addAreaComment(AreaComment area){
		this.areaComment.add(area);
	}
	
	/** sRg擾܂ */
	public AreaComment[] getAreaComment(){
		AreaComment[] dim = new AreaComment[areaComment.size()];
		for(int i=0;i<areaComment.size();i++){
			dim[i] = (AreaComment)areaComment.get(i);
		}
		return dim;
	}
	
	/** JEg܂ */
	public CountResult count(File file) throws IOException {
		BufferedReader reader = new BufferedReader(new FileReader(file));
		String line;
		long step    = 0;
		long non     = 0;
		long comment = 0;
		boolean areaFlag = false;
		AreaComment lastAreaComment = new AreaComment();
		
		while((line=reader.readLine())!=null){
			String trimLine = line.trim();
			if(areaFlag==false){
				if(nonCheck(trimLine)){
					non++;
				} else if(lineCommentCheck(trimLine)){
					comment++;
				} else if((lastAreaComment = areaCommentStartCheck(line,comment))!=null){
					comment++;
					areaFlag = true;
				} else {
					step++;
				}
			} else {
				comment++;
				if(areaCommentEndCheck(line,lastAreaComment)){
					areaFlag = false;
				}
			}
		}
		reader.close();
		return new CountResult(file.getName(),getFileType(),step,non,comment);
	}
	
	/** sǂ`FbN */
	private boolean nonCheck(String line){
		if(line.equals("")){
			return true;
		}
		return false;
	}
	
	/** PsRgǂ`FbN */
	private boolean lineCommentCheck(String line){
		String[] dim = getLineComment();
		for(int i=0;i<dim.length;i++){
			if(line.startsWith(dim[i])){
				return true;
			}
		}
		AreaComment[] area = getAreaComment();
		for(int i=0;i<area.length;i++){
			String start = area[i].getStartString();
			String end   = area[i].getEndString();
			
			int index = line.indexOf(start);
			if(index==0 && line.indexOf(end,index)==line.length()-end.length()){
				return true;
			}
		}
		return false;
	}
	
	/**
	 * sRgJnĂ邩`FbN
	 */
	private AreaComment areaCommentStartCheck(String line,long comment){
		AreaComment[] area = getAreaComment();
		for(int i=0;i<area.length;i++){
			String start = area[i].getStartString();
			String end   = area[i].getEndString();
			
			int index = line.indexOf(start);
			if(index>=0 && line.indexOf(end,index)<0){
				return area[i];
			}
		}
		return null;
	}
	
	/** sRgIĂ邩`FbN */
	private boolean areaCommentEndCheck(String line,AreaComment area){
		String end = area.getEndString();
		if(line.indexOf(end)>=0){
			return true;
		}
		return false;
	}
	
    /**
     * 񒆂̔Cӂ̕w肵ɒu܂B
     *
     * @param s ϊΏۂ̕B
     * @param s1 s2ɒu镶B
     * @param s2 s1ɒu镶B
     * @return ϊ̕Bsnull̏ꍇ͋󕶎Ԃ܂B
     */
    private static String replace(String s,String s1,String s2){

        // s NULLꍇA󕶎Ԃ
        if(s==null){ return ""; }
        
        StringBuffer sb = new StringBuffer();
        for(int i=0;i<s.length();i++){
            if(s.indexOf(s1,i)==i){
                sb.append(s2);
                i = i + s1.length() - 1;
            } else {
                sb.append(s.charAt(i));
            }
        }
        return sb.toString();
    }
}