#!/usr/local/bin/perl
################################################################################
#
# ɽCGIץ
#
################################################################################
use lib 'lib';
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use Unicode::Japanese;
#===============================================================================
# 
#===============================================================================
$DATA_DIR   = './data';     # ǡեǼǥ쥯ȥ
$ATTACH_DIR = './attach';   # źեեǼǥ쥯ȥ
$PLUGIN_DIR = './plugin';   # ץ饰Ǽǥ쥯ȥ
$CONFIG_DIR = './conf';     # եǼǥ쥯ȥ
$THEME_DIR  = './theme';    # ơޤǼǥ쥯ȥ
$THEME_URI  = './theme';    # ơޤURI
$ADMIN_PASS = 'pass';       # ѥѥ
#===============================================================================
# С
#===============================================================================
$SNS::VERSION = '3.7';
$SNS::URL     = 'http://www3.vis.ne.jp/~asaki/sns/';
#===============================================================================
# ֥Ȥ
#===============================================================================
my $cgi    = CGI->new();
my $plugin = SNS::Plugin->new($PLUGIN_DIR,$cgi);
my $config = &Util::load_config("$CONFIG_DIR/config.dat");
my $sns    = SNS->new($DATA_DIR,$plugin);

#===============================================================================
# ɽ
#===============================================================================
if($cgi->param("download") ne ""){
	my $download = $cgi->param("download");
	
	my ($date,$file) = split(/\./,$download);
	$file = &Util::url_decode($file);
	$mime = &Util::get_mime_type($file);
	
	my $unicode = Unicode::Japanese->new($file,'euc');
	
	die "ե뤬¸ߤޤ" unless(-e "$ATTACH_DIR/$download");
	
	print "Content-Type: $mime\n";
	print "Content-Disposition:inline;filename=\"".$unicode->conv('sjis')."\"\n\n";
	open(DATA,"$ATTACH_DIR/$download");
	binmode(DATA);
	while(<DATA>){
		print $_;
	}
	close(DATA);
	exit;
}

#===============================================================================
# ѥ᡼
#===============================================================================
my $year   = $cgi->param("Year");
my $month  = $cgi->param("Month");
my $day    = $cgi->param("Day");

# ǯ-ǯ--Υѥ᡼
my $date = $cgi->param("Date");
if($date ne ""){
	($year,$month,$day) = split(/\-/,$date);
	$cgi->param("Year" ,$year);
	$cgi->param("Month",$month);
	$cgi->param("Day"  ,$day);
}
#===============================================================================
# Ȥ
#===============================================================================
$COMMENT_NAME = $cgi->cookie(-name=>'SNS_NAME');

if($cgi->param("post_comment") ne ""){
	my $name    = &Util::trim($cgi->param("Name"));
	my $comment = &Util::trim($cgi->param("Comment"));
	
	unless($config->{require_name} eq "true" && ($name eq "" || $name eq "̵̾")){
		
		$name = "̵̾" if $name eq "";
		$sns->add_comment($year,$month,$day,$name,$comment) if $comment ne "";
		
		# å
		my $cookie = CGI::Cookie->new(-name=>'SNS_NAME',-value=>$name,-expires=>'+30d');
		print "Set-Cookie: ".$cookie->as_string()."\n";
		$COMMENT_NAME = $name;
	}
}
#===============================================================================
# 󡦥Ƚ
#===============================================================================
$LOGIN = 0;
my $cookie = $cgi->cookie(-name=>'SNS_PASS');
if($cookie eq $ADMIN_PASS){
	$LOGIN = 1;
}
if($cgi->param("do_login") ne ""){
	my $password = $cgi->param("Password");
	if($ADMIN_PASS eq $password){
		my $cookie = CGI::Cookie->new(-name=>'SNS_PASS',-value=>$password);
		print "Set-Cookie: ".$cookie->as_string()."\n";
		$LOGIN = 1;
	}
} elsif($cgi->param("do_logout") ne ""){
	my $cookie = CGI::Cookie->new(-name=>'SNS_PASS',-value=>'',-expires=>'-1d');
	print "Set-Cookie: ".$cookie->as_string()."\n";
	$LOGIN = 0;

}

#===============================================================================s
# ι
#===============================================================================
if($cgi->param("save_config") ne ""){
	$config->{title}        = $cgi->param("Title");
	$config->{once}         = $cgi->param("Once");
	$config->{style}        = $cgi->param("Style");
	my $css                 = $cgi->param("CSS");
	my $header              = $cgi->param("Header");
	my $footer              = $cgi->param("Footer");
	$config->{datelink}     = $cgi->param("DateLink");
	$config->{comment}      = $cgi->param("Comment");
	$config->{referer}      = $cgi->param("Referer");
	my $nolog               = $cgi->param("NoLog");
	$config->{prefix}       = $cgi->param("Prefix");
	$config->{format}       = $cgi->param("Format");
	$config->{rssfile}      = $cgi->param("RSSFile");
	$config->{require_name} = $cgi->param("RequireName");
	
	&Util::save_config("$CONFIG_DIR/config.dat",$config);
	&Util::save_text("$CONFIG_DIR/header.dat"  ,$header);
	&Util::save_text("$CONFIG_DIR/footer.dat"  ,$footer);
	&Util::save_text("$CONFIG_DIR/css.dat"     ,$css);
	&Util::save_text("$CONFIG_DIR/nolog.dat"   ,$nolog);
}
#===============================================================================
# ¸
#===============================================================================
if($cgi->param("do_save") ne "" && $LOGIN==1){
	$sns->update_diary($year,$month,$day,$cgi->param("Content"),$cgi->param("Style"));
	if($config->{rssfile} ne ""){
		$sns->update_rss($cgi,$config);
	}
} elsif($cgi->param("do_attach") ne "" && $LOGIN==1){
	my $filename = $cgi->param("file");
	my $hundle   = $cgi->upload("file");
	if($filename ne ""){
		my $filecont;
		while(<$hundle>){ $filecont = $filecont.$_; }
		
		$filename =~ s/\\/\//g;
		$filename = substr($filename,rindex($filename,"/")+1);
		$sns->attach_file($year,$month,$day,$filename,$filecont);
	}
} elsif($cgi->param("modify_comment") ne "" && $LOGIN==1){
	my $count = $cgi->param("CommentCount");
	for(my $i=0;$i<$count;$i++){
		my $name    = $cgi->param("Name$i");
		my $comment = $cgi->param("Comment$i");
		$sns->update_comment($year,$month,$day,$i,$name,$comment);
	}
}

#===============================================================================
# إåȥեå
#===============================================================================
my $header = &Util::load_text("$CONFIG_DIR/header.dat");
my $footer = &Util::load_text("$CONFIG_DIR/footer.dat");
my $css    = &Util::load_text("$CONFIG_DIR/css.dat");
my $nolog  = &Util::load_text("$CONFIG_DIR/nolog.dat");

#===============================================================================
# Ͽ
#===============================================================================
$sns->write_log($nolog);

#===============================================================================
# ɤ߹
#===============================================================================
# 
my $search = $cgi->param("Search");

my @list;
my $param = "";

# 
if($search ne ""){
	@list = $sns->search_diary($search);
	$param = "Search=".&Util::url_encode($search)."&";
	
# ǯꤷɤ߹
} elsif($year ne "" && $month ne "" && $day ne ""){
	@list = $sns->load_diary($year,$month,$day);
	$param = "Date=$year-$month-$day&";
	
# ǯꤷɤ߹
} elsif($year ne "" && $month ne ""){
	@list = $sns->load_diary($year,$month);
	$param = "Date=$year-$month&";
	
# ɤ߹ޤʤ
} elsif($cgi->param("do_config") ne "" && $LOGIN==1){
	
	
# ǿxɤ߹
} else {
	@list = $sns->load_diary($config->{once});
}

$SNS::Plugin::param  = $param;
@SNS::Plugin::list   = @list;
$SNS::Plugin::config = $config;

#===============================================================================
# 쥹ݥ
#===============================================================================
if($name eq ""){
	print $cgi->header(-type => "text/html; charset=EUC-JP");
	$name = $cgi->cookie(-name=>"name");
} else {
	$cookie = $cgi->cookie(-name=>"name",-value=>$name,expires=>"+7d");
	print $cgi->header(-type => "text/html; charset=EUC-JP",-cookie=> $cookie);
}

&Util::print_header($config->{title},$config->{style},$css,$config->{rssfile});

# 桼إå
print $sns->{plugin}->process($header,undef);

# Խ
if(($cgi->param("do_edit") ne "" || $cgi->param("do_attach") ne "" || $cgi->param("modify_comment") ne "") && $LOGIN==1){
	$sns->print_form($list[0],$config);
	
# ѹ
} elsif($cgi->param("do_config") ne "" && $LOGIN==1){
	$sns->print_config_form($config,$css,$header,$footer,$nolog);
	
# ɽ
} else {
	my $rows = $cgi->param("r");
	if($rows eq ""){
		$rows = "";
	}
	my $count = 0;
	foreach my $diary (@list){
		if($count>=$rows){
			if($count>=$rows+$config->{once}){
				last;
			}
			if($year ne "" && $month ne "" && $day ne ""){
				$sns->print_diary($config,$diary,1);
			} else {
				$sns->print_diary($config,$diary);
			}
		}
		$count++;
	}
}

# 桼եå
print $sns->{plugin}->process($footer,undef);
&Util::print_footer();

###############################################################################
#
# SNS
#
###############################################################################
package SNS;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class    = shift;
	my $data_dir = shift;
	my $plugin   = shift;
	
	my $self = {};
	$self->{data_dir} = $data_dir;
	$self->{parser}->{HTML} = SNS::HTMLParser->new();
	$self->{parser}->{Wiki} = SNS::WikiParser->new();
	$self->{plugin} = $plugin;
	
	$SNS::Plugin::sns = $self;
	
	return bless $self,$class;
}

#==============================================================================
# SNS::Diary֥Ȥ֤ޤ
#==============================================================================
sub load_diary {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my @list;
	
	# ǯꤷƣɤ߹
	if(defined($year) && defined($month) && defined($day)){
		push(@list,$self->_load_one_day($year,$month,$day));
		
	# ǯꤷƣʬɤ߹
	} elsif(defined($year) && defined($month)){
		my @files = glob(sprintf("%s/%04d%02d*.dat",$self->{data_dir},$year,$month));
		foreach my $file (sort {$b cmp $a} @files){
			if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
				push(@list,$self->_load_one_day($1,$2,$3));
			}
		}
	# Ƕxɤ߹
	} else {
		my $count = 0;
		my @files = glob($self->{data_dir}."/*.dat");
		@files = sort {$b cmp $a} @files;
		foreach my $file (@files){
			last if $count==$year;
			if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
				push(@list,$self->_load_one_day($1,$2,$3));
			}
			$count++;
		}
	}
	
	return @list;
}

#==============================================================================
# SNS::Diary֥Ȥ֤ޤ
#==============================================================================
sub search_diary {
	my $self  = shift;
	my @words = split(/\s+/,shift);
	my @list;
	
	my @files = glob($self->{data_dir}."/*.dat");
	foreach my $file (sort {$b cmp $a} @files){
		if($file =~ /\/([0-9]{4})([0-9]{2})([0-9]{2})\.dat$/){
			my $year  = $1;
			my $month = $2;
			my $day   = $3;
			my $flag  = 1;
			
			open(DATA,$file) or die "$fileΥץ˼Ԥޤ";
			my $source = join("",<DATA>);
			close(DATA);
			
			foreach my $word (@words){
				if(index($source,$word)==-1){
					$flag = 0;
					last;
				}
			}
			if($flag==1){
				push(@list,$self->_load_one_day($year,$month,$day,\@words));
			}
		}
	}
	return @list;
}

#==============================================================================
# ʸ򹹿ޤ
#==============================================================================
sub update_diary {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my $content = &Util::trim(shift);
	my $style   = shift;
	
	if($style eq ""){
		$style = "HTML";
	}
	
	# ԥɤ
	$content =~ s/\r\n/\n/g;
	$content =~ s/\r/\n/g;
	
	my $filename = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"dat");
	
	if($content ne ""){
		open(DATA,">$filename") or die "$filenameΥץ˼Ԥޤ";
		print DATA "\@style=$style\n";
		print DATA $content;
		close(DATA);
	} else {
		unlink($filename);
		$cmtfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
		if(-e $cmtfile){
			unlink($cmtfile);
		}
	}
}

#==============================================================================
# RSS򹹿ޤ
#==============================================================================
sub update_rss {
	my $self   = shift;
	my $cgi    = shift;
	my $config = shift;
	
	# RSS򹹿ʼꤢǤ10ʬ
	my @list = $self->load_diary(15);
	my $index_url = &Util::escapeXML($cgi->url(-path_info => 1));
	my $title     = &Util::escapeXML($config->{title});
	my $mod_time  = &Util::W3CDTF(time(),"+09:00");
	
	my $link_buf = "";
	my $item_buf = "";
	
	foreach my $diary (@list){
		my @sections    = $diary->parse();
		my $day_title   = &Util::delete_tag($sections[0]->{TITLE});
		my $day_modtime = &Util::W3CDTF($diary->lastmodified(),"+09:00");
		my $day_link    = &Util::escapeXML(sprintf("$index_url?Year=%d&Month=%d&Day=%d",
		                                   $diary->year,$diary->month,$diary->day));
		
		
		$link_buf .= "<rdf:li rdf:resource=\"$day_link\"/>\n";
		
		$item_buf .= "<item rdf:about=\"$day_link\">\n".
		             "  <title>$day_title</title>\n".
		             "  <link>$day_link</link>\n".
		             "  <dc:date>$day_modtime</dc:date>\n".
		             "</item>\n";
	}
	
	my $rss  = "<?xml version=\"1.0\" encoding=\"EUC-JP\" standalone=\"yes\"?>\n".
	           "<rdf:RDF xmlns=\"http://purl.org/rss/1.0/\"\n".
	           "         xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n".
	           "         xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n".
	           "         xml:lang=\"ja\">\n".
	           "  <channel rdf:about=\"$index_url\">\n".
	           "    <title>$title</title>\n".
	           "    <link>$index_url</link>\n".
	           "    <dc:language>ja</dc:language>\n".
	           "    <dc:date>$mod_time</dc:date>\n".
	           "    <items>\n".
	           "      <rdf:Seq>\n".
	           "        $link_buf\n".
	           "      </rdf:Seq>\n".
	           "    </items>\n".
	           "  </channel>\n".
	           "  $item_buf\n".
	           "</rdf:RDF>\n";
	
	open(RSS,">".$config->{rssfile}) or die "RSSեι˼Ԥޤ";
	print RSS $rss;
	close(RSS);
}

#==============================================================================
# Ȥɲäޤ
#==============================================================================
sub add_comment {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my $name    = shift;
	my $comment = shift;
	my $time    = time();
	
	$name    =~ s/,//g;
	$comment =~ s/,//g;
	my $filename = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
	
	open(DATA,">>$filename") or die "$filenameΥץ˼Ԥޤ";
	print DATA "$name,$comment,$time\n";
	close(DATA);
}

#==============================================================================
# Ȥ򹹿ޤ
#==============================================================================
sub update_comment {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my $count   = shift;
	my $name    = shift;
	my $comment = shift;
	
	$name    =~ s/,//g;
	$comment =~ s/,//g;
	my $filename = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
	
	my $buf = "";
	my $i   =  0;
	
	open(DATA,"$filename") or die "$filenameΥץ˼Ԥޤ";
	while(my $line=<DATA>){
		if($i==$count){
			if($name eq "" || $comment eq ""){
				
			} else {
				my ($a,$b,$time) = split(/,/,$line);
				$buf .= "$name,$comment,$time";
			}
		} else {
			$buf .= $line;
		}
		$i++;
	}
	close(DATA);
	
	open(DATA,">$filename") or die "$filenameΥץ˼Ԥޤ";
	print DATA $buf;
	close(DATA);
}

#==============================================================================
# եźդޤ
#==============================================================================
sub attach_file {
	my $self     = shift;
	my $year     = shift;
	my $month    = shift;
	my $day      = shift;
	my $filename = shift;
	my $filecont = shift;
	
	my $savefile = sprintf("$main::ATTACH_DIR/%04d%02d%02d.%s",$year,$month,$day,&Util::url_encode($filename));
	
	if($filecont){
		open(DATA,">$savefile");
		binmode(DATA);
		print DATA $filecont;
		close(DATA);
		
	} else {
		unlink($savefile);
	}
}

#==============================================================================
# Ϥޤ
#==============================================================================
sub write_log {
	my $self  = shift;
	my $nolog = shift;
	
	$nolog =~ s/\r\n/\n/g;
	$nolog =~ s/\r/\n/g;
	
	my @deny    = split(/\n/,$nolog);
	my $ip      = $ENV{"REMOTE_ADDR"};
	my $referer = $ENV{"HTTP_REFERER"};
	
	if($referer eq ""){ $referer = "-"; }
	
	foreach my $url (@deny){
		if(index($referer,$url)!=-1){
			return;
		}
	}
	
	my ($sec,$min,$hour,$mday,$mon,$year,$wday) = localtime(time());
	
	my $logfile = sprintf("%s/%04d%02d%02d.log",$self->{data_dir},$year+1900,$mon+1,$mday);
	my $date    = sprintf("%04d/%02d/%02d",$year+1900,$mon+1,$mday);
	my $week    = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
	my $time    = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
	
	open(LOG,">>$logfile");
	binmode(LOG);
	print LOG "$ip $referer $date $week $time\n";
	close(LOG);
}

#==============================================================================
# եޤ
#==============================================================================
sub get_referer {
	my $self    = shift;
	my $year    = shift;
	my $month   = shift;
	my $day     = shift;
	my %referer;
	
	my $logfile = sprintf("%s/%04d%02d%02d.log",$self->{data_dir},$year,$month,$day);
	
	open(LOG,$logfile);
	while(my $line = <LOG>){
		chomp $line;
		my ($ip,$ref,$date,$week,$time) = split(/ /,$line);
		if($ref ne "-"){
			$referer{$ref}++;
		}
	}
	close(LOG);
	
	my @urls = sort {$referer{$b}<=>$referer{$a}} keys(%referer);
	my @result;
	foreach my $url (@urls){
		push(@result,{URL=>$url,COUNT=>$referer{$url}});
	}
	return @result;
}

#==============================================================================
# ʬɽ
#==============================================================================
sub print_diary {
	my $self     = shift;
	my $config   = shift;
	my $diary    = shift;
	my $detail   = shift;
	my @sections = $diary->parse();
	my $date     = $diary->date;
	
	print "<div class=\"day\">\n";
	
	# 
	print "<h2><span class=\"title\">\n";
	if($config->{"datelink"} eq "true"){
		print "<A HREF=\"diary.cgi?Date=$date\" CLASS=\"datelink\">";
	}
	print $diary->year."/".$diary->month."/".$diary->day;
	if($config->{"datelink"} eq "true"){
		print "</A>\n";
	}
	if($main::LOGIN==1){
		print " <a href=\"diary.cgi?do_edit=1&Date=".$diary->date."\">Խ</a>";
	}
	
	print "</span></h2>\n";
	
	# ʸ
	print "<div class=\"body\">\n";
	foreach my $section (@sections){
		my $anchor = sprintf("%04d%02d%02d%02d",$diary->year,$diary->month,$diary->day,$section->{ID});
		print "<div class=\"section\"><h3 class=\"subtitle\">";
		print "<a href=\"diary.cgi?Date=$date#$anchor\">";
		if($config->{prefix} ne "_"){
			print $config->{prefix};
		} else {
			print "<span class=\"panchor\">_</span>";
		}
		print "</a>";
		print "<a name=\"$anchor\">\n";
		
		# ȥΥƥ
		my $sec_title = $section->{TITLE};
		$sec_title =~ s/\[(.*?)\]/"[<a href=\"diary.cgi?Search=".&Util::url_encode("[$1]")."\">$1<\/a>]"/eg;

		$self->{plugin}->process($sec_title,$diary);
		print "</a></h3>\n";
		$self->{plugin}->process($section->{CONTENT},$diary);
		print "</div>\n";
	}
	print "</div>\n";
	
	# 
	if($config->{comment} eq "true" && $SNS::Plugin::cgi->param("Search") eq ""){
		$self->print_comment($diary);
	}
	
	# ե
	if($config->{referer} eq "true" && $SNS::Plugin::cgi->param("Search") eq ""){
		$self->print_referer($diary,$detail);
	}
	
	print "</div>\n";
}

#==============================================================================
# եɽޤ
#==============================================================================
sub print_referer {
	my $self   = shift;
	my $diary  = shift;
	my $detail = shift;
	
	if($detail==1){
		print "<div class=\"refererlist\">\n";
		print "  <div class=\"caption\">Υ󥯸</div>\n";
		print "  <ul>\n";
		foreach my $ref ($self->get_referer($diary->year,$diary->month,$diary->day)){
			my $conv = $ref->{URL} =~ /UTF-8/i ? 'utf8' : 'auto';
			my $url  = Unicode::Japanese->new(&Util::url_decode($ref->{URL}),$conv);
			print "    <li><a href=\"".$ref->{URL}."\">".&Util::escapeHTML($url->conv("euc"))."</a> &times;".$ref->{COUNT}."</li>\n";
		}
		print "  </ul>\n";
		print "</div>\n";
	} else {
		my $count = 0;
		print "<div class=\"referer\">\n";
		print "Υ󥯸 |\n";
		foreach my $ref ($self->get_referer($diary->year,$diary->month,$diary->day)){
			last if $count==20;
			print " <a href=\"".$ref->{URL}."\">".$ref->{COUNT}."</a> |\n";
			$count++;
		}
		print "</div>\n";
	}

}

#==============================================================================
# Ȥɽޤ
#==============================================================================
sub print_comment {
	my $self  = shift;
	my $diary = shift;
	my $edit  = shift;
	
	print "<div class=\"comment\">\n";
	print "<div class=\"caption\"></div>\n";
	print "<div class=\"commentshort\">\n";
	if($edit==1){
		my $count = 0;
		print "<form action=\"diary.cgi\" method=\"POST\">\n";
		foreach $comment (@{$diary->comment}){
			print &Util::textfield("Name$count"   ,10,$comment->{NAME});
			print &Util::textfield("Comment$count",60,$comment->{COMMENT});
			print "<br>\n";
			$count++;
		}
		print "  <input type=\"submit\" name=\"modify_comment\" value=\"ѹ\">\n";
		print "  <input type=\"reset\" value=\"ꥻå\">\n";
		print "  <input type=\"hidden\" name=\"CommentCount\"  value=\"$count\">\n";
		print "  <input type=\"hidden\" name=\"Date\"  value=\"".$diary->date."\">\n";
		print "</form>\n";
		
	} else {
		foreach $comment (@{$diary->comment}){
			print "<p>\n".
			      "  <span class=\"commentator\">".&Util::escapeHTML($comment->{NAME})."</span> ".
			      "  ".&Util::escapeHTML($comment->{COMMENT})." ".
			      "  (".&Util::format_short_date($comment->{TIME}).")\n".
			      "</p>\n";
		}
	}
	print "</div>\n";
	
	if($edit != 1){
		print "<form action=\"diary.cgi\" method=\"POST\">\n";
		print "  ̾<input type=\"text\" name=\"Name\" size=\"10\" value=\"".&Util::escapeHTML($main::COMMENT_NAME)."\">\n";
		print "  <input type=\"text\" name=\"Comment\" size=\"40\">\n";
		print "  <input type=\"submit\" name=\"post_comment\" value=\"\">\n";
		print "  <input type=\"hidden\" name=\"Date\"  value=\"".$diary->date."\">\n";
		print "</form>\n";
	}
	
	print "</div>\n";
}

#==============================================================================
# ϥեɽޤ
#==============================================================================
sub print_form {
	my $self   = shift;
	my $diary  = shift;
	my $config = shift;
	
	if($diary->content eq ""){
		$diary->style($config->{format});
	}
	
	print "<div class=\"day\">\n";
	print "<form action=\"diary.cgi\" method=\"POST\">\n";
	print "<h2>";
	print "<input type=\"text\" name=\"Year\"  size=\"4\" value=\"".$diary->year."\">/";
	print "<input type=\"text\" name=\"Month\" size=\"2\" value=\"".$diary->month."\">/";
	print "<input type=\"text\" name=\"Day\"   size=\"2\" value=\"".$diary->day."\">";
	print "</h2>\n";
	
	print "<div class=\"body\">\n";
	print "  <textarea name=\"Content\" cols=\"80\" rows=\"20\">".&Util::escapeHTML($diary->content)."</textarea>\n";
	print "  <br>\n";
	
	print "   ".&Util::combobox("Style",[{VALUE=>'HTML',LABEL=>'HTML'},
												{VALUE=>'Wiki',LABEL=>'Wiki'}],$diary->style)."\n";
	
	print "  <input type=\"submit\" name=\"do_save\" value=\"  ¸ \">\n";
	print "</form>\n";
	
	print "</div>\n";

	print "<div class=\"comment\">\n";
	print "  <div class=\"caption\">\n";
	print "    եź |\n";
	foreach my $file (@{$diary->attach}){
		my $localfile = sprintf("%04d%02d%02d.%s",$year,$month,$day,&Util::url_encode($file));
		print "<a href=\"diary.cgi?download=".&Util::url_encode($localfile)."\">".&Util::escapeHTML($file)."</a>".
		      "[<a href=\"diary.cgi?do_attach=1&Date=".$diary->date."&file=".&Util::url_encode($file)."\"></a>] |\n";
	}
	print "  </div>\n";
	print "  <div class=\"commentshort\">\n";
	print "    <form action=\"diary.cgi\" method=\"POST\" enctype=\"multipart/form-data\">\n";
	print "      <input type=\"file\"   name=\"file\">\n";
	print "      <input type=\"submit\" name=\"do_attach\" value=\" ź  \">\n";
	print "      <input type=\"hidden\" name=\"Date\" value=\"".$diary->date ."\">\n";
	print "    </form>\n";
	print "  </div>\n";
	print "</div>\n";

	if($config->{comment} eq "true"){
		$self->print_comment($diary,1);
	}
#	if($config->{referer} eq "true"){
		$self->print_referer($diary,1);
#	}
	print "</div>\n";
}

#==============================================================================
# ѥեɽޤ
#==============================================================================
sub print_config_form {
	my $self   = shift;
	my $config = shift;
	my $css    = shift;
	my $header = shift;
	my $footer = shift;
	my $nolog  = shift;
	
	print "<form action=\"diary.cgi\" method=\"POST\">\n";
	
	# ɽ˴ؤ
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\">ɽ˴ؤ</span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ǿǤɽ</h3>\n";
	print "      <p>".&Util::textfield("Once",2,$config->{once})."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ơ</h3>\n";
	print "      <p>\n";
	print "        <select name=\"Style\">\n";
	foreach my $entry (sort(glob("$main::THEME_DIR/*.css"))){
		$entry =~ /\/([A-Za-z0-9_\-]+?\.css)$/;
		print "          <option value=\"$main::THEME_URI/$1\"";
		if($config->{"style"} eq "$main::THEME_URI/$1"){ print " selected"; }
		print ">$1\n";
	}
	print "        </select>\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\"></h3>\n";
	print "      <p>\n";
	print "        ".&Util::checkbox("DateLink","true",$config->{datelink})."\n";
	print "        󥫤Ϳ\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">Υץեå</h3>\n";
	print "      <p>\n";
	print "        ".&Util::textfield("Prefix",20,$config->{prefix})."\n";
	print "        ˤХ󥫤ϽϤޤ\n";
	print "      </p>\n";
	print "    </div>\n";

	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\"></h3>\n";
	print "      <p>\n";
	print "        ".&Util::checkbox("Comment","true",$config->{comment})."\n";
	print "        ȵǽѤ\n";
	print "        ".&Util::checkbox("RequireName","true",$config->{require_name})."\n";
	print "        ̾ɬ\n";
	print "      </p>\n";
	print "    </div>\n";

	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ե</h3>\n";
	print "      <p>\n";
	print "        ".&Util::checkbox("Referer","true",$config->{referer})."\n";
	print "        եɽ\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">ɸΥ</h3>\n";
	print "      <p>\n";
	print "        ".&Util::combobox("Format",[{VALUE=>'HTML',LABEL=>'HTML'},{VALUE=>'Wiki',LABEL=>'Wiki'}],$config->{format})."\n";
	print "      </p>\n";
	print "    </div>\n";

	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">RSS</h3>\n";
	print "      <p>\n";
	print "        ".&Util::textfield("RSSFile",20,$config->{rssfile})."\n";
	print "        ˤRSSեޤ\n";
	print "      </p>\n";
	print "    </div>\n";
	
	print "  </div>\n";
	print "</div>\n";
	
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	# إåեå˴ؤ
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\">إåեå˴ؤ</span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">Υȥ</h3>\n";
	print "      <p>".&Util::textfield("Title",40,$config->{title})."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\"><h3 class=\"subtitle\">륷</h3>\n";
	print "      <p>".&Util::textarea("CSS",60,10,$css)."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\"><h3 class=\"subtitle\">إå</h3>\n";
	print "      <p>".&Util::textarea("Header",60,10,$header)."</p>\n";
	print "    </div>\n";
	
	print "    <div class=\"section\"><h3 class=\"subtitle\">եå</h3>\n";
	print "      <p>".&Util::textarea("Footer",60,10,$footer)."</p>\n";
	print "    </div>\n";
	
	print "  </div>\n";
	print "</div>\n";
	
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	# 
	print "<div class=\"day\">\n";
	print "  <h2><span class=\"title\"></span></h2>\n";
	print "  <div class=\"body\">\n";
	
	print "    <div class=\"section\">\n";
	print "      <h3 class=\"subtitle\">URLʣԤˣĤġ</h3>\n";
	print "      <p>".&Util::textarea("NoLog",60,10,$nolog)."</p>\n";
	print "    </div>\n";
	
	print "  </div>\n";
	print "</div>\n";
	
	print "<input type=\"submit\" name=\"save_config\" value=\"򹹿\">\n";
	
	print "</form>\n";
}

#==============================================================================
# ե̾ޤ
#==============================================================================
sub _make_filename {
	my $self  = shift;
	my $year  = shift;
	my $month = shift;
	my $day   = shift;
	my $ext   = shift;
	
	return sprintf("%04d%02d%02d.%s",$year,$month,$day,$ext);
}

#==============================================================================
# YYYYMMDDʸǯʬ䤷ޤ
#==============================================================================
sub _split_date {
	my $self = shift;
	my $file = shift;
	
	my $year  = int(substr($file,0,4));
	my $month = int(substr($file,4,2));
	my $day   = int(substr($file,6,2));
	
	return ($year,$month,$day);
}

#==============================================================================
# ʬɤ߹ߡSNS::Diary֥Ȥ֤ޤ
#==============================================================================
sub _load_one_day {
	my $self   = shift;
	my $year   = shift;
	my $month  = shift;
	my $day    = shift;
	my $words  = shift;
	
	# ǯ
	my $diary = SNS::Diary->new();
	$diary->year($year);
	$diary->month($month);
	$diary->day($day);
	
	# ʸɤ߹
	my $buf      = "";
	my $datfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"dat");
	if(-e $datfile){
		open(DATA,$datfile) or die "$datfileΥץ˼Ԥޤ";
		while(my $line = <DATA>){
			# ԥɤ
			$line =~ s/\r\n/\n/g;
			$line =~ s/\r/\n/g;
			# 
			if($line =~ /^\@style=(.+)\n/){
				$diary->parser($self->{parser}->{$1});
				$diary->style($1);
				next;
			}
			$buf .= $line;
		}
		close(DATA);
		$diary->content($buf);
	}
	
	# μ
	my @status = stat($datfile);
	$diary->lastmodified($status[9]);
	
	unless(defined($diary->parser)){
		$diary->parser($self->{parser}->{HTML});
		$diary->style('HTML');
	}
	
	# ϳ륻Τ
	if(defined($words)){
		my $sec_buf = "";
		my $content = "";
		foreach my $line (split(/\n/,$diary->content)){
			if($line eq ""){
				if($sec_buf ne ""){
					foreach my $word (@$words){
						if(index($sec_buf,$word)!=-1){
							$content .= "$sec_buf\n";
							last;
						}
					}
				}
				$sec_buf = "";
			} else {
				$sec_buf .= "$line\n";
			}
		}
		
		if($sec_buf ne ""){
			foreach my $word (@$words){
				if(index($sec_buf,$word)!=-1){
					$content .= "$sec_buf\n";
					last;
				}
			}
		}
		$diary->content($content);
		
		# Ȥɤ߹ޤ֤
		return $diary;
	}
	
	# Ȥɤ߹
	my $cmtfile = $self->{data_dir}."/".$self->_make_filename($year,$month,$day,"cmt");
	if(-e $cmtfile){
		open(DATA,$cmtfile) or die "$cmtfileΥץ˼Ԥޤ";
		my $count  = 0;
		my $cmtbuf = [];
		while(my $line = <DATA>){
			chomp $line;
			my ($name,$comment,$time) = split(/,/,$line);
			push(@$cmtbuf,{ID=>$count,NAME=>$name,COMMENT=>$comment,TIME=>$time});
			$count++;
		}
		close(DATA);
		$diary->comment($cmtbuf);
	}
	
	# źեեɤ߹
	my $attach = [];
	foreach my $entry (glob(sprintf("$main::ATTACH_DIR/%04d%02d%02d.*",$year,$month,$day))){
		my ($hoge,$file) = split(/[0-9]{4}[0-9]{2}[0-9]{2}\./,$entry);
		push (@$attach,&Util::url_decode($file));
	}
	$diary->attach($attach);
	
	return $diary;
}

###############################################################################
#
# 桼ƥƥ
#
###############################################################################
package Util;
#===============================================================================
# ե̾Content-Typeؿ
#===============================================================================
sub get_mime_type {
	my $file  = shift;
	my $type  = substr($file,rindex($file,"."));
	my $ctype;
	
	if   ($type eq ".gif" ){ $ctype = "image/gif"; }
	elsif($type eq ".txt" ){ $ctype = "text/plain"; }
	elsif($type eq ".html"){ $ctype = "text/html"; }
	elsif($type eq ".htm" ){ $ctype = "text/html"; }
	elsif($type eq ".css" ){ $ctype = "text/css"; }
	elsif($type eq ".jpeg"){ $ctype = "image/jpeg"; }
	elsif($type eq ".jpg" ){ $ctype = "image/jpeg"; }
	elsif($type eq ".bmp" ){ $ctype = "image/bmp"; }
	elsif($type eq ".doc" ){ $ctype = "application/msword"; }
	elsif($type eq ".xls" ){ $ctype = "application/vnd.ms-excel"; }
	else                   { $ctype = "application/octet-stream"; }
	
	$ctype;
}
#==============================================================================
# ʸΥȥԤޤ
#==============================================================================
sub trim {
	my $str = shift;
	
	$str =~ s/^(\r|\n)+//g;
	$str =~ s/(\r|\n)+$//g;
	
	return $str;
}
#==============================================================================
# HTML򥨥פޤ
#==============================================================================
sub escapeHTML {
	my $retstr = shift;
	my $brconv = shift;
	
	$retstr =~ s/&/&amp;/g;
	$retstr =~ s/"/&quot;/g;
	$retstr =~ s/'/&#39;/g;
	$retstr =~ s/</&lt;/g;
	$retstr =~ s/>/&gt;/g;
	
	if($brconv==1){
		$retstr =~ s/\r\n/<br>/g;
		$retstr =~ s/\r/<br>/g;
		$retstr =~ s/\n/<br>/g;
	}
	
	return $retstr;
}

#==============================================================================
# Ϥ줿ʸXMLΥƥƥѴ֤ޤ
#==============================================================================
sub escapeXML {
	my ($str) = @_;
	my %table = (
		'&' => '&amp;',
		'<' => '&lt;',
		'>' => '&gt;',
		"'" => '&apos;',
		'"' => '&quot;',
	);
	$str =~ s/([&<>\'\"])/$table{$1}/go;
	return $str;
}

#===============================================================================
# ʸΤߤޤ
#===============================================================================
sub delete_tag {
	my $text = shift;
	$text =~ s/<(.|\s)+?>//g;
	return $text;
}

#==============================================================================
# time()ͤW3CDTFդˤ֤ޤ
#==============================================================================
sub W3CDTF {
	my ($time, $tz_str) = @_;
	my ($sec, $min, $hour, $mday, $mon, $year) = (localtime($time))[0..5];
	return sprintf('%04d-%02d-%02dT%02d:%02d:%02d%.6s',
	               $year+1900,$mon+1,$mday,$hour,$min,$sec,$tz_str);
}

#==============================================================================
# URL󥳡ɤޤ
#==============================================================================
sub url_encode {
	my $retstr = shift;
	$retstr =~ s/([^ 0-9A-Za-z])/sprintf("%%%.2X", ord($1))/eg;
	$retstr =~ tr/ /+/;
	return $retstr;
}

#==============================================================================
# URLǥɤޤ
#==============================================================================
sub url_decode{
	my $retstr = shift;
	$retstr =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;
	return $retstr;
}
#==============================================================================
# դMM/DD HH:MM˥եޥåȤޤ
#==============================================================================
sub format_short_date {
	my $date = shift;
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($date);
	
	#$year = $year + 1900;
	$mon  = $mon  + 1;
	
	return sprintf("%02d/%02d %02d:%02d",$mon,$mday,$hour,$min);
}
#==============================================================================
# إåɽ
#==============================================================================
sub print_header {
	my $title   = shift;
	my $theme   = shift;
	my $css     = shift;
	my $rssfile = shift;
	
	print "<html>\n";
	print "<head>\n";
	print "<title>",&Util::escapeHTML($title),"</title>\n";
	print "<link rel=\"stylesheet\" type=\"text/css\" href=\"$theme\">\n";
	print "<style type=\"text/css\">\n";
	print $css;
	print "</style>\n";
	print "</head>\n";
	print "<body>\n";

	print "<div class=\"adminmenu\">\n";
	print "  <span class=\"adminmenu\">\n";
	print "    <a href=\"diary.cgi?".time()."\">ǿ</a>\n";
	print "  </span>\n";
	if($rssfile ne "" && -e $rssfile){
		print "  <span class=\"adminmenu\">\n";
		print "    <a href=\"$rssfile\">RSS</a>\n";
		print "  </span>\n";
	}
	if($main::LOGIN==1){
		my ($n_sec, $n_min, $n_hour, $n_mday, $n_mon, $n_year) = localtime(time());
		$n_year += 1900;
		$n_mon  += 1;
		print "  <span class=\"adminmenu\">\n";
		print "    <a href=\"diary.cgi?do_edit=1&Year=$n_year&Month=$n_mon&Day=$n_mday\"></a>\n";
		print "  </span>\n";
		print "  <span class=\"adminmenu\">\n";
		print "    <a href=\"diary.cgi?do_config=1\"></a>\n";
		print "  </span>\n";
	}
	print "</div>\n";
	print "<h1>".&Util::escapeHTML($title)."</h1>\n";
}
#==============================================================================
# եåɽ
#==============================================================================
sub print_footer {
	print "<div class=\"footer\">\n";
	print "  Powered by <a href=\"$SNS::URL\">ܤƥ $SNS::VERSION</a>";
	print "</div>\n";
	print "</body>\n";
	print "</html>\n";
}
#==============================================================================
# ƥȤɤ߹
#==============================================================================
sub load_text {
	my $file = shift;
	
	open(DATA,$file) or return "";
	my $content = join("",<DATA>);
	close(DATA);
	
	return $content;
}
#==============================================================================
# ƥȤ¸
#==============================================================================
sub save_text {
	my $file    = shift;
	my $content = shift;
	
	open(DATA,">$file") or die "$file¸˼Ԥޤ";
	print DATA $content;
	close(DATA);
}
#==============================================================================
# ɤ߹ߡϥåե󥹤֤
#==============================================================================
sub load_config {
	my $file = shift;
	open(CONFIG,$file);
	my $config = {};
	while(my $line = <CONFIG>){
		chomp($line);
		my ($key,$value) = split(/=/,$line);
		
		$config->{$key} = $value;
	}
	close(CONFIG);
	
	return $config;
}
#==============================================================================
# ¸
#==============================================================================
sub save_config {
	my $file   = shift;
	my $config = shift;
	open(CONFIG,">$file");
	foreach my $key (keys(%$config)){
		print CONFIG "$key=".$config->{$key}."\n";
	}
	close(CONFIG);
}
#==============================================================================
# ƥȥե
#==============================================================================
sub textfield {
	my $name  = shift;
	my $size  = shift;
	my $value = shift;
	
	return "<input type=\"text\" name=\"".&escapeHTML($name)."\" size=\"$size\" value=\"".&escapeHTML($value)."\">";
}
#==============================================================================
# åܥå
#==============================================================================
sub checkbox {
	my $name     = shift;
	my $value    = shift;
	my $checked  = shift;
	
	my $buf = "<input type=\"checkbox\" name=\"".&escapeHTML($name)."\" value=\"".&escapeHTML($value)."\"";
	if($checked==1 || $checked eq "true"){
		$buf .= " checked";
	}
	$buf .= "> ";
	return $buf;
}
#==============================================================================
# ƥȥꥢ
#==============================================================================
sub textarea {
	my $name     = shift;
	my $cols     = shift;
	my $rows     = shift;
	my $value    = shift;
	
	return "<textarea name=\"".&escapeHTML($name)."\" cols=\"$cols\" rows=\"$rows\">".&escapeHTML($value)."</textarea>\n";
}
#==============================================================================
# ܥܥå
#==============================================================================
sub combobox {
	my $name     = shift;
	my $items    = shift;
	my $selected = shift;
	
	my $buf = "<select name=\"".&Util::escapeHTML($name)."\">\n";
	foreach my $item (@$items){
		$buf .= "  <option value=\"".&Util::escapeHTML($item->{VALUE})."\"";
		if($item->{VALUE} eq $selected){
			$buf .= " selected";
		}
		$buf .= ">".&Util::escapeHTML($item->{LABEL})."</option>\n";
	}
	$buf .= "</select>\n";
	return $buf;
}

###############################################################################
#
# SNS::Diary
#
###############################################################################
package SNS::Diary;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	$self->{comment} = [];
	return bless $self,$class;
}

#==============================================================================
# ǯ⤷ꤷޤ
#==============================================================================
sub year {
	my $self = shift;
	my $year = shift;
	if(defined($year)){
		$self->{year} = $year;
	} else {
		return $self->{year};
	}
}

#==============================================================================
# ⤷ꤷޤ
#==============================================================================
sub month {
	my $self  = shift;
	my $month = shift;
	if(defined($month)){
		$self->{month} = $month;
	} else {
		return $self->{month};
	}
}

#==============================================================================
# ⤷ꤷޤ
#==============================================================================
sub day {
	my $self = shift;
	my $day  = shift;
	if(defined($day)){
		$self->{day} = $day;
	} else {
		return $self->{day};
	}
}

#==============================================================================
# YYYY-MM-DDդޤ
#==============================================================================
sub date {
	my $self = shift;
	return sprintf("%04d-%02d-%02d",$self->year,$self->month,$self->day);
}

#==============================================================================
# ⤷ꤷޤ
#==============================================================================
sub style {
	my $self  = shift;
	my $style = shift;
	if(defined($style)){
		$self->{style} = $style;
	} else {
		return $self->{style};
	}
}

#==============================================================================
# ѡ⤷ꤷޤ
#==============================================================================
sub parser {
	my $self   = shift;
	my $parser = shift;
	if(defined($parser)){
		$self->{parser} = $parser;
	} else {
		return $self->{parser};
	}
}

#==============================================================================
# ʸѡƥΥꥹȤ֤ޤ
#==============================================================================
sub parse {
	my $self    = shift;
	
	my $parser  = $self->parser;
	$parser->init;
	
	return $parser->parse($self->content);
}

#==============================================================================
# ʸ⤷ꤷޤ
#==============================================================================
sub content {
	my $self    = shift;
	my $content = shift;
	if(defined($content)){
		$self->{content} = $content;
	} else {
		return $self->{content};
	}
}

#==============================================================================
# Ȥ⤷ꤷޤ
#==============================================================================
sub comment {
	my $self    = shift;
	my $comment = shift;
	if(defined($comment)){
		$self->{comment} = $comment;
	} else {
		return $self->{comment};
	}
}

#==============================================================================
# źեե⤷ꤷޤ
#==============================================================================
sub attach {
	my $self   = shift;
	my $attach = shift;
	if(defined($attach)){
		$self->{attach} = $attach;
	} else {
		return $self->{attach};
	}
}

#==============================================================================
# ǽ⤷ꤷޤ
#==============================================================================
sub lastmodified {
	my $self     = shift;
	my $modtime  = shift;
	if(defined($modtime)){
		$self->{lastmodified} = $modtime;
	} else {
		return $self->{lastmodified};
	}
}

###############################################################################
#
# ץ饰󥯥饹
#
###############################################################################
package SNS::Plugin;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class      = shift;
	my $plugin_dir = shift;
	
	$SNS::Plugin::cgi = shift;
	
	my $self = {};
	$self->{plugin_dir} = $plugin_dir;
	$self = bless $self,$class;
	$self->_init;
	return $self;
}
#==============================================================================
# 
#==============================================================================
sub _init {
	my $self = shift;
	my @files = glob($self->{plugin_dir}."/*.pl");
	foreach my $file (@files){
		eval("require \"$file\";");
	}
}
#==============================================================================
# ץȥåȤɸϤ˽񤭽Фޤ
#==============================================================================
sub process {
	my $self   = shift;
	my $source = shift;
	my $diary  = shift;
	
	$SNS::Plugin::diary = $diary;
	
	#¹ԲǽʷѴ
	$source =~ s/\\/\\\\/g;
	$source =~ s/'/\\'/g;
	$source =~ s/<%=(.*?)%>/<%print ($1)%>/g;
	$source =~ s/<%/');/g;
	$source =~ s/%>/;print ('/g;
	$source = "print ('$source');\n";
	#ץȼ¹
	eval $source;
	# 顼ȯ
	print "<font class=\"alert\">".$@."</font>" if $@;
}
###############################################################################
#
# HTMLΥѡ
#
###############################################################################
package SNS::HTMLParser;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}

#==============================================================================
# Ԥޤ
#==============================================================================
sub init {
	my $self = shift;
}

#==============================================================================
# ѡƥΥꥹȤ֤ޤ
#==============================================================================
sub parse {
	my $self   = shift;
	my $source = shift;
	my @lines = split(/\n/,$source);
	
	my @sections;
	my $section   = 0;
	my $sec_title = "";
	my $sec_body  = "";
	my $start_tag = 0;
	my $count     = 0;
	
	foreach my $line (@lines){
		if($line eq ""){
			if($sec_title ne ""){
				push(@sections,{ID=>$count,TITLE=>$sec_title,CONTENT=>$sec_body});
				$count++;
			}
			$section   = 0;
			$sec_title = "";
			$sec_body  = "";
			$start_tag = 0;
			
		} elsif($section == 0) {
			$sec_title = $line;
			$section   = 1;
			
		} else {
			if($line =~ /^\s*<\/{0,1}(ol|ul|li|pre|blockquote|h)/i){
				$sec_body .= "$line\n";
				if($start_tag==0){
					$start_tag = 1;
				} else {
					$start_tag = 0;
				}
			} elsif($start_tag==1){
				$sec_body .= "$line\n";
				
			} else {
				$sec_body .= "<p>$line</p>\n";
			}
		}
	}
	
	if($sec_title ne ""){
		push(@sections,{ID=>$count,TITLE=>$sec_title,CONTENT=>$sec_body});
	}
	
	return @sections;
}

###############################################################################
#
# WikiΥѡ
#
###############################################################################
package SNS::WikiParser;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}

#==============================================================================
# Ԥޤ
#==============================================================================
sub init {
	my $self = shift;
	
	$self->{pre}     = "";
	$self->{quote}   = "";
	$self->{table}   = 0;
	$self->{level}   = 0;
	$self->{para}    = 0;
	$self->{p_cnt}   = 0;
	$self->{dl_flag} = 0;
	$self->{dt}      = "";
	$self->{dd}      = "";
	$self->{sec_title} = "";
	$self->{sec_body}  = "";
}

#==============================================================================
# ѡƥΥꥹȤ֤ޤ
#==============================================================================
sub parse {
	my $self   = shift;
	my $source = shift;
	
	my @lines = split(/\n/,$source);
	my @sections;
	my $count = 0;
	
	foreach my $line (@lines){
		# ʣԤ
		$self->_multi_dl($line);
		
		my $word1 = substr($line,0,1);
		my $word2 = substr($line,0,2);
		my $word3 = substr($line,0,3);
		
		if($line ne "" && $self->{sec_title} eq ""){
			$self->{sec_title} = join("",$self->_parse_line($line));
			next;
		}
		
		# 
		if($line eq ""){
			$self->_line_paragraph();
			if($self->{sec_title} ne ""){
				push(@sections,{ID=>$count,TITLE=>$self->{sec_title},CONTENT=>$self->{sec_body}});
				$self->{sec_title} = "";
				$self->{sec_body}  = "";
				$count++;
			}
			next;
		}
		
		# PRE
		if($word1 eq " " || $word1 eq "\t"){
			$self->_line_pre($line);
			
		# 
		} elsif($word3 eq "***"){
			my @obj = $self->_parse_line(substr($line,3));
			$self->_line_list(3,\@obj);
			
		} elsif($word2 eq "**"){
			my @obj = $self->_parse_line(substr($line,2));
			$self->_line_list(2,\@obj);
			
		} elsif($word1 eq "*"){
			my @obj = $self->_parse_line(substr($line,1));
			$self->_line_list(1,\@obj);
			
		# ֹդ
		} elsif($word3 eq "+++"){
			my @obj = $self->_parse_line(substr($line,3));
			$self->_line_numlist(3,\@obj);
			
		} elsif($word2 eq "++"){
			my @obj = $self->_parse_line(substr($line,2));
			$self->_line_numlist(2,\@obj);
			
		} elsif($word1 eq "+"){
			my @obj = $self->_parse_line(substr($line,1));
			$self->_line_numlist(1,\@obj);
			
		# ʿ
		} elsif($line eq "----"){
			$self->_line_hr();
		
		# 
		} elsif($word2 eq '""'){
			my @obj = $self->_parse_line(substr($line,2));
			$self->_line_quote(\@obj);
			
		# 
		} elsif(index($line,":")==0 && index($line,":",1)!=-1){
			if(index($line,":::")==0){
				$self->{dd} .= substr($line,3);
				next;
			}
			if(index($line,"::")==0){
				if($self->{dt} ne "" || $self->{dd} ne ""){
					$self->_multi_dl;
				}
				$self->{dt} = substr($line,2);
				$self->{dl_flag} = 1;
				next;
			}
			my $dt = substr($line,1,index($line,":",1)-1);
			my $dd = substr($line,index($line,":",1)+1);
			my @obj1 = $self->_parse_line($dt);
			my @obj2 = $self->_parse_line($dd);
			$self->_line_dl(\@obj1,\@obj2);
			
		# ơ֥
		} elsif($word1 eq ","){
			if($line =~ /,$/){
				$line .= " ";
			}
			my @spl = split(/,/,substr($line,1));
			my @array;
			foreach my $value (@spl){
				my @cell = $self->_parse_line($value);
				push @array,\@cell;
			}
			$self->_line_table(\@array);
			
		# ʤ
		} else {
			my @obj = $self->_parse_line($line);
			$self->_line_text(\@obj);
		}
	}
	
	# ʣԤ
	$self->_multi_dl;
	
	# ѡλ
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	if($self->{sec_title} ne ""){
		push(@sections,{ID=>$count,TITLE=>$self->{sec_title},CONTENT=>$self->{sec_body}});
	}
	
	return @sections;
}

#===============================================================================
# ʣԤ
#===============================================================================
sub _multi_dl {
	my $self = shift;
	my $line = shift;
	if($self->{dl_flag}==1 && (index($line,":")!=0 || !defined($line))){
		my @obj1 = $self->_parse_line($self->{dt});
		my @obj2 = $self->_parse_line($self->{dd});
		$self->_line_dl(\@obj1,\@obj2);
		$self->{dl_flag} = 0;
		$self->{dt} = "";
		$self->{dd} = "";
	}
}

#==============================================================================
# ꥹ
#==============================================================================
sub _line_list {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->_end_pre;
	$self->_end_table;
	
	my $html = join("",@$obj);
	my $plus = 1;
	
	if($level < $self->{level}){ $plus = -1; }
	if($level==$self->{level}){
		$self->{sec_body} .= "</li>\n";
	}
	while($level != $self->{level}){
		if($plus==1){
			$self->{sec_body} .= "<ul>\n";
			push(@{$self->{close_list}},"</ul>");
		} else {
			$self->{sec_body} .= "</li>\n";
			$self->{sec_body} .= pop(@{$self->{close_list}});
		}
		$self->{level} += $plus;
	}
	
	$self->{sec_body} .= "<li>".$html."\n";
}

#==============================================================================
# ֹդꥹ
#==============================================================================
sub _line_numlist {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->_end_pre;
	$self->_end_table;
	
	my $html = join("",@$obj);
	my $plus = 1;
	
	if($level < $self->{level}){ $plus = -1; }
	if($level==$self->{level}){
		$self->{sec_body} .= "</li>\n";
	}
	while($level != $self->{level}){
		if($plus==1){
			$self->{sec_body} .= "<ol>\n";
			push(@{$self->{close_list}},"</ol>");
		} else {
			$self->{sec_body} .= "</li>\n";
			$self->{sec_body} .= pop(@{$self->{close_list}});
		}
		$self->{level} += $plus;
	}
	$self->{sec_body} .= "<li>".$html."\n";
}

#==============================================================================
# ꥹȤνλ
#==============================================================================
sub _end_list {
	my $self  = shift;
	if ($self->{level}!=0) {
		$self->{sec_body} .= "</li>\n";
		while($self->{level}!=0){
			$self->{sec_body} .= pop(@{$self->{close_list}});
			$self->{level} += -1;
		}
	}
}

#==============================================================================
# ʿ
#==============================================================================
sub _line_hr {
	my $self = shift;
	
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	$self->{sec_body} .= "<hr>\n";
}

#==============================================================================
# ڤ
#==============================================================================
sub _line_paragraph {
	my $self = shift;
	
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
}

#==============================================================================
# ѥƥ
#==============================================================================
sub _line_pre {
	my $self  = shift;
	my $text  = shift;
	
	if($self->{para}==1){
		$self->{sec_body} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->_end_list;
	$self->_end_table;
	$self->_end_quote;
	
	$text =~ s/^\s//;
	$self->{pre} .= Util::escapeHTML($text)."\n";
}

sub _end_pre {
	my $self  = shift;
	if($self->{pre} ne ""){
		$self->{sec_body} .= "<pre>".$self->{pre}."</pre>";
		$self->{pre} = "";
	}
}

#==============================================================================
# ơ֥
#==============================================================================
sub _line_table {
	my $self = shift;
	my $row  = shift;
	$self->_end_list;
	$self->_end_pre;
	$self->_end_quote;
	
	if($self->{table}==0){
		$self->{table}=1;
		$self->{sec_body} .= "<table>\n";
		$self->{sec_body} .= "<tr>";
		foreach(@$row){
			my $html = join("",@$_);
			$self->{sec_body} .= "<th>".$html."</th>";
		}
		$self->{sec_body} .= "</tr>\n";
	} else {
		$self->{table}=2;
		$self->{sec_body} .= "<tr>";
		foreach(@$row){
			my $html = join("",@$_);
			$self->{sec_body} .= "<td>".$html."</td>";
		}
		$self->{sec_body} .= "</tr>\n";
	}
}

sub _end_table {
	my $self = shift;
	if($self->{table}!=0){
		$self->{table} = 0;
		$self->{sec_body} .= "</table>\n";
	}
}

#==============================================================================
# Խ񼰤˳ʤ
#==============================================================================
sub _line_text {
	my $self = shift;
	my $obj  = shift;
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	my $html = join("",@$obj);
	
	if($self->{para}==0){
		$self->{sec_body} .= "<p>";
		$self->{para} = 1;
	}
	$self->{sec_body} .= $html;
	$self->_line_paragraph;
}

#==============================================================================
# 
#==============================================================================
sub _line_quote {
	my $self = shift;
	my $obj  = shift;
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	my $html = join("",@$obj);
	$self->{quote} .= "<p>".$html."</p>\n";
}

sub _end_quote {
	my $self = shift;
	if($self->{quote} ne ""){
		$self->{sec_body} .= "<blockquote>".$self->{quote}."</blockquote>\n";
		$self->{quote} = "";
	}
}

#==============================================================================
# 
#==============================================================================
sub _line_dl {
	my $self = shift;
	my $obj1 = shift;
	my $obj2 = shift;
	
	$self->_end_list;
	$self->_end_pre;
	$self->_end_table;
	$self->_end_quote;
	
	my $html1 = join("",@$obj1);
	my $html2 = join("",@$obj2);
	
	$self->{sec_body} .= "<dl>\n<dt>".$html1."</dt>\n<dd>".$html2."</dd>\n</dl>\n";
}

#===============================================================================
# ʬѡ
#===============================================================================
sub _parse_line {
	my $self   = shift;
	my $source = shift;
	my @array  = ();
	
	# ץ饰
	if($source =~ /({{)(.+?)(}})/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<%=$label%>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# Ǥä
	} elsif($source =~ /(==)(.+?)(==)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<del>".join("",$self->_parse_line($label))."</del>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# ܡ
	} elsif($source =~ /(''')(.+?)(''')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<strong>".join("",$self->_parse_line($label))."</strong>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
	
	# å
	} elsif($source =~ /('')(.+?)('')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<em>".join("",$self->_parse_line($label))."</em>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# 
	} elsif($source =~ /(__)(.+?)(__)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<ins>".join("",$self->_parse_line($label))."</ins>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }

	# ̾
	} elsif($source =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
	    ||  $source =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<a href=\"$url\">".&Util::escapeHTML($label)."</a>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	# URL
	} elsif($source =~ /(http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $url = $&;
		if($pre ne ""){ push(@array,$self->_parse_line($pre)); }
		push @array,"<a href=\"$url\">".&Util::escapeHTML($url)."</a>";
		if($post ne ""){ push(@array,$self->_parse_line($post)); }
		
	} else {
		push @array,&Util::escapeHTML($source);
	}
	
	return @array;
}
