/**
 *	@file	events.js
 *
 *	Alpha から呼び出されるイベントハンドラの定義が含まれています。
 *	Alpha の設定を変更するにはイベントハンドラを書き換えます。
 *
 *	@author	exeal
 *	@date	2004/04/20
 */


/**
 *	Alpha 起動時に呼び出される
 *	@param args : Arguments	コマンドライン
 */
function OnApplicationInitialized(args) {
	// 文書タイプの登録
	var conf = Ambient.Configurations;
	conf.AddDocumentType("ReadMe", "readme.txt", "", true);	// お遊び (^^;
	conf.AddDocumentType("マクロスクリプト構成", "macros.xml", "", true);
	conf.AddDocumentType("テキスト", "*.txt;*.wtx");
	conf.AddDocumentType("JavaScript", "*.js", "WScript $F");
	conf.AddDocumentType("VBScript", "*.vbs", "WScript $F");
	conf.AddDocumentType("Perl", "*.pl;*.pm;*.cgi", "perl $F");
	conf.AddDocumentType("Ruby", "*.rb;*.so", "ruby $F");
	conf.AddDocumentType("Windows Script Host", "*.wsf;*.wsh", "WScript $F");
	conf.AddDocumentType("Windows Script Component", "*.wsc", "WScript $F");
	conf.AddDocumentType("XHTML", "*.htm;*.html", "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" $F");
	conf.AddDocumentType("XML", "*.xml", "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" $F");

	// キー割り当て
	var keys = conf.KeyboardScheme;
/*	keys.Assign("Ctrl+N", 1000);
	keys.Assign("Ctrl+O", 1002);
	keys.Assign("Ctrl+F4", 1003);
	keys.Assign("Ctrl+S", 1005);
	keys.Assign("Ctrl+Shift+S", 1006);
	keys.Assign("Alt+F4", 1010);
	keys.Assign("Del", 2000);
	keys.Assign("Ctrl+Shift+L", 2004);
	keys.Assign("Ctrl+Z", 2007);
	keys.Assign("Alt+Bs", 2007);
	keys.Assign("Ctrl+Y", 2008);
	keys.Assign("Ctrl+Shift+Z", 2008);
	keys.Assign("Shift+Alt+Bs", 2008);
	keys.Assign("Ctrl+X", 2009);
	keys.Assign("Shift+Del", 2009);
	keys.Assign("Ctrl+C", 2010);
	keys.Assign("Ctrl+Ins", 2010);
	keys.Assign("Ctrl+V", 2011);
	keys.Assign("Shift+Ins", 2011);
	keys.Assign("Shift+Alt+X", 2016);
	keys.Assign("Alt+X", 2017);
	keys.Assign("Ctrl+Shift+@", 2018);
	keys.Assign("Ctrl+Shift+7", 2019);
	keys.Assign("Ctrl+^", 2020);
	keys.Assign("Ctrl+Shift+^", 2021);
	keys.Assign("Ctrl+:", 2022);
	keys.Assign("Ctrl+,", 2023);
	keys.Assign("Ctrl+Sp", 2026);
	keys.Assign("Ctrl+A", 2055);
	keys.Assign("Ctrl+W", 2056);
	keys.Assign("Ctrl+Shift+-", 2068);
	keys.Assign("Ctrl+-", 2069);
	keys.Assign("Shift+Alt+Right", 2070);
	keys.Assign("Shift+Alt+Left", 2071);
	keys.Assign("Shift+Alt+Down", 2072);
	keys.Assign("Shift+Alt+Up", 2073);
	keys.Assign("Shift+Alt+End", 2074);
	keys.Assign("Shift+Alt+Home", 2075);
	keys.Assign("Ctrl+Shift+Alt+Right", 2076);
	keys.Assign("Ctrl+Shift+Alt+Left", 2077);
	keys.Assign("Ctrl+Shift+V", 2080);
	keys.Assign("Ctrl+Shift+Ins", 2080);
	keys.Assign("Ctrl+U", 2081);
	keys.Assign("Ctrl+Shift+U", 2082);
	keys.Assign("Ctrl+F", 3000);
	keys.Assign("F3", 3001);
	keys.Assign("Shift+F3", 3002);
	keys.Assign("Ctrl+H", 3003);
	keys.Assign("Ctrl+G", 3008);
	keys.Assign("Ctrl+F2", 3009);
	keys.Assign("F2", 3010);
	keys.Assign("Shift+F2", 3011);
	keys.Assign("Ctrl+Shift+F2", 3012);
	keys.Assign("Alt+F2", 3013);
	keys.Assign("Ctrl+[", 3014);
	keys.Assign("Ctrl+Shift+[", 3015);
	keys.Assign("Ctrl+I", 3016);
	keys.Assign("Alt+F5", 4005);
	keys.Assign("Ctrl+Tab", 4007);
	keys.Assign("Ctrl+Shift+Tab", 4008);
	keys.Assign("Ctrl+Shift+R", 5000);
	keys.Assign("Ctrl+Shift+P", 5001);
	keys.Assign("F5", 6003);
	keys.Assign("Shift+F5", 6004);
	keys.Assign("Ctrl+Alt+U", 11300);
	keys.Assign("Ctrl+Shift+Alt+U", 11301);
	keys.Assign("F8", 11303);
	keys.Save("default");*/
	keys.Load("default");
	conf.Apply();

	// ウィンドウの初期状態。
	// 起動時のウィンドウの位置やサイズを変える場合は
	// コメントを外し、値を指定してください
//	Ambient.Left = 0;
//	Ambient.Top = 0;
}

/**
 *	文書タイプ適用時に呼び出される
 *	@param typeName : string		タイプ名
 *	@param editor : TextProcessor	適用先テキストエディタ
 */
function OnApplyDocumentType(typeName, editor) {
	var lexer = editor.Lexer;
	var pref = editor.Preferences;
	var cookies = new Object;

	pref.Reset();

	// NOTE:
	// cookies は注釈 (コメント) とキーワードに名前を付けるのに使ってます。
	// Lexer::AddXXXX の戻り値のコレクションで、
	// 例えば定数を表すキーワードの場合は cookies.constant で
	// クッキー値にアクセスできます。
	// (この管理方法は一例であり、別の書き方をしても構いません)

	pref.TokenDecoration("link").BorderStyle = 1;
	pref.TokenDecoration("link").BorderColor = 0x3333FF;

	// default
	if(typeName == "default") {
	}

	// ReadMe
	else if(typeName == "ReadMe") {
		lexer.TokenEnabled("otherQuotation") = false;
		pref.TokenDecoration("normal").Color = 0x666666;
		cookies.bracket = lexer.AddSinglelineAnnotation("[", "]", 2);
		pref.TokenDecoration("annotation_".concat(cookies.bracket)).Color = 0xFFFFFF;
		pref.TokenDecoration("annotation_".concat(cookies.bracket)).BackgroundColor = 0x666666;
		pref.TokenDecoration("annotation_".concat(cookies.bracket)).BoldFont = true;
		cookies.productName = lexer.AddKeywords("Alpha");
		pref.TokenDecoration("keyword_".concat(cookies.productName)).BorderStyle = 7;
		pref.TokenDecoration("link").BorderStyle = 5;
	}

	// マクロスクリプト構成
	else if(typeName == "マクロスクリプト構成") {
		applyXML(lexer, cookies);
		cookies.xmlElement = lexer.AddKeywords("description macro macros script");
		cookies.xmlAttribute = lexer.AddKeywords("language name src");
	}

	// テキスト
	else if(typeName == "テキスト") {
		pref.TabWidth = 8;
		cookies.quotation = lexer.AddSinglelineAnnotation(">", "", 2);
		pref.TokenDecoration("annotation_".concat(cookies.quotation)).Color = 0x990000;
		cookies.additional = lexer.AddSinglelineAnnotation("#", "", 2);
		pref.TokenDecoration("annotation_".concat(cookies.additional)).Color = 0x3366FF;
	}

	// JavaScript 1.5
	else if(typeName == "JavaScript") {
		cookies.singlelineDocumentationComment = lexer.AddSinglelineAnnotation("///");
		cookies.multilineDocumentationComment = lexer.AddMultilineAnnotation("/**", "*/");
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("//");
		cookies.multilineComment = lexer.AddMultilineAnnotation("/*", "*/");
		cookies.entity = lexer.AddKeywords("function var");
		cookies.control = lexer.AddKeywords("break case continue default do else for if return switch while with");
		cookies.operator = lexer.AddKeywords("delete in instanceof new typeof void ");
		cookies.exception = lexer.AddKeywords("catch throw try");
		cookies.constant = lexer.AddKeywords("false Infinity null this true undefined");
		cookies.futureReserved = lexer.AddKeywords("abstract boolean byte char class double enum extends final float goto implements int interface long native package private protected public short static super synchronized throws transient volatile");
		cookies.msExtended = lexer.AddKeywords("@cc_on @if @set debugger");
		cookies.nsExtended = lexer.AddKeywords("const export get import set");
		lexer.SetOperators("++ -- + - ~ ! * / % << >> >>> < > <= >= == != === !== & ^ | && || ? : = *= /= %= += -= <<= >>= >>>= &= ^= |= , ( ) . [ ]");
		lexer.SetAdditionalAlphabets("@_$");
	}

	// VBScript 5.6
	else if(typeName == "VBScript") {
		lexer.IgnoreCase = true;
		cookies.singlelineDocumentationComment = lexer.AddSinglelineAnnotation("\'\'\'");
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("\'");
		cookies.vbscriptPragma = lexer.AddSinglelineAnnotation("Option ", "", 1);
//		lexer.AddSinglelineAnnotation("Rem", "", 1);
		cookies.entity = lexer.AddKeywords("Class Const Dim Function Get Private Property Public ReDim Set Sub");
		cookies.attribute = lexer.AddKeywords("ByRef ByVal");
		cookies.control = lexer.AddKeywords("Case Default Do Each Else ElseIf End Error Exit For GoTo If In Loop Next On Resume Select Then Wend While");
		cookies.operator = lexer.AddKeywords("And Eqv Imp Is Mod New Not Or Xor");
		cookies.command = lexer.AddKeywords("Call Raise Execute ExecuteGlobal Let Randomize Stop");
		cookies.constant = lexer.AddKeywords("Empty False Me Null Nothing True");
		lexer.SetOperators("+ - ^ * / \ & = < <= > >= <> . ( )");
		lexer.SetAdditionalAlphabets("_");
		lexer.TokenEnabled("singleQuotation") = false;
	}

	// Perl
	else if(typeName == "Perl") {
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("#");
		cookies.multilineComment = lexer.AddMultilineAnnotation("=", "=cut", 1);
		cookies.entity = lexer.AddKeywords("local my package sub");
		cookies.control = lexer.AddKeywords("continue elsif else for foreach goto if last next redo return unless until while");
		cookies.operator = lexer.AddKeywords("and cmp eq ge gt le lt ne not or x xor");
		cookies.command = lexer.AddKeywords("format no require use");
		lexer.SetOperators("-> ++ -- ** ! ~ \ + - =~ !~ * / % . << >> < > <= >= == != <=> & | ^ && || .. ... ? : = += -= *= /= %= |= &= ^= <<= >>= **= ||= &&= .= x= , => ( ) [ ]");
		lexer.SetAdditionalAlphabets("_");
	}

	// Ruby
	else if(typeName == "Ruby") {
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("#");
		cookies.multilineComment = lexer.AddMultilineAnnotation("=begin", "=end", 1);
		cookies.entity = lexer.AddKeywords("alias class def defined? module undef");
		cookies.control = lexer.AddKeywords("BEGIN begin break case do else elsif END end for if in next redo retry return then unless until when while");
		cookies.operator = lexer.AddKeywords("and not or");
		cookies.command = lexer.AddKeywords("super yield");
		cookies.exception = lexer.AddKeywords("ensure raise rescue");
		cookies.constant = lexer.AddKeywords("__FILE__ __LINE__ false nil self true");
		lexer.SetOperators(":: . ** - + ! ~ * / % << >> & | ^ > >= < <= <=> == === != =~ !~ && || .. ... ? : = += -= *= /= %= |= &= ^= <<= >>= **= ||= &&= => ( ) [ ]");
		lexer.SetAdditionalAlphabets("@_!?$");
	}

	// Windows Script Host
	else if(typeName == "Windows Script Host") {
		applyXML(lexer, cookies);
		cookies.wshJobDecl = lexer.AddSinglelineAnnotation("<?job", "?>");
		cookies.xmlElement = lexer.AddKeywords("description example job named object package reference resource runtime script unnamed usage");
		cookies.xmlAttribute = lexer.AddKeywords("classid debug error guid helpstring id language many name object progid required src type version");
	}

	// Windows Script Component
	else if(typeName == "Windows Script Component") {
		applyXML(lexer, cookies);
		cookies.wshJobDecl = lexer.AddSinglelineAnnotation("<?component", "?>");
		cookies.xmlElement = lexer.AddKeywords("comment component event get implements method object package parameter property public put reference registration resource script");
		cookies.xmlAttribute = lexer.AddKeywords("classid debug default description dispid error events guid id internalName language name object progid remotable type version");
	}

	// XHTML 1.1
	else if(typeName == "XHTML") {
		applyXML(lexer, cookies);
		cookies.xmlElement = lexer.AddKeywords("a abbr acronym address applet area base bdo big blockquote body br button caption cite code col colgroup dd del dfn div dl dt em fieldset form frame frameset h1 h2 h3 h4 h5 h6 head hr html i iframe img input ins kbd label legend li link map meta noframe noscript object ol optgroup option p param pre q rb rbc rp rt rtc ruby samp script select small span strong style sub sup table tbody td textarea tfoot th thead title tr tt ul var");
		cookies.xmlAttribute = lexer.AddKeywords("abbr accept accept-charset accesskey action align alt archive axis border cellpadding cellspacing charset checked cite class classid codebase codetype cols colspan content coords data datetime declare defer dir disabled enctype for frame headers height href hreflang ismap http-equiv id label long maxlength media method multiple name nohref onblur onchange onclick ondblclick onfocus onkeydown onkeypress onkeyup onload onmousedown onmousemove onmouseout onmouseover onmouseup onreset onselect onsubmit onunload rbspan readonly rel rev rows rowspan rules scheme scope selected shape size span src standby summary tabindex title type usemap valign value valuetype version width xml:lang xml:space xmlns");
	}

	// XML
	else if(typeName == "XML")
		applyXML(lexer, cookies);

	if(typeName == "default");
	else if(typeName == "ReadMe"
			|| typeName == "テキスト") {
		pref.SelectEndOfLine = false;
		pref.ShowEndOfFile = false;
		pref.ShowEndOfLine = false;
		pref.ShowCurrentUnderline = false;
		pref.ShowWhiteSpaceAlternative = false;
		pref.ThinCaret = true;
	} else {	// プログラミング用の設定
		// 雑多な設定
		pref.SelectEndOfLine = true;
		pref.ShowEndOfFile = true;
		pref.ShowEndOfLine = true;
		pref.ShowCurrentUnderline = true;
		pref.ShowIndicatorMargin = true;
		pref.ShowLineNumber = true;
		pref.ThinCaret = false;
		pref.LineNumberBorderStyle = 4;
		pref.ShowWhiteSpaceAlternative = true;

		// 空白類文字
		pref.TokenDecoration("whiteSpace").Color = 0xD0E0E0;
		pref.TokenDecoration("tab").Color = 0xD0E0E0;

		// コメント
		if("singlelineComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.singlelineComment)).Color = 0x008000;
		if("multilineComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.multilineComment)).Color = 0x008000;
		if("singlelineDocumentationComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.singlelineDocumentationComment)).Color = 0x408000;
		if("multilineDocumentationComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.multilineDocumentationComment)).Color = 0x408000;

		// キーワード
		if("vbscriptPragma" in cookies) {
			pref.TokenDecoration("annotation_".concat(cookies.vbscriptPragma)).Color = 0xFFFFFF;
			pref.TokenDecoration("annotation_".concat(cookies.vbscriptPragma)).BackgroundColor = 0x666666;
			pref.TokenDecoration("annotation_".concat(cookies.vbscriptPragma)).BoldFont = true;
		}
		if("xmlDecl" in cookies) {
			pref.TokenDecoration("annotation_".concat(cookies.xmlDecl)).Color = 0xFFFFFF;
			pref.TokenDecoration("annotation_".concat(cookies.xmlDecl)).BackgroundColor = 0x666666;
		}
		if("xmlCDataSec" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.xmlCDataSec)).BackgroundColor = 0xFFFFF0;
		if("xmlDocType" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.xmlDocType)).Color = 0xFF8000;
		if("wshJobDecl" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.wshJobDecl)).Color = 0x808000;
		if("entity" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.entity)).Color = 0x0000FF;
		if("control" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.control)).Color = 0x0000FF;
		if("operator" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.operator)).Color = 0x800080;
		if("attribute" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.attribute)).Color = 0x0000FF;
		if("exception" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.exception)).Color = 0x0000FF;
		if("constant" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.constant)).Color = 0x800000;
		if("command" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.command)).Color = 0x0000FF;
		if("xmlElement" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.xmlElement)).Color = 0x800000;
		if("xmlAttribute" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.xmlAttribute)).Color = 0x008080;

		// その他
		pref.TokenDecoration("number").Color = 0x800000;
		pref.TokenDecoration("operator").Color = 0x666600;
		pref.TokenDecoration("singleQuotation").Color = 0x000066;
		pref.TokenDecoration("singleQuotation").BackgroundColor = 0xF6FFF6;
		pref.TokenDecoration("doubleQuotation").Color = 0x000066;
		pref.TokenDecoration("doubleQuotation").BackgroundColor = 0xF9F9FF;
//		pref.TokenDecoration("indicatorMargin").Color = 0x808080;
//		pref.TokenDecoration("indicatorMargin").BackgroundColor = 0xECE9D8;
		pref.TokenDecoration("lineNumber").Color = 0x008080;
		pref.TokenDecoration("emphaticLineNumber").Color = 0x008080;
		pref.TokenDecoration("emphaticLineNumber").BoldFont = true;
		pref.TokenDecoration("matchBrackets").Color = 0x990000;
		pref.TokenDecoration("matchBrackets").BoldFont = true;
		pref.TokenDecoration("endOfLine").Color = 0x669999;
		pref.TokenDecoration("endOfFile").Color = 0x006699;
		pref.TokenDecoration("endOfFile").BackgroundColor = 0x99CCFF;

		// XML 用の追加定義
		if(typeName == "マクロスクリプト構成"
				|| typeName == "XHTML" || typeName == "XML"
				|| typeName == "Windows Script Host" || typeName == "Windows Script Component") {
			pref.TokenDecoration("operator").Color = 0x3333FF;
			pref.TabWidth = 2;
		}
		// Unicode アルファベットの使用
		if(typeName == "VBScript" || typeName == "Perl" || typeName == "Ruby")
			lexer.UnicodeAlphabetsEnabled = false;
	}
}

/**
 *	XML 字句規則の適用
 *	@param lexer : Lexer	字句解析器
 *	@param cookies : Object	クッキーのコレクション
 */
function applyXML(lexer, cookies) {
	cookies.xmlDecl = lexer.AddMultilineAnnotation("<?xml", "?>");
	cookies.xmlDocType = lexer.AddMultilineAnnotation("<!DOCTYPE", ">");
	cookies.xmlCDataSec = lexer.AddMultilineAnnotation("<![CDATA[", "]]>");
	cookies.multilineComment = lexer.AddMultilineAnnotation("<!--", "-->");
	lexer.SetOperators("< > = </ />");
	lexer.SetAdditionalAlphabets(".-_:");
	lexer.TokenEnabled("number") = false;
}